/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class MabiIccoExecutor {
    private static final MabiIccoExecutor instance = new MabiIccoExecutor();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, runnable -> new Thread(runnable, "MabiIccoExecutor"));

    private MabiIccoExecutor() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                this.executor.shutdownNow();
            }
        }));
    }

    public static MabiIccoExecutor getInstance() {
        return instance;
    }

    private Runnable wrap(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        };
    }

    public void submit(Runnable runnable) {
        this.executor.submit(this.wrap(runnable));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2) {
        return this.executor.scheduleWithFixedDelay(this.wrap(runnable), l, l2, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l) {
        return this.scheduleWithFixedDelay(runnable, l, l);
    }
}

