/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.List;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterInputStream;

public final class Utils {
    private static final List<String> INVALID_NAMES = List.of("CON", "PRN", "AUX", "NUL", "COM0", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT0", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");

    public static String compress(String string) {
        return Utils.compress(string.getBytes());
    }

    public static String compress(byte[] byArray) {
        try {
            DeflaterInputStream deflaterInputStream = new DeflaterInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = deflaterInputStream.readAllBytes();
            return Base64.getEncoder().encodeToString(byArray2);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return null;
        }
    }

    public static byte[] decompress(String string) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
            return inflaterInputStream.readAllBytes();
        }
        catch (IOException | IllegalArgumentException exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static boolean isValidFile(File file) {
        try {
            Path path = file.toPath();
            if (System.getProperty("os.name").startsWith("Windows")) {
                String string = path.getFileName().toString().toUpperCase();
                int n = string.indexOf(46);
                if (string.indexOf(46) > 1) {
                    string = string.substring(0, n);
                }
                if (INVALID_NAMES.contains(string)) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

