/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jp.fourthline.mabiicco.MabiIccoExecutor;
import jp.fourthline.mabiicco.midi.ISoundDataLine;
import jp.fourthline.mabiicco.midi.IWavoutState;
import jp.fourthline.mmlTools.core.NanoTime;

public final class WavoutDataLine
implements SourceDataLine,
IWavoutState {
    private final SourceDataLine parent;
    private final AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private boolean rec = false;
    private OutputStream outputStream = null;
    private ByteArrayOutputStream tempOutputStream = null;
    private Runnable endNotify;
    private ISoundDataLine soundDataLine = null;
    private final AtomicInteger lineStallCounter = new AtomicInteger(0);
    private long time;
    private long curLen;

    private void reconnect() {
        this.parent.flush();
        System.out.println(System.currentTimeMillis() + " flush");
    }

    public WavoutDataLine() throws LineUnavailableException {
        this.parent = AudioSystem.getSourceDataLine(this.format);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public long getLen() {
        return this.curLen;
    }

    public void startRec(File file, Runnable runnable, int n) throws IOException {
        int n2 = n + 0x100000;
        System.out.println("startRec:" + n2);
        try {
            this.tempOutputStream = new ByteArrayOutputStream(n2);
            this.rec = true;
            this.outputStream = new FileOutputStream(file);
            this.endNotify = runnable;
            this.time = 0L;
            this.curLen = 0L;
        }
        catch (IOException iOException) {
            if (this.tempOutputStream != null) {
                this.tempOutputStream.close();
                this.tempOutputStream = null;
            }
            throw iOException;
        }
    }

    public void stopRec() {
        if (this.rec && this.endNotify != null) {
            this.rec = false;
            this.endNotify.run();
            this.endNotify = null;
        }
        this.rec = false;
    }

    public boolean isRec() {
        return this.rec;
    }

    @Override
    public void drain() {
        this.parent.drain();
    }

    @Override
    public void flush() {
        this.parent.flush();
    }

    @Override
    public void start() {
        this.parent.start();
    }

    @Override
    public void stop() {
        this.parent.stop();
    }

    @Override
    public boolean isRunning() {
        return this.parent.isRunning();
    }

    @Override
    public boolean isActive() {
        return this.parent.isActive();
    }

    @Override
    public AudioFormat getFormat() {
        return this.parent.getFormat();
    }

    @Override
    public int getBufferSize() {
        return this.parent.getBufferSize();
    }

    @Override
    public int available() {
        return this.parent.available();
    }

    @Override
    public int getFramePosition() {
        return this.parent.getFramePosition();
    }

    @Override
    public long getLongFramePosition() {
        return this.parent.getLongFramePosition();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.parent.getMicrosecondPosition();
    }

    @Override
    public float getLevel() {
        return this.parent.getLevel();
    }

    @Override
    public Line.Info getLineInfo() {
        return this.parent.getLineInfo();
    }

    @Override
    public void open() throws LineUnavailableException {
        this.parent.open();
    }

    @Override
    public void close() {
        this.parent.close();
    }

    @Override
    public boolean isOpen() {
        return this.parent.isOpen();
    }

    @Override
    public Control[] getControls() {
        return this.parent.getControls();
    }

    @Override
    public boolean isControlSupported(Control.Type type) {
        return this.parent.isControlSupported(type);
    }

    @Override
    public Control getControl(Control.Type type) {
        return this.parent.getControl(type);
    }

    @Override
    public void addLineListener(LineListener lineListener) {
        this.parent.addLineListener(lineListener);
    }

    @Override
    public void removeLineListener(LineListener lineListener) {
        this.parent.removeLineListener(lineListener);
    }

    @Override
    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        this.parent.open(audioFormat, n);
    }

    @Override
    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.parent.open(audioFormat);
    }

    private synchronized void createWavFile(byte[] byArray) {
        try {
            NanoTime nanoTime = NanoTime.start();
            long l = byArray.length;
            AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(byArray), this.format, l / (long)this.format.getFrameSize());
            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.outputStream);
            audioInputStream.close();
            this.outputStream.close();
            System.out.println("stopRec: " + l + "  " + nanoTime.ms() + "ms");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void wavoutEndCheck(byte[] byArray, int n, int n2) {
        if (!this.rec && this.tempOutputStream != null) {
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] == 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                byte[] byArray2 = this.tempOutputStream.toByteArray();
                MabiIccoExecutor.getInstance().submit(() -> this.createWavFile(byArray2));
                this.tempOutputStream = null;
            }
        }
    }

    @Override
    public int write(byte[] byArray, int n, int n2) {
        this.wavoutEndCheck(byArray, n, n2);
        if (this.tempOutputStream != null) {
            NanoTime nanoTime = NanoTime.start();
            this.curLen += (long)n2;
            this.tempOutputStream.write(byArray, n, n2);
            this.time += nanoTime.ms();
        }
        if (this.soundDataLine != null) {
            this.soundDataLine.write(byArray);
        }
        int n3 = this.parent.write(byArray, n, n2);
        this.lineStallCounter.set(0);
        return n3;
    }

    @Override
    public void setSoundDataLine(ISoundDataLine iSoundDataLine) {
        this.soundDataLine = iSoundDataLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDataLine() {
        WavoutDataLine wavoutDataLine = this;
        synchronized (wavoutDataLine) {
            if ("true".equals(System.getProperties().get("mabiicco.dlaf"))) {
                System.out.println("start DataLineAutoFlush.");
                MabiIccoExecutor.getInstance().scheduleWithFixedDelay(() -> {
                    if (this.lineStallCounter.incrementAndGet() > 3) {
                        this.reconnect();
                    }
                }, 100L);
            }
        }
    }
}

