/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.swing.JComponent;
import jp.fourthline.mabiicco.midi.ISoundDataLine;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.color.ColorSet;

public final class LevelMonitor
extends JComponent
implements ISoundDataLine {
    private static final long serialVersionUID = -3910689963056146451L;
    private static final int PIR = 600;
    private static final int R_PIR = 20;
    private int counter = 0;
    private int reduceCounter = 0;
    private static final ColorSet borderColor = ColorSet.create(Color.LIGHT_GRAY, new Color(96, 96, 96));
    private static final ColorSet barColor = ColorSet.create(Color.LIGHT_GRAY, Color.GRAY);
    private static final ColorSet holtBarColor = ColorSet.create(new Color(255, 128, 0), new Color(200, 96, 0));
    private final DataChannel left = new DataChannel();
    private final DataChannel right = new DataChannel();
    private final boolean dlsChain;
    private int paintCode = -1;

    public LevelMonitor() {
        this(true);
    }

    public LevelMonitor(boolean bl) {
        this.setPreferredSize(new Dimension(46, 20));
        this.dlsChain = bl;
        if (bl) {
            MabiDLS.getInstance().getWavout().setSoundDataLine(this);
        }
    }

    @Override
    public void write(byte[] byArray) {
        boolean bl = this.dlsChain ? MabiDLS.getInstance().getSequencer().isRunning() : true;
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        int n = shortBuffer.capacity() / 2;
        for (int i = 0; i < n; ++i) {
            int n2;
            if (bl) {
                this.left.update(shortBuffer.get());
                this.right.update(shortBuffer.get());
            }
            if (++this.counter < 600) continue;
            this.counter = 0;
            this.left.commit(bl);
            this.right.commit(bl);
            if (++this.reduceCounter >= 20) {
                this.reduceCounter = 0;
                this.left.reduce(bl);
                this.right.reduce(bl);
            }
            if ((n2 = (this.left.getCode() << 16) + this.right.getCode()) == this.paintCode) continue;
            this.repaint();
        }
    }

    DataChannel getLeft() {
        return this.left;
    }

    DataChannel getRight() {
        return this.right;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(borderColor.get());
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int n = 6;
        int n2 = this.getHeight() / 2;
        int n3 = (n2 - n) / 2;
        int n4 = n2 + n3 - 1;
        int n5 = 2;
        int n6 = this.left.paint(graphics, n5, n3, n) << 16;
        this.paintCode = n6 += this.right.paint(graphics, n5, n4, n);
        graphics.dispose();
    }

    public static final class DataChannel {
        private int max;
        private int currentMax;
        private int value;
        private int holtValue;

        public void update(int n) {
            this.max = Math.max(this.max, Math.abs(n));
        }

        public void commit(boolean bl) {
            if (bl) {
                double d = Math.log10((double)this.max / 32768.0) * 10.0 + 40.0;
                this.setValue(d);
            } else {
                this.setValue(0.0);
            }
            this.currentMax = this.max;
            this.max = 0;
        }

        private void setValue(double d) {
            this.value = Math.max(0, (int)d);
            this.holtValue = Math.max(this.value, this.holtValue);
        }

        public void reduce(boolean bl) {
            this.holtValue -= bl ? 2 : 10;
            this.holtValue = Math.max(0, Math.max(this.value, this.holtValue));
        }

        int getValue() {
            return this.value;
        }

        int getHoltValue() {
            return this.holtValue;
        }

        int getMax() {
            return this.currentMax;
        }

        private int getCode() {
            return this.encode(this.value, this.holtValue);
        }

        private int encode(int n, int n2) {
            int n3 = (n & 0xFF) << 8;
            return n3 |= n2 & 0xFF;
        }

        public int paint(Graphics graphics, int n, int n2, int n3) {
            int n4 = this.getValue();
            int n5 = this.getHoltValue();
            graphics.setColor(barColor.get());
            if (n4 > 0) {
                for (int i = 0; i <= n4; i += 3) {
                    graphics.fillRect(i, n2, 2, n3);
                }
            }
            graphics.setColor(holtBarColor.get());
            if (n5 > 0) {
                graphics.fillRect(n5 + n, n2, 2, n3);
            }
            return this.encode(n4, n5);
        }
    }
}

