/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.sound.midi.VoiceStatus;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoExecutor;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.UIUtils;

public final class PolyphonyMonitor {
    private static final int BAR_W = 3;
    private static final int MAX_V = 256;
    private static final int M_HEIGHT = 80;
    private int value = 0;
    private int max = 0;
    private final JDialog dialog;
    private final JTextField textField = new JTextField(9);
    private final JPanel mainPanel;
    private static PolyphonyMonitor instance = null;

    public static PolyphonyMonitor getInstance() {
        if (instance == null) {
            instance = new PolyphonyMonitor();
            ActionDispatcher.getInstance().addUpdateUIComponent(PolyphonyMonitor.instance.dialog);
            MabiIccoExecutor.getInstance().scheduleWithFixedDelay(instance::update, 100L);
        }
        return instance;
    }

    private PolyphonyMonitor() {
        this.dialog = new JDialog();
        this.dialog.setTitle(AppResource.appText("menu.polyphonyMonitor"));
        this.dialog.setResizable(false);
        this.dialog.setAlwaysOnTop(true);
        JButton jButton = new JButton("Clear");
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.reset());
        JButton jButton2 = new JButton("Close");
        jButton2.setFocusable(false);
        jButton2.addActionListener(actionEvent -> this.hide());
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.mainPanel = this.createMainPanel();
        jPanel2.add((Component)this.mainPanel, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.dialog.add(jPanel2);
        this.dialog.pack();
        this.textField.setEditable(false);
        this.textField.setFocusable(false);
        this.textField.setFont(AppResource.MONO_FONT);
        this.setValue(0);
    }

    public JPanel createMainPanel() {
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = -7206453832110132604L;

            private int x(int n) {
                return n * 3 + 16;
            }

            @Override
            public void paintComponent(Graphics graphics) {
                int n;
                int n2;
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                UIUtils.setRenderingHint(graphics2D);
                graphics2D.setColor(this.getForeground());
                for (n2 = 0; n2 <= 256; n2 += 32) {
                    n = this.x(n2) - 1;
                    graphics2D.drawLine(n, 16, n, 80);
                    graphics2D.drawString(Integer.toString(n2), n - 2, 12);
                }
                graphics2D.setColor(new Color(0, 128, 0));
                for (n2 = 1; n2 <= PolyphonyMonitor.this.value; ++n2) {
                    n = this.x(n2);
                    graphics2D.fillRect(n, 24, 1, 56);
                }
                graphics2D.setColor(Color.RED);
                if (PolyphonyMonitor.this.max > 0) {
                    n2 = this.x(PolyphonyMonitor.this.max);
                    graphics2D.fillRect(n2, 24, 1, 56);
                    graphics2D.drawString(Integer.toString(PolyphonyMonitor.this.max), n2 + 4, 32);
                }
            }
        };
        jPanel.setPreferredSize(new Dimension(832, 80));
        return jPanel;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    private void setValue(int n) {
        this.value = n;
        this.max = Math.max(this.max, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Poly:");
        if (n < 10) {
            stringBuilder.append("  ");
        } else if (n < 100) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(n);
        stringBuilder.append("    ");
        String string = stringBuilder.toString();
        if (!string.equals(this.textField.getText())) {
            this.textField.setText(string);
            this.mainPanel.repaint();
        }
    }

    public void update() {
        VoiceStatus[] voiceStatusArray = MabiDLS.getInstance().getSynthesizer().getVoiceStatus();
        int n = 0;
        for (VoiceStatus voiceStatus : voiceStatusArray) {
            if (!voiceStatus.active || voiceStatus.volume <= 0) continue;
            ++n;
        }
        this.setValue(n);
    }

    public void show(JFrame jFrame) {
        if (!this.dialog.isVisible()) {
            this.dialog.setLocationRelativeTo(jFrame);
            this.dialog.setVisible(true);
        }
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    private void reset() {
        this.max = 0;
        this.mainPanel.repaint();
    }
}

