/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.MainFrame;

public final class WavoutPanel
extends JPanel {
    private static final long serialVersionUID = -4756346595351421861L;
    private final JDialog dialog;
    private final MainFrame parentFrame;
    private final IMMLManager mmlManager;
    private final File file;
    private final JButton startButton = new JButton(AppResource.appText("wavout.start"));
    private final JButton cancelButton = new JButton(AppResource.appText("wavout.cancel"));
    private final JProgressBar progress = new JProgressBar();
    private Timer timer;
    private final long totalTime;
    private final long totalBytes;
    private final long MAX_SIZE = 0x8000000L;

    public WavoutPanel(MainFrame mainFrame, IMMLManager iMMLManager, File file) {
        this.dialog = new JDialog(mainFrame, AppResource.appText("wavout"), true);
        this.parentFrame = mainFrame;
        this.mmlManager = iMMLManager;
        this.file = file;
        this.totalTime = iMMLManager.getMMLScore().getTotalTime();
        this.totalBytes = (long)((double)this.totalTime * 44.1 * 4.0);
        this.initializePanel();
    }

    private void initializePanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        DecimalFormat decimalFormat = new DecimalFormat("#.0");
        this.progress.setMaximum((int)this.totalBytes);
        this.updateProgress(0);
        this.progress.setStringPainted(true);
        jPanel.add(new JLabel("File: " + this.file.getName()));
        jPanel.add(new JLabel("Size: " + decimalFormat.format((double)this.totalBytes / 1024.0 / 1024.0) + "MB"));
        jPanel.add(this.progress);
        this.startButton.addActionListener(actionEvent -> this.startWavout());
        this.cancelButton.addActionListener(actionEvent -> this.stopWavout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.startButton);
        jPanel2.add(this.cancelButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "South");
        if (this.totalBytes > 0x8000000L) {
            this.startButton.setEnabled(false);
        }
    }

    private void updateProgress(int n) {
        this.progress.setValue(n);
        NumberFormat numberFormat = NumberFormat.getInstance();
        n = Math.min(n, (int)this.totalBytes);
        this.progress.setString(numberFormat.format(n >> 10) + "/" + numberFormat.format(this.totalBytes >> 10));
    }

    private void startWavout() {
        System.out.println("startWavout(): " + this.totalBytes);
        this.startButton.setEnabled(false);
        this.parentFrame.disableNoplayItems();
        MabiDLS mabiDLS = MabiDLS.getInstance();
        try {
            mabiDLS.startWavout(this.mmlManager.getMMLScore(), this.file, this::stopWavout, (int)this.totalBytes);
        }
        catch (IOException iOException) {
            mabiDLS.stopWavout();
            JOptionPane.showMessageDialog(this.parentFrame, iOException.getLocalizedMessage(), "ERROR", 0);
            return;
        }
        this.timer = new Timer(100, actionEvent -> {
            int n = (int)mabiDLS.getWavout().getLen();
            this.updateProgress(n);
        });
        this.timer.start();
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }

    private void stopWavout() {
        this.parentFrame.enableNoplayItems();
        MabiDLS.getInstance().stopWavout();
        this.dialog.setVisible(false);
        if (this.timer != null) {
            ActionDispatcher.getInstance().showTime("wavout", MabiDLS.getInstance().getWavout().getTime());
            this.timer.stop();
            this.timer = null;
        }
    }
}

