/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.fourthline.mabiicco.ui.color.ColorPalette;

public final class ColorPicker
implements ColorSelectionModel {
    private final JColorChooser chooser;
    private final PreviewPane pane;
    private final ArrayList<ChangeListener> listener = new ArrayList();

    private ColorPicker() {
        this.pane = new PreviewPane(this);
        this.chooser = new JColorChooser(this);
    }

    private void show() {
        this.chooser.setPreviewPanel(this.pane);
        this.setSelectedTrackColor();
        JOptionPane.showConfirmDialog(null, this.chooser, "Color", 2, -1);
    }

    private void setSelectedTrackColor() {
        this.listener.forEach(changeListener -> changeListener.stateChanged(new ChangeEvent(this)));
        this.pane.repaint();
    }

    @Override
    public Color getSelectedColor() {
        return this.pane.getSelectedTrackBaseColor().getBaseColor();
    }

    @Override
    public void setSelectedColor(Color color) {
        this.pane.getSelectedTrackBaseColor().setColor(color);
        this.setSelectedTrackColor();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listener.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listener.remove(changeListener);
    }

    public static void main(String[] stringArray) {
        ColorPicker colorPicker = new ColorPicker();
        colorPicker.show();
    }

    static class PreviewPane
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = -8305524044560054314L;
        private final int WIDTH = 32;
        private final int HEIGHT = 14;
        private int selectedIndex = 0;
        private final ColorPicker parent;

        public PreviewPane(ColorPicker colorPicker) {
            this.parent = colorPicker;
            this.setPreferredSize(new Dimension(32 * ColorPalette.getInstanceSize(), 84));
            this.addMouseListener(this);
        }

        public ColorPalette getSelectedTrackBaseColor() {
            return ColorPalette.getInstance(this.selectedIndex);
        }

        private void drawRect(Graphics graphics, Color color, Color color2, int n, int n2) {
            int n3 = n * 32;
            int n4 = (n2 + 1) * 14;
            graphics.setColor(color2);
            graphics.fillRect(n3, n4, 30, 12);
            graphics.setColor(color);
            graphics.drawRect(n3, n4, 29, 11);
        }

        private void drawSample(Graphics graphics) {
            for (int i = 0; i < ColorPalette.getInstanceSize(); ++i) {
                ColorPalette colorPalette = ColorPalette.getInstance(i);
                Color color = colorPalette.getActiveFillColor();
                Color color2 = colorPalette.getActiveRectColor();
                this.drawRect(graphics, color2, color, i, 0);
                for (int j = 0; j < 4; ++j) {
                    color2 = colorPalette.getPartFillColor(j);
                    Color color3 = colorPalette.getPartRectColor(j);
                    this.drawRect(graphics, color3, color2, i, j + 1);
                }
            }
        }

        private void drawMarker(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.drawArc(this.selectedIndex * 32 + 16 - 6, 0, 10, 10, 0, 360);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.drawMarker(graphics);
            this.drawSample(graphics);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getPoint().x;
            this.selectedIndex = n / 32;
            this.parent.setSelectedTrackColor();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

