/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Supplier;

public final class ColorSet
implements Supplier<Color> {
    private static final ArrayList<ColorSet> list = new ArrayList();
    private static boolean lightMode = true;
    private final Color lightColor;
    private final Color darkColor;
    private Color currentColor;

    public static ColorSet create(Color color, Color color2) {
        ColorSet colorSet = new ColorSet(color, color2, lightMode);
        list.add(colorSet);
        return colorSet;
    }

    public static ColorSet create(Color color) {
        return ColorSet.create(color, color);
    }

    public static void update(boolean bl) {
        lightMode = bl;
        list.forEach(colorSet -> colorSet.changeCurrentColor(bl));
    }

    private void changeCurrentColor(boolean bl) {
        this.currentColor = bl ? this.lightColor : this.darkColor;
    }

    private ColorSet(Color color, Color color2, boolean bl) {
        this.lightColor = color;
        this.darkColor = color2;
        this.changeCurrentColor(bl);
    }

    @Override
    public Color get() {
        return this.currentColor;
    }
}

