/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.ui.editor.IEditContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum EditMode {
    SELECT{

        @Override
        public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            startPoint = mouseEvent.getPoint();
            if (!iEditContext.canEditStartOffset(startPoint)) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (iEditContext.onExistNote(startPoint)) {
                    iEditContext.selectNoteByPoint(startPoint, 0);
                    iEditContext.showPopupMenu(startPoint);
                } else {
                    iEditContext.changeState(AREA).executeEvent(iEditContext, mouseEvent);
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                boolean bl = (Boolean)MabiIccoProperties.getInstance().activePartSwitch.get();
                EditMode editMode = INSERT;
                if (iEditContext.onExistNote(startPoint)) {
                    editMode = iEditContext.selectNoteByPoint(startPoint, mouseEvent.getModifiersEx()) ? (iEditContext.isEditLengthPosition(startPoint) ? LENGTH : MOVE) : SELECT;
                } else if (bl && iEditContext.selectTrackOnExistNote(startPoint)) {
                    iEditContext.selectNoteByPoint(startPoint, 0);
                    editMode = SELECT;
                }
                iEditContext.changeState(editMode).executeEvent(iEditContext, mouseEvent);
            }
        }

        @Override
        public void executeEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            boolean bl = mouseEvent.isShiftDown();
            boolean bl2 = mouseEvent.isControlDown();
            int n = 0;
            Point point = mouseEvent.getPoint();
            if (iEditContext.onExistNote(point) && !bl && !bl2) {
                n = iEditContext.isEditLengthPosition(point) ? 11 : 13;
            } else if (bl && bl2 && !iEditContext.hasSelectedNote()) {
                iEditContext.selectTrackOnExistNote(point);
            }
            iEditContext.setCursor(Cursor.getPredefinedCursor(n));
        }
    }
    ,
    INSERT{

        @Override
        public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                iEditContext.selectNoteByPoint(null, 0);
                iEditContext.changeState(SELECT).executeEvent(iEditContext, mouseEvent);
            }
        }

        @Override
        public void enter(IEditContext iEditContext) {
            iEditContext.newMMLNoteAndSelected(startPoint);
        }

        @Override
        public void executeEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            iEditContext.updateSelectedNoteAndTick(mouseEvent.getPoint(), true, !mouseEvent.isControlDown());
        }

        @Override
        public void exit(IEditContext iEditContext) {
            iEditContext.applyEditNote(false);
        }
    }
    ,
    MOVE{

        @Override
        public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                iEditContext.cancelEdit();
                iEditContext.changeState(SELECT).executeEvent(iEditContext, mouseEvent);
            }
        }

        @Override
        public void enter(IEditContext iEditContext) {
            iEditContext.detachSelectedMMLNote();
        }

        @Override
        public void executeEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            boolean bl = mouseEvent.isShiftDown();
            boolean bl2 = mouseEvent.isControlDown();
            iEditContext.moveSelectedMMLNote(startPoint, mouseEvent.getPoint(), bl, !bl2, bl2, !bl && bl2);
        }

        @Override
        public void exit(IEditContext iEditContext) {
            iEditContext.applyEditNote(true);
        }
    }
    ,
    LENGTH{

        @Override
        public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                iEditContext.cancelEdit();
                iEditContext.changeState(SELECT).executeEvent(iEditContext, mouseEvent);
            }
        }

        @Override
        public void enter(IEditContext iEditContext) {
            iEditContext.detachSelectedMMLNote();
        }

        @Override
        public void executeEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            iEditContext.editLengthSelectedMMLNote(startPoint, mouseEvent.getPoint(), !mouseEvent.isControlDown());
        }

        @Override
        public void exit(IEditContext iEditContext) {
            iEditContext.applyEditNote(false);
        }
    }
    ,
    AREA{
        private MouseEvent firstEvent;

        @Override
        public void enter(IEditContext iEditContext) {
            this.firstEvent = null;
            iEditContext.detachSelectedMMLNote();
        }

        @Override
        public void executeEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            boolean bl = mouseEvent.isControlDown();
            if (this.firstEvent == null) {
                this.firstEvent = mouseEvent;
                if (!bl) {
                    iEditContext.selectNoteByPoint(null, 0);
                    iEditContext.detachSelectedMMLNote();
                }
            }
            iEditContext.areaSelectingAction(startPoint, mouseEvent.getPoint());
        }

        @Override
        public void exit(IEditContext iEditContext) {
            iEditContext.applyAreaSelect();
        }
    }
    ,
    SPLIT{
        private SimpleTool splitTool = new SimpleTool((iEditContext, mouseEvent) -> iEditContext.splitAction(mouseEvent.getPoint()));

        @Override
        public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            this.splitTool.pressEvent(iEditContext, mouseEvent);
        }

        @Override
        public void releaseEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            this.splitTool.releaseEvent(iEditContext, mouseEvent);
        }
    }
    ,
    GLUE{
        private SimpleTool glueTool = new SimpleTool((iEditContext, mouseEvent) -> iEditContext.glueAction(mouseEvent.getPoint()));

        @Override
        public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            this.glueTool.pressEvent(iEditContext, mouseEvent);
        }

        @Override
        public void releaseEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            this.glueTool.releaseEvent(iEditContext, mouseEvent);
        }
    };

    private static Point startPoint;

    public void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
    }

    public void executeEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
    }

    public void releaseEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
        switch (this) {
            case INSERT: 
            case LENGTH: 
            case MOVE: {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) break;
                iEditContext.changeState(SELECT).executeEvent(iEditContext, mouseEvent);
                break;
            }
            case AREA: {
                if (!SwingUtilities.isRightMouseButton(mouseEvent)) break;
                iEditContext.changeState(SELECT).executeEvent(iEditContext, mouseEvent);
                break;
            }
        }
    }

    public void enter(IEditContext iEditContext) {
    }

    public void exit(IEditContext iEditContext) {
    }

    private static final class SimpleTool {
        private boolean inAction = false;
        private final BiConsumer<IEditContext, MouseEvent> func;

        private SimpleTool(BiConsumer<IEditContext, MouseEvent> biConsumer) {
            this.func = biConsumer;
        }

        private void pressEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            boolean bl2 = SwingUtilities.isRightMouseButton(mouseEvent);
            boolean bl3 = SwingUtilities.isMiddleMouseButton(mouseEvent);
            if (bl && !bl2 && !bl3) {
                this.inAction = true;
                this.func.accept(iEditContext, mouseEvent);
            } else {
                this.inAction = false;
                iEditContext.selectNoteByPoint(null, 0);
            }
        }

        private void releaseEvent(IEditContext iEditContext, MouseEvent mouseEvent) {
            if (this.inAction) {
                iEditContext.applyEditNote(false);
                this.inAction = false;
            }
        }
    }
}

