/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.function.IntConsumer;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.IPlayNote;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mabiicco.ui.editor.NumberSpinner;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.parser.MMLEventParser;

public final class KeyboardEditor {
    private static boolean debug = false;
    private final JDialog dialog;
    private final IMMLManager mmlManager;
    private final IPlayNote player;
    private final IEditAlign editAlign;
    private final PianoRollView pianoRollView;
    private final int initOct = 4;
    private final int minOct = 0;
    private final int maxOct = 8;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JComboBox<MidiDevice.Info> midiList = new JComboBox();
    private final JSpinner velocityValueField = NumberSpinner.createSpinner(8, 0, 15, 1);
    private final JSpinner octaveValueField = NumberSpinner.createSpinner(4, 0, 8, 1);
    private final JRadioButton monoButton = new JRadioButton(AppResource.appText("edit.midi_device.mono"));
    private final JRadioButton chordButton = new JRadioButton(AppResource.appText("edit.midi_device.chord"));
    private IntConsumer noteAlignChanger;
    private final CharKeyboard charKeyboard = new CharKeyboard();
    private final MidiKeyboard midiKeyboard = new MidiKeyboard();
    private IKeyboardAction currentAction = null;
    private final Frame parentFrame;

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    private synchronized boolean tryLock(IKeyboardAction iKeyboardAction) {
        if (this.currentAction == null) {
            if (debug) {
                System.out.println("lock   " + iKeyboardAction.getClass().getSimpleName());
            }
            this.currentAction = iKeyboardAction;
            return true;
        }
        return this.currentAction == iKeyboardAction;
    }

    private synchronized void unlock(IKeyboardAction iKeyboardAction) {
        if (this.currentAction != iKeyboardAction) {
            throw new IllegalArgumentException("keyboardAction unlock");
        }
        if (debug) {
            System.out.println("unlock " + iKeyboardAction.getClass().getSimpleName());
        }
        this.currentAction = null;
    }

    public boolean isEmpty() {
        return this.currentAction == null;
    }

    public KeyboardEditor(Frame frame, IMMLManager iMMLManager, IPlayNote iPlayNote, IEditAlign iEditAlign, PianoRollView pianoRollView) {
        this.mmlManager = iMMLManager;
        this.player = iPlayNote;
        this.editAlign = iEditAlign;
        this.pianoRollView = pianoRollView;
        this.parentFrame = frame;
        this.dialog = new JDialog(frame, AppResource.appText("edit.keyboard.input"), true);
        ActionDispatcher.getInstance().addUpdateUIComponent(this.dialog);
        this.initializePanel();
    }

    public void setNoteAlignChanger(IntConsumer intConsumer) {
        this.noteAlignChanger = intConsumer;
    }

    private JPanel createLPanel(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "West");
        return jPanel;
    }

    private void initialSpinnerProperty(JSpinner jSpinner) {
        JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)jSpinner.getEditor()).getTextField();
        jSpinner.setFocusable(false);
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setFocusable(false);
    }

    private void initializePanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(AppResource.appText("edit.velocity")));
        this.initialSpinnerProperty(this.velocityValueField);
        jPanel.add(this.velocityValueField);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(AppResource.appText("edit.octave")));
        this.initialSpinnerProperty(this.octaveValueField);
        jPanel2.add(this.octaveValueField);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(AppResource.appText("edit.midi_device")));
        this.midiList.setFocusable(false);
        this.midiList.addActionListener(new MidiEventListener());
        jPanel3.add(this.midiList);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel(AppResource.appText("edit.midi_device.input_method")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.monoButton.setFocusable(false);
        this.chordButton.setFocusable(false);
        buttonGroup.add(this.monoButton);
        buttonGroup.add(this.chordButton);
        this.selectMidiModeButton();
        this.monoButton.addActionListener(actionEvent -> this.changeEditor(false));
        this.chordButton.addActionListener(actionEvent -> this.changeEditor(true));
        jPanel4.add(this.monoButton);
        jPanel4.add(this.chordButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(this.createLPanel(new JLabel(AppResource.appText("edit.keyboard.input.description"))));
        jPanel5.add(this.createLPanel(jPanel));
        jPanel5.add(this.createLPanel(jPanel2));
        jPanel5.add(this.createLPanel(jPanel3));
        jPanel5.add(this.createLPanel(jPanel4));
        this.panel.add((Component)jPanel5, "North");
        this.dialog.addKeyListener(this.charKeyboard);
        this.dialog.getContentPane().add(this.panel);
        this.dialog.setResizable(false);
    }

    private void editorInit() {
        this.currentAction = null;
        this.charKeyboard.clear();
        this.midiKeyboard.clear();
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.dialog.setVisible(bl);
            return;
        }
        String string = (String)MabiIccoProperties.getInstance().midiInputDevice.get();
        this.midiList.removeAllItems();
        MabiDLS.getInstance().getMidiInDevice().forEach(info -> this.midiList.addItem((MidiDevice.Info)info));
        int n = (int)this.pianoRollView.getSequencePosition();
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        MMLNoteEvent mMLNoteEvent = mMLEventList.searchPrevNoteOnTickOffset(n);
        if (mMLNoteEvent == null) {
            this.velocityValueField.setValue(8);
        } else {
            this.velocityValueField.setValue(mMLNoteEvent.getVelocity());
        }
        for (int i = 0; i < this.midiList.getItemCount(); ++i) {
            MidiDevice.Info info2 = this.midiList.getItemAt(i);
            System.out.println("midi search > \"" + string + "\" \"" + info2.getName() + "\"");
            if (!info2.getName().equals(string)) continue;
            this.midiList.setSelectedIndex(i);
            break;
        }
        this.editorInit();
        this.midiKeyboard.initPartList();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(bl);
    }

    private int nextTick(int n) {
        int n2 = this.editAlign.getEditAlign();
        return n + n2;
    }

    private int prevTick(int n) {
        int n2 = this.editAlign.getEditAlign();
        return n - n2;
    }

    public void changeEditor(boolean bl) {
        if (this.currentAction == null) {
            MabiIccoProperties.getInstance().midiChordInput.set(bl);
            this.charKeyboard.clear();
            this.midiKeyboard.clear();
        }
        this.selectMidiModeButton();
    }

    private void selectMidiModeButton() {
        boolean bl = (Boolean)MabiIccoProperties.getInstance().midiChordInput.get();
        if (this.monoButton.isSelected() == bl) {
            this.monoButton.setSelected(!bl);
        }
        if (this.chordButton.isSelected() != bl) {
            this.chordButton.setSelected(bl);
        }
    }

    public KeyListener getKeyListener() {
        return this.charKeyboard;
    }

    public Receiver getReciever() {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = this.midiList.getActionListeners()) {
            if (!(actionListener instanceof Receiver)) continue;
            return (Receiver)((Object)actionListener);
        }
        return null;
    }

    private static interface IKeyboardAction {
        public void clear();

        public void pressNote(int var1);

        public void addTick();

        public void releaseNote(int var1);

        public boolean isPlay();
    }

    private final class CharKeyboard
    implements KeyListener,
    IKeyboardAction {
        private MMLNoteEvent editNote = null;
        private int playNote = Integer.MIN_VALUE;
        private char typeCode = '\u0000';

        private CharKeyboard() {
        }

        private int charToNote(char c) {
            int n = (Integer)KeyboardEditor.this.octaveValueField.getValue();
            return MMLEventParser.firstNoteNumber("o" + n + c);
        }

        @Override
        public synchronized void clear() {
            this.editNote = null;
            this.playNote = Integer.MIN_VALUE;
            this.typeCode = '\u0000';
        }

        @Override
        public synchronized void pressNote(int n) {
            MMLEventList mMLEventList = KeyboardEditor.this.mmlManager.getActiveMMLPart();
            int n2 = (Integer)KeyboardEditor.this.velocityValueField.getValue();
            int n3 = (int)KeyboardEditor.this.pianoRollView.getSequencePosition();
            int n4 = KeyboardEditor.this.nextTick(n3);
            MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(n, n4 - n3, n3, n2);
            mMLEventList.addMMLNoteEvent(mMLNoteEvent);
            this.playNote = n;
            KeyboardEditor.this.player.playNote(n, n2);
            KeyboardEditor.this.pianoRollView.setSequenceTick(n4);
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            KeyboardEditor.this.mmlManager.updatePianoRollView(n);
            this.editNote = mMLNoteEvent;
        }

        private synchronized void addRest() {
            int n = (int)KeyboardEditor.this.pianoRollView.getSequencePosition();
            int n2 = KeyboardEditor.this.nextTick(n);
            MMLEventList mMLEventList = KeyboardEditor.this.mmlManager.getActiveMMLPart();
            MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(n);
            mMLEventList.deleteMMLEvent(mMLNoteEvent);
            KeyboardEditor.this.pianoRollView.setSequenceTick(n2);
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            KeyboardEditor.this.mmlManager.updatePianoRollView();
            this.editNote = null;
        }

        private void backDelete() {
            int n = (int)KeyboardEditor.this.pianoRollView.getSequencePosition();
            MMLEventList mMLEventList = KeyboardEditor.this.mmlManager.getActiveMMLPart();
            int n2 = KeyboardEditor.this.prevTick(n);
            MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(n2);
            mMLEventList.deleteMMLEvent(mMLNoteEvent);
            KeyboardEditor.this.pianoRollView.setSequenceTick(n2);
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            MMLNoteEvent mMLNoteEvent2 = mMLEventList.searchPrevNoteOnTickOffset(n2);
            if (mMLNoteEvent2 != null) {
                KeyboardEditor.this.mmlManager.updatePianoRollView(mMLNoteEvent2.getNote());
            } else {
                KeyboardEditor.this.mmlManager.updatePianoRollView();
            }
            this.editNote = null;
        }

        private void octaveChange(char c) {
            SpinnerModel spinnerModel = KeyboardEditor.this.octaveValueField.getModel();
            try {
                if (c == '<') {
                    KeyboardEditor.this.octaveValueField.setValue(spinnerModel.getPreviousValue());
                } else if (c == '>') {
                    KeyboardEditor.this.octaveValueField.setValue(spinnerModel.getNextValue());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.editNote = null;
        }

        private void addSharpFlat(char c) {
            int n;
            if (this.editNote == null) {
                return;
            }
            if (c == '+' || c == '#') {
                n = this.editNote.getNote();
                if (n < 107) {
                    ++n;
                }
                this.editNote.setNote(n);
            } else if (c == '-') {
                n = this.editNote.getNote();
                if (n >= 0) {
                    --n;
                }
                this.editNote.setNote(n);
            } else {
                return;
            }
            this.playNote = n = this.editNote.getNote();
            KeyboardEditor.this.player.playNote(n, this.editNote.getVelocity());
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            KeyboardEditor.this.mmlManager.updatePianoRollView(this.editNote.getNote());
        }

        @Override
        public synchronized void addTick() {
            int n = (int)KeyboardEditor.this.pianoRollView.getSequencePosition();
            MMLEventList mMLEventList = KeyboardEditor.this.mmlManager.getActiveMMLPart();
            if (this.editNote == null) {
                return;
            }
            int n2 = KeyboardEditor.this.nextTick(n);
            this.editNote.setTick(n2 - this.editNote.getTickOffset());
            mMLEventList.addMMLNoteEvent(this.editNote);
            KeyboardEditor.this.pianoRollView.setSequenceTick(n2);
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            KeyboardEditor.this.mmlManager.updatePianoRollView(this.editNote.getNote());
        }

        private void cursorMove(boolean bl) {
            int n = (int)KeyboardEditor.this.pianoRollView.getSequencePosition();
            MMLEventList mMLEventList = KeyboardEditor.this.mmlManager.getActiveMMLPart();
            int n2 = bl ? KeyboardEditor.this.nextTick(n) : KeyboardEditor.this.prevTick(n);
            KeyboardEditor.this.pianoRollView.setSequenceTick(n2);
            MMLNoteEvent mMLNoteEvent = mMLEventList.searchPrevNoteOnTickOffset(n2);
            if (mMLNoteEvent != null) {
                KeyboardEditor.this.mmlManager.updatePianoRollView(mMLNoteEvent.getNote());
            } else {
                KeyboardEditor.this.mmlManager.updatePianoRollView();
            }
            this.editNote = null;
        }

        private void velocityChange(boolean bl) {
            SpinnerModel spinnerModel = KeyboardEditor.this.velocityValueField.getModel();
            try {
                KeyboardEditor.this.velocityValueField.setValue(bl ? spinnerModel.getNextValue() : spinnerModel.getPreviousValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void changeNoteAlign(char c) {
            char[] cArray = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != c) continue;
                KeyboardEditor.this.noteAlignChanger.accept(i);
            }
        }

        private void pressAction(char c) {
            if (!KeyboardEditor.this.tryLock(this)) {
                return;
            }
            if (c >= 'a' && c <= 'g' || c >= 'A' && c <= 'G') {
                int n = this.charToNote(c);
                if (this.playNote != n) {
                    this.pressNote(n);
                }
            } else if (c == 'r' || c == 'R') {
                this.addRest();
            } else if (c == '\b') {
                this.backDelete();
            } else if (c == '<' || c == '>') {
                this.octaveChange(c);
            } else if (c == '+' || c == '#' || c == '-') {
                this.addSharpFlat(c);
            } else if (c == '\u001b') {
                KeyboardEditor.this.dialog.setVisible(false);
            } else if (c == '%') {
                this.cursorMove(false);
            } else if (c == '\'') {
                this.cursorMove(true);
            } else if (c == '(') {
                this.velocityChange(false);
            } else if (c == '&') {
                this.velocityChange(true);
            } else if (c >= '0' && c <= '9') {
                this.changeNoteAlign(c);
            }
            if (!this.isPlay()) {
                KeyboardEditor.this.unlock(this);
            }
        }

        @Override
        public boolean isPlay() {
            return this.playNote != Integer.MIN_VALUE;
        }

        @Override
        public synchronized void releaseNote(int n) {
            if (n != Integer.MIN_VALUE && this.playNote == n) {
                this.playNote = Integer.MIN_VALUE;
                KeyboardEditor.this.player.offNote();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            Sequencer sequencer = MabiDLS.getInstance().getSequencer();
            CharKeyboard charKeyboard = this;
            synchronized (charKeyboard) {
                if (sequencer.isRunning()) {
                    return;
                }
                char c = keyEvent.getKeyChar();
                if (c == ' ') {
                    if (KeyboardEditor.this.currentAction != null) {
                        KeyboardEditor.this.currentAction.addTick();
                    }
                    return;
                }
                if (this.typeCode != c) {
                    this.typeCode = c;
                    this.pressAction(c);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 37 || n == 39 || n == 38 || n == 40) {
                this.pressAction((char)n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent keyEvent) {
            CharKeyboard charKeyboard = this;
            synchronized (charKeyboard) {
                char c = keyEvent.getKeyChar();
                if (this.typeCode != c) {
                    return;
                }
                this.typeCode = '\u0000';
                if (c != ' ' && this.playNote != Integer.MIN_VALUE && KeyboardEditor.this.tryLock(this)) {
                    KeyboardEditor.this.unlock(this);
                }
                this.releaseNote(this.playNote);
            }
        }
    }

    private final class MidiKeyboard
    implements IKeyboardAction {
        private final ArrayList<MMLNoteEvent> chord = new ArrayList();
        private final ArrayList<MMLEventList> partList = new ArrayList();

        private MidiKeyboard() {
        }

        private void initPartList() {
            this.partList.clear();
            int n = KeyboardEditor.this.mmlManager.getActivePartProgram();
            boolean[] blArray = InstClass.getEnablePartByProgram(n);
            MMLTrack mMLTrack = KeyboardEditor.this.mmlManager.getActiveTrack();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                this.partList.add(mMLTrack.getMMLEventAtIndex(i));
            }
        }

        @Override
        public synchronized void clear() {
            this.chord.clear();
        }

        @Override
        public synchronized void pressNote(int n) {
            Object object;
            if (this.chord.size() >= this.partList.size()) {
                return;
            }
            int n2 = (int)KeyboardEditor.this.pianoRollView.getSequencePosition();
            int n3 = KeyboardEditor.this.editAlign.getEditAlign();
            if (!this.chord.isEmpty()) {
                n3 = this.chord.get(0).getTick();
            }
            int n4 = (Integer)KeyboardEditor.this.velocityValueField.getValue();
            if (!this.chord.stream().anyMatch(mMLNoteEvent -> mMLNoteEvent.getNote() == n)) {
                object = new MMLNoteEvent(n, n3, n2, n4);
                this.chord.add((MMLNoteEvent)object);
            }
            object = this.chord.iterator();
            for (MMLEventList mMLEventList : this.partList) {
                if (object.hasNext()) {
                    mMLEventList.addMMLNoteEvent((MMLNoteEvent)object.next());
                    continue;
                }
                MMLNoteEvent mMLNoteEvent2 = mMLEventList.searchOnTickOffset(n2);
                if (mMLNoteEvent2 == null) continue;
                mMLEventList.deleteMMLEvent(mMLNoteEvent2);
            }
            Object object2 = new int[this.chord.size()];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = this.chord.get(i).getNote();
            }
            KeyboardEditor.this.player.playNote((int[])object2, n4);
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            KeyboardEditor.this.mmlManager.updatePianoRollView(n);
        }

        @Override
        public synchronized void addTick() {
            for (int i = 0; i < this.chord.size(); ++i) {
                MMLNoteEvent mMLNoteEvent = this.chord.get(i);
                this.partList.get(i).deleteMMLEvent(mMLNoteEvent);
                mMLNoteEvent.setTick(mMLNoteEvent.getTick() + KeyboardEditor.this.editAlign.getEditAlign());
                this.partList.get(i).addMMLNoteEvent(mMLNoteEvent);
            }
            KeyboardEditor.this.mmlManager.updateActivePart(true);
            KeyboardEditor.this.mmlManager.updatePianoRollView();
        }

        @Override
        public synchronized void releaseNote(int n) {
            if (this.chord.size() == 0) {
                return;
            }
            int n2 = this.chord.get(0).getEndTick();
            for (MMLNoteEvent mMLNoteEvent : this.chord) {
                if (mMLNoteEvent.getNote() != n) continue;
                this.chord.remove(mMLNoteEvent);
                break;
            }
            if (this.chord.size() == 0) {
                KeyboardEditor.this.player.offNote();
                KeyboardEditor.this.pianoRollView.setSequenceTick(n2);
                KeyboardEditor.this.mmlManager.updateActivePart(true);
                KeyboardEditor.this.mmlManager.updatePianoRollView();
            }
        }

        @Override
        public boolean isPlay() {
            return this.chord.size() != 0;
        }
    }

    private final class MidiEventListener
    implements Receiver,
    ActionListener {
        private MidiDevice midiDevice = null;

        private MidiEventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiDevice.Info info;
            if (actionEvent.getSource() != KeyboardEditor.this.midiList) {
                return;
            }
            if (this.midiDevice != null) {
                this.midiDevice.close();
            }
            if ((info = KeyboardEditor.this.midiList.getItemAt(KeyboardEditor.this.midiList.getSelectedIndex())) == null) {
                return;
            }
            System.out.println("midi select > \"" + info.getName() + "\"");
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (!midiDevice.isOpen()) {
                    midiDevice.open();
                    Transmitter transmitter = MidiSystem.getMidiDevice(info).getTransmitter();
                    transmitter.setReceiver(this);
                    this.midiDevice = midiDevice;
                }
                MabiIccoProperties.getInstance().midiInputDevice.set(info.getName());
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }

        private synchronized void shortMessageAction(ShortMessage shortMessage) {
            IKeyboardAction iKeyboardAction;
            int n = shortMessage.getCommand();
            int n2 = shortMessage.getData1();
            int n3 = shortMessage.getData2();
            int n4 = n2 - 12;
            IKeyboardAction iKeyboardAction2 = iKeyboardAction = (Boolean)MabiIccoProperties.getInstance().midiChordInput.get() != false ? KeyboardEditor.this.midiKeyboard : KeyboardEditor.this.charKeyboard;
            if (!KeyboardEditor.this.tryLock(iKeyboardAction)) {
                return;
            }
            switch (n) {
                case 176: {
                    if (n2 != 64 || n3 <= 0) break;
                    iKeyboardAction.addTick();
                    break;
                }
                case 144: {
                    if (n3 > 0) {
                        iKeyboardAction.pressNote(n4);
                        break;
                    }
                }
                case 128: {
                    iKeyboardAction.releaseNote(n4);
                }
            }
            if (!iKeyboardAction.isPlay()) {
                KeyboardEditor.this.unlock(iKeyboardAction);
            }
        }

        @Override
        public void send(MidiMessage midiMessage, long l) {
            Sequencer sequencer = MabiDLS.getInstance().getSequencer();
            if (sequencer.isRunning()) {
                return;
            }
            if (midiMessage.getStatus() == 254) {
                return;
            }
            if (midiMessage instanceof ShortMessage) {
                this.shortMessageAction((ShortMessage)midiMessage);
            }
        }

        @Override
        public void close() {
        }
    }
}

