/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.editor.NumberSpinner;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.core.TuningBase;

public final class MMLNotePropertyPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 646262293010195918L;
    private final JSpinner velocityValueField;
    private final JSpinner velocityValueField2;
    private final JCheckBox velocityCheckBox;
    private final JCheckBox tuningNoteCheckBox;
    private final JCheckBox onlySelectedNoteOption;
    private final JCheckBox incDecrVelocityEditOption;
    private final JComboBox<TuningBase> tuningBaseList;
    private final MMLNoteEvent[] noteEvent;
    private final MMLEventList eventList;
    private final Dimension prefSize = new Dimension(350, 150);
    private boolean enableTuningEdit;

    public void showDialog(Frame frame) {
        int n = JOptionPane.showConfirmDialog(frame, this, AppResource.appText("note.properties"), 2, -1);
        if (n == 0) {
            this.applyProperty();
        }
    }

    public MMLNotePropertyPanel() {
        this(null, null);
    }

    public MMLNotePropertyPanel(MMLNoteEvent[] mMLNoteEventArray, MMLEventList mMLEventList) {
        this.setLayout(null);
        this.velocityCheckBox = new JCheckBox(AppResource.appText("note.properties.velocity"));
        this.velocityCheckBox.setBounds(40, 20, 150, 21);
        this.velocityCheckBox.addActionListener(this);
        this.add(this.velocityCheckBox);
        this.velocityValueField = this.createNumberSpinner(8, 0, 15, 1, this.velocityCheckBox);
        this.velocityValueField.setBounds(240, 20, 70, 19);
        this.add(this.velocityValueField);
        this.onlySelectedNoteOption = new JCheckBox(AppResource.appText("note.properties.onlySelectedNoteOption"));
        this.onlySelectedNoteOption.setBounds(60, 50, 200, 21);
        this.onlySelectedNoteOption.addActionListener(this);
        this.add(this.onlySelectedNoteOption);
        this.incDecrVelocityEditOption = new JCheckBox(AppResource.appText("note.properties.incdecr"));
        this.incDecrVelocityEditOption.setBounds(60, 80, 180, 21);
        this.incDecrVelocityEditOption.addActionListener(this);
        this.add(this.incDecrVelocityEditOption);
        this.velocityValueField2 = this.createNumberSpinner(0, -15, 15, 1, this.incDecrVelocityEditOption);
        this.velocityValueField2.setBounds(240, 80, 70, 19);
        this.add(this.velocityValueField2);
        this.tuningNoteCheckBox = new JCheckBox(AppResource.appText("note.properties.tuning"));
        this.tuningNoteCheckBox.setBounds(40, 110, 180, 21);
        this.tuningNoteCheckBox.addActionListener(this);
        this.add(this.tuningNoteCheckBox);
        this.tuningBaseList = new JComboBox<TuningBase>(TuningBase.values());
        this.tuningBaseList.setBounds(240, 110, 70, 21);
        this.addMousePressEnableAction(this.tuningBaseList, this.tuningNoteCheckBox);
        this.tuningBaseList.setMaximumRowCount(3);
        this.add(this.tuningBaseList);
        this.noteEvent = mMLNoteEventArray;
        this.eventList = mMLEventList;
        this.setNoteEvent();
        this.updateView();
    }

    private void addMousePressEnableAction(final JComponent jComponent, final JCheckBox jCheckBox) {
        assert (jCheckBox != null);
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jCheckBox.isEnabled()) {
                    jCheckBox.setSelected(true);
                    jComponent.requestFocus();
                    MMLNotePropertyPanel.this.updateView();
                }
            }
        });
    }

    private JSpinner createNumberSpinner(int n, final int n2, final int n3, int n4, JCheckBox jCheckBox) {
        JSpinner jSpinner = NumberSpinner.createSpinner(n, n2, n3, n4);
        final JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
        this.addMousePressEnableAction(jFormattedTextField, jCheckBox);
        jFormattedTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
                char c = keyEvent.getKeyChar();
                int n = Integer.parseInt(jFormattedTextField.getText());
                if (Character.isDigit(c)) {
                    n = Integer.parseInt(jFormattedTextField.getText() + c);
                } else if (c == '-') {
                    n = n < 0 ? n : -n;
                } else if (c == '+') {
                    n = n < 0 ? -n : n;
                } else {
                    return;
                }
                while (n < n2 || n > n3) {
                    n = Integer.parseInt(Integer.toString(n).substring(1));
                }
                jFormattedTextField.setText(Integer.toString(n));
            }
        });
        return jSpinner;
    }

    private void setNoteEvent() {
        if (this.noteEvent == null) {
            return;
        }
        TuningBase tuningBase = this.noteEvent[0].getTuningBase();
        if (tuningBase != null) {
            this.tuningNoteCheckBox.setSelected(true);
            this.tuningBaseList.setSelectedItem((Object)tuningBase);
        } else {
            this.tuningNoteCheckBox.setSelected(false);
        }
        this.enableTuningEdit = true;
        for (MMLNoteEvent mMLNoteEvent : this.noteEvent) {
            if (Objects.equals((Object)tuningBase, (Object)mMLNoteEvent.getTuningBase())) continue;
            this.enableTuningEdit = false;
            break;
        }
        MMLNoteEvent mMLNoteEvent = this.eventList.searchPrevNoteOnTickOffset(this.noteEvent[0].getTickOffset());
        int n = this.noteEvent[0].getVelocity();
        this.velocityValueField.setValue(n);
        this.velocityCheckBox.setSelected(mMLNoteEvent == null || mMLNoteEvent.getVelocity() != n);
    }

    public void applyProperty() {
        int n = (Integer)this.velocityValueField2.getValue();
        for (MMLNoteEvent mMLNoteEvent : this.noteEvent) {
            Integer n2 = (Integer)this.velocityValueField.getValue();
            if (this.onlySelectedNoteOption.isSelected()) {
                if (!this.incDecrVelocityEditOption.isSelected()) {
                    mMLNoteEvent.setVelocity(n2);
                } else {
                    mMLNoteEvent.setVelocity(mMLNoteEvent.getVelocity() + n);
                }
            } else if (this.velocityCheckBox.isSelected()) {
                this.eventList.setVelocityCommand(mMLNoteEvent, n2);
            } else {
                this.eventList.unsetVelocityCommand(mMLNoteEvent);
            }
            if (!this.tuningNoteCheckBox.isEnabled()) continue;
            TuningBase tuningBase = this.tuningBaseList.getItemAt(this.tuningBaseList.getSelectedIndex());
            mMLNoteEvent.setTuningNote(this.tuningNoteCheckBox.isSelected() ? tuningBase : null);
        }
    }

    private void updateView() {
        boolean bl = this.velocityCheckBox.isSelected();
        boolean bl2 = this.onlySelectedNoteOption.isSelected();
        boolean bl3 = this.incDecrVelocityEditOption.isSelected();
        this.velocityCheckBox.setEnabled(!bl2);
        this.velocityValueField.setEnabled(bl && !bl2 || !bl3 && (bl || bl2));
        this.incDecrVelocityEditOption.setEnabled(bl2);
        this.velocityValueField2.setEnabled(bl2 && bl3);
        this.tuningNoteCheckBox.setEnabled(this.enableTuningEdit);
        this.tuningBaseList.setEnabled(this.enableTuningEdit && this.tuningNoteCheckBox.isSelected());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateView();
    }
}

