/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Frame;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.editor.AbstractMarkerEditor;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mmlTools.Measure;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;

public final class TimeSignatureEditor
extends AbstractMarkerEditor<TimeSignature> {
    private final Frame parentFrame;

    public TimeSignatureEditor(Frame frame, IMMLManager iMMLManager, IEditAlign iEditAlign, IViewTargetMarker iViewTargetMarker) {
        super("timeSign", iMMLManager, iEditAlign, iViewTargetMarker);
        this.parentFrame = frame;
    }

    @Override
    protected int targetTickAlign(int n) {
        return new Measure(this.mmlManager.getMMLScore(), n).measuredTick();
    }

    private TimeSignature showTimeSignatureInputDialog(String string) {
        JComboBox<String> jComboBox = new JComboBox<String>(TimeSignature.TIME_COUNT_LIST);
        JComboBox<String> jComboBox2 = new JComboBox<String>(TimeSignature.TIME_BASE_LIST);
        jComboBox2.setMaximumRowCount(2);
        JLabel jLabel = new JLabel("/");
        JPanel jPanel = new JPanel();
        jPanel.add(jComboBox);
        jPanel.add(jLabel);
        jPanel.add(jComboBox2);
        Measure measure = new Measure(this.mmlManager.getMMLScore(), this.targetTick);
        jComboBox.setSelectedItem(measure.timeCount());
        try {
            jComboBox2.setSelectedItem(measure.timeBase());
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
            return null;
        }
        int n = JOptionPane.showConfirmDialog(this.parentFrame, jPanel, string, 2);
        if (n == 0) {
            try {
                String string2 = jComboBox.getItemAt(jComboBox.getSelectedIndex());
                String string3 = jComboBox2.getItemAt(jComboBox2.getSelectedIndex());
                return new TimeSignature(this.mmlManager.getMMLScore(), this.targetTick, string2, string3);
            }
            catch (MMLException mMLException) {
                mMLException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected List<TimeSignature> getEventList() {
        return this.mmlManager.getMMLScore().getTimeSignatureList();
    }

    @Override
    protected boolean insertAction() {
        TimeSignature timeSignature = this.showTimeSignatureInputDialog(AppResource.appText("edit." + this.insertCommand));
        if (timeSignature == null) {
            return false;
        }
        this.mmlManager.getMMLScore().addTimeSignature(timeSignature);
        return true;
    }

    @Override
    protected boolean editAction() {
        TimeSignature timeSignature = this.showTimeSignatureInputDialog(AppResource.appText("edit." + this.editCommand));
        if (timeSignature == null) {
            return false;
        }
        this.mmlManager.getMMLScore().addTimeSignature(timeSignature);
        return true;
    }

    @Override
    protected boolean deleteAction() {
        this.mmlManager.getMMLScore().removeTimeSignature((TimeSignature)this.targetEvent);
        return true;
    }
}

