/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.mml.MMLOutputPanel;
import jp.fourthline.mabiicco.ui.table.PartListTable;
import jp.fourthline.mmlTools.MMLConverter;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.MMLTickTable;

public final class MMLExportPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1504636951822574399L;
    private PartListTable table;
    private final JDialog dialog;
    private final Frame parentFrame;
    private final MMLScore score;
    private final Supplier<File> fileSupplier;
    private final Dimension prefSize = new Dimension(460, 400);
    private final JLabel outputTextCountLabel = new JLabel();
    private String outputText;
    private JButton fileExportButton;
    private JButton copyButton;
    private final JButton errDetailButton = new JButton(AppResource.appText("Err Detail"));
    private final JCheckBox allowNopt = new JCheckBox(AppResource.appText("mml.export.options.allowNopt"));
    private MMLConverterSelectButton sup;

    public MMLExportPanel(Frame frame, MMLScore mMLScore, Supplier<File> supplier) {
        this.dialog = new JDialog(frame, AppResource.appText("mml.export"), true);
        this.score = mMLScore;
        this.parentFrame = frame;
        this.fileSupplier = supplier;
        this.initializePanel(mMLScore.getTrackList());
    }

    private void initializePanel(List<MMLTrack> list) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        this.fileExportButton = new JButton(AppResource.appText("mml.export.file"));
        this.fileExportButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(this.fileExportButton);
        this.fileExportButton.addActionListener(actionEvent -> this.exportFileMMLTrack());
        this.copyButton = new JButton(AppResource.appText("mml.export.clipboard"));
        this.copyButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(this.copyButton);
        this.copyButton.addActionListener(actionEvent -> this.exportClipboardMMLTrack());
        this.errDetailButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(this.errDetailButton);
        this.errDetailButton.addActionListener(ActionDispatcher.getInstance());
        this.errDetailButton.setActionCommand("mml_err_list");
        this.errDetailButton.setEnabled(false);
        JButton jButton = new JButton(AppResource.appText("mml.output.closeButton"));
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(12, 10, 422, 229);
        jPanel2.add(jScrollPane);
        UIUtils.dialogCloseAction(this.dialog);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new EmptyBorder(0, 10, 0, 10));
        MMLConverterSelectButton mMLConverterSelectButton = new MMLConverterSelectButton("mml.export.mabi_mobile", () -> new MMLConverter(MMLTickTable.Switch.MB), "mml.export.mabi_mobile_done");
        jPanel3.add(mMLConverterSelectButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(mMLConverterSelectButton);
        mMLConverterSelectButton.addActionListener(this);
        mMLConverterSelectButton.setSelected(true);
        this.sup = mMLConverterSelectButton;
        this.table = new PartListTable(list, true, 6);
        jScrollPane.setViewportView(this.table);
        this.outputTextCountLabel.setBounds(22, 242, 300, 14);
        jPanel2.add(this.outputTextCountLabel);
        this.table.setDefaultEditor(Object.class, null);
        this.table.addPropertyChangeListener(propertyChangeEvent -> this.updateText());
        JPanel jPanel4 = UIUtils.createTitledPanel("mml.export.options");
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 20, 2, 20), jPanel4.getBorder()));
        jPanel4.add(this.allowNopt);
        this.allowNopt.setFocusable(false);
        this.allowNopt.addActionListener(actionEvent -> this.updateText());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel3, "Center");
        jPanel5.add((Component)jPanel4, "South");
        this.add((Component)jPanel, "South");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel5, "North");
        this.updateText();
    }

    private String lengthText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("MML@")) {
            string = string.replaceAll(";", "");
            String[] stringArray = string.substring(4).split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i].length());
            }
        }
        return stringBuilder.toString();
    }

    private void updateText() {
        List<MMLEventList> list = this.table.getCheckedEventList();
        this.table.repaint();
        if (this.sup != null) {
            MMLConverter mMLConverter = this.sup.converter.get();
            mMLConverter.setOption(this.allowNopt.isSelected());
            boolean bl = true;
            this.errDetailButton.setEnabled(false);
            this.outputText = "";
            this.score.getMMLErr().clear();
            try {
                this.outputText = mMLConverter.convertMML(list);
                if (this.outputText == null) {
                    this.outputText = "";
                    this.outputTextCountLabel.setText("Convert Error");
                } else {
                    this.outputTextCountLabel.setText(this.lengthText(this.outputText));
                }
            }
            catch (MMLExceptionList mMLExceptionList) {
                this.score.getMMLErr().addAll(mMLExceptionList.getErr());
                this.errDetailButton.setEnabled(true);
                this.outputTextCountLabel.setText("Error");
            }
            this.parentFrame.repaint();
            boolean bl2 = this.outputText.length() > 0 && bl;
            this.fileExportButton.setEnabled(bl2);
            this.copyButton.setEnabled(bl2);
        }
    }

    private void exportFileMMLTrack() {
        boolean bl = true;
        File file = this.fileSupplier.get();
        while (bl && file != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(this.outputText.getBytes());
                JOptionPane.showMessageDialog(this.parentFrame, this.sup.doneMessage + "\n" + file.getAbsolutePath());
                bl = false;
            }
            catch (IOException iOException) {
                Object object = iOException.getLocalizedMessage();
                int n = JOptionPane.showConfirmDialog(this.parentFrame, object = (String)object + "\n" + AppResource.appText("mml.export.retry"), "ERROR", 0);
                if (n != 1) continue;
                bl = false;
            }
        }
    }

    private void exportClipboardMMLTrack() {
        MMLOutputPanel.copyToClipboard(this.parentFrame, this.outputText, AppResource.appText("mml.output.done"));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MMLConverterSelectButton) {
            MMLConverterSelectButton mMLConverterSelectButton;
            this.sup = mMLConverterSelectButton = (MMLConverterSelectButton)object;
            this.updateText();
        }
    }

    public static class MMLConverterSelectButton
    extends JRadioButton {
        private static final long serialVersionUID = -6467870455274074888L;
        private final Supplier<MMLConverter> converter;
        private final String doneMessage;

        public MMLConverterSelectButton(String string, Supplier<MMLConverter> supplier, String string2) {
            super(AppResource.appText(string));
            this.converter = supplier;
            this.doneMessage = AppResource.appText(string2);
        }
    }
}

