/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.MMLText;

public final class MMLInputPanel
extends JPanel {
    private static final long serialVersionUID = -2517820687250637949L;
    private final JDialog dialog;
    private JTextField textField;
    private JComboBox<InstClass> comboBox;
    private JRadioButton overrideButton;
    private JRadioButton newTrackButton;
    private final JPanel buttonPanel = new JPanel();
    private final JButton okButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JLabel mmlInfo = new JLabel();
    private final JCheckBox excludeSongCheckBox = new JCheckBox(AppResource.appText("instrument.excludeSongPart"));
    private final IMMLManager mmlManager;
    private MMLTrack track;
    private final Window parentFrame;
    private final Dimension prefSize = new Dimension(350, 380);
    private final MMLText mmlText = new MMLText();

    public MMLInputPanel(Frame frame, String string, IMMLManager iMMLManager) {
        this(frame, string, iMMLManager, false);
    }

    public MMLInputPanel(Frame frame, String string, IMMLManager iMMLManager, boolean bl) {
        this.mmlManager = iMMLManager;
        this.dialog = new JDialog(frame, AppResource.appText("mml.input"), true);
        this.parentFrame = frame;
        UIUtils.dialogCloseAction(this.dialog);
        this.initializePanel(string);
        this.excludeSongCheckBox.setSelected(bl);
        this.updateInfo();
    }

    private void initializePanel(String string) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        JPanel jPanel2 = UIUtils.createTitledPanel("mml.input.info");
        jPanel2.setBounds(26, 10, 275, 80);
        jPanel2.add(this.mmlInfo);
        this.mmlInfo.setBounds(26, 20, 230, 21);
        this.excludeSongCheckBox.setBounds(26, 45, 230, 21);
        this.excludeSongCheckBox.addActionListener(actionEvent -> this.updateInfo());
        jPanel2.add(this.excludeSongCheckBox);
        jPanel.add(jPanel2);
        JPanel jPanel3 = UIUtils.createTitledPanel("mml.input.method");
        jPanel3.setBounds(26, 100, 275, 87);
        jPanel.add(jPanel3);
        this.overrideButton = new JRadioButton(AppResource.appText("mml.input.method.override"));
        this.overrideButton.setBounds(26, 51, 174, 21);
        jPanel3.add(this.overrideButton);
        this.newTrackButton = new JRadioButton(AppResource.appText("mml.input.method.new"));
        this.newTrackButton.setBounds(26, 23, 144, 21);
        jPanel3.add(this.newTrackButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.overrideButton);
        buttonGroup.add(this.newTrackButton);
        this.newTrackButton.setSelected(true);
        JPanel jPanel4 = UIUtils.createTitledPanel("mml.input.instrument");
        jPanel4.setBounds(26, 196, 275, 65);
        jPanel.add(jPanel4);
        jPanel4.setLayout(null);
        this.comboBox = new JComboBox<InstClass>(MabiDLS.getInstance().getAvailableInstByInstType(InstType.MAIN_INST_LIST));
        this.comboBox.setBounds(25, 26, 193, 19);
        this.comboBox.setMaximumRowCount(30);
        this.comboBox.addActionListener(actionEvent -> this.updateInfo());
        jPanel4.add(this.comboBox);
        JPanel jPanel5 = UIUtils.createTitledPanel("mml.input.trackname");
        jPanel5.setBounds(26, 270, 275, 65);
        jPanel.add(jPanel5);
        jPanel5.setLayout(null);
        this.textField = new JTextField(20);
        this.textField.setText(string);
        this.textField.setBounds(27, 30, 193, 19);
        jPanel5.add(this.textField);
        this.okButton.setMargin(new Insets(5, 10, 5, 10));
        this.okButton.setFocusPainted(true);
        this.buttonPanel.add(this.okButton);
        this.okButton.addActionListener(actionEvent -> {
            this.applyMMLTrack();
            this.dialog.setVisible(false);
        });
        this.cancelButton.setMargin(new Insets(5, 10, 5, 10));
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void updateInfo() {
        boolean bl = ((InstClass)this.comboBox.getSelectedItem()).getType().allowExcludeSongPart();
        this.excludeSongCheckBox.setVisible(bl);
        this.mmlText.setExcludeSongPart(bl && this.excludeSongCheckBox.isSelected());
        this.mmlInfo.setText(this.mmlText.mmlRankFormat());
    }

    public void showDialog() {
        this.showDialog(MMLInputPanel.getClipboardString());
    }

    public void showDialog(String string) {
        this.track = new MMLTrack().setMML(string);
        if (this.track.isEmpty()) {
            return;
        }
        this.mmlText.setMMLText(string);
        this.updateInfo();
        this.dialog.getContentPane().add(this);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }

    void applyMMLTrack() {
        InstClass instClass = (InstClass)this.comboBox.getSelectedItem();
        this.track.setProgram(instClass.getProgram());
        this.track.setTrackName(this.textField.getText());
        this.track.setSongProgram(this.mmlText.isExcludeSongPart() ? -2 : -1);
        if (this.overrideButton.isSelected()) {
            this.mmlManager.setMMLselectedTrack(this.track);
        } else {
            this.mmlManager.addMMLTrack(this.track);
        }
    }

    void setMMLTrack(MMLTrack mMLTrack) {
        this.track = mMLTrack;
    }

    void setOverride(boolean bl) {
        this.overrideButton.setSelected(bl);
    }

    public static String getClipboardString() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        try {
            return (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }
}

