/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.table.TrackListTable;
import jp.fourthline.mmlTools.ComposeRank;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.MMLText;

public final class MMLOutputPanel
extends JPanel {
    private static final long serialVersionUID = 8558159209741558854L;
    final TrackListTable table;
    private final JDialog dialog;
    private final Window parentFrame;
    private final JButton splitButton = new JButton(AppResource.appText("mml.output.split"));
    private final List<MMLTrack> trackList;
    private MMLScore score;
    final List<String> outputTextList = new ArrayList<String>();
    private final String trackName;
    private final Dimension prefSize = new Dimension(500, 340);

    public MMLOutputPanel(Frame frame) {
        this.dialog = null;
        this.parentFrame = frame;
        this.table = null;
        this.trackList = null;
        this.trackName = null;
        this.initializePanel(false);
    }

    public MMLOutputPanel(Frame frame, List<MMLTrack> list, MMLScore mMLScore) {
        this.dialog = new JDialog(frame, AppResource.appText("mml.output"), true);
        this.parentFrame = frame;
        this.table = new TrackListTable(list);
        this.trackList = list;
        this.trackName = null;
        for (MMLTrack mMLTrack : list) {
            this.outputTextList.add(mMLTrack.getMabiMML());
        }
        this.score = mMLScore;
        this.initializePanel(true);
    }

    private MMLOutputPanel(Dialog dialog, MMLTrack mMLTrack, List<MMLText> list, MMLScore mMLScore) {
        this.dialog = new JDialog(dialog, AppResource.appText("mml.output.split"), true);
        this.parentFrame = dialog;
        this.table = new TrackListTable(mMLTrack, list);
        for (MMLText mMLText : list) {
            this.outputTextList.add(mMLText.getMML());
        }
        this.trackList = null;
        this.trackName = mMLTrack.getTrackName();
        this.score = mMLScore;
        this.initializePanel(false);
    }

    private MMLOutputPanel(Frame frame, MMLTrack mMLTrack, List<MMLText> list, MMLScore mMLScore) {
        this.dialog = new JDialog(frame, AppResource.appText("mml.output.split"), true);
        this.parentFrame = frame;
        this.table = new TrackListTable(mMLTrack, list);
        for (MMLText mMLText : list) {
            this.outputTextList.add(mMLText.getMML());
        }
        this.trackList = null;
        this.trackName = mMLTrack.getTrackName();
        this.score = mMLScore;
        this.initializePanel(false);
    }

    private void initializePanel(boolean bl) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        JButton jButton = new JButton(AppResource.getImageIcon("/img/list.png"));
        jButton.setToolTipText(AppResource.appText("mml.output.tableListInfoButton"));
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jButton.setFocusable(false);
        jPanel.add(jButton);
        jButton.addActionListener(actionEvent -> this.tableListOutput());
        JButton jButton2 = new JButton(AppResource.appText("mml.output.nameButton"));
        jButton2.setMargin(new Insets(5, 10, 5, 10));
        jButton2.setFocusable(false);
        jPanel.add(jButton2);
        jButton2.addActionListener(actionEvent -> this.currentSelectedTrackNameOutput());
        JButton jButton3 = new JButton(AppResource.appText("mml.output.copyButton"));
        jButton3.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton3);
        jButton3.addActionListener(actionEvent -> this.currentSelectedTrackMMLOutput());
        if (bl) {
            this.splitButton.setMargin(new Insets(5, 10, 5, 10));
            jPanel.add(this.splitButton);
            this.splitButton.addActionListener(actionEvent -> this.currentSelectedTrackMMLSplitOutput());
            this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.checkSplitCopy());
            this.checkSplitCopy();
        }
        JButton jButton4 = new JButton(AppResource.appText("mml.output.closeButton"));
        jButton4.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton4);
        jButton4.setFocusable(false);
        jButton4.addActionListener(actionEvent -> this.dialog.setVisible(false));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(12, 10, 460, 280);
        jPanel2.add(jScrollPane);
        jScrollPane.setViewportView(this.table);
        UIUtils.dialogCloseAction(this.dialog);
        this.add((Component)jPanel, "South");
        this.add((Component)jPanel2, "Center");
    }

    public static void copyToClipboard(Window window, String string, String string2) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
        if (window != null) {
            JOptionPane.showMessageDialog(window, string2, AppResource.getAppTitle(), -1);
        }
    }

    private void nextSelect(int n) {
        if (++n >= this.table.getRowCount()) {
            n = 0;
        }
        this.table.setRowSelectionInterval(n, n);
    }

    private void tableListOutput() {
        String string = this.table.getTableListInfo();
        MMLOutputPanel.copyToClipboard(this.parentFrame, string, AppResource.appText("mml.output.table_list_done"));
    }

    private void currentSelectedTrackNameOutput() {
        String string;
        Object object;
        if (this.trackList != null) {
            int n = this.table.getSelectedRow();
            object = this.trackList.get(n).getTrackName();
        } else if (this.trackName != null) {
            object = this.trackName;
        } else {
            return;
        }
        if (this.score != null && !(string = this.score.getTitle()).isEmpty()) {
            object = string + "/" + (String)object;
        }
        MMLOutputPanel.copyToClipboard(this.parentFrame, (String)object, AppResource.appText("mml.output.name_done") + "\n\"" + (String)object + "\"");
    }

    private void currentSelectedTrackMMLOutput() {
        int n = this.table.getSelectedRow();
        String string = this.outputTextList.get(n);
        MMLOutputPanel.copyToClipboard(this.parentFrame, string, AppResource.appText("mml.output.done"));
        this.nextSelect(n);
    }

    private void currentSelectedTrackMMLSplitOutput() {
        int n = this.table.getSelectedRow();
        this.createSelectedTrackMMLSplitPanel(n).showDialog();
        this.nextSelect(n);
    }

    MMLOutputPanel createSelectedTrackMMLSplitPanel(int n) {
        MMLTrack mMLTrack = this.trackList.get(n);
        MMLText mMLText = new MMLText().setMMLText(this.outputTextList.get(n));
        mMLText.setExcludeSongPart(mMLTrack.isExcludeSongPart());
        ComposeRank composeRank = !mMLTrack.isExcludeSongPart() ? ComposeRank.getTopRank() : ComposeRank.getTopExcludeSongRank();
        return new MMLOutputPanel(this.dialog, mMLTrack, mMLText.splitMML(composeRank), this.score);
    }

    public static MMLOutputPanel createSelectedTrackMMLSplitPanel(Frame frame, MMLTrack mMLTrack, MMLScore mMLScore) {
        MMLText mMLText = new MMLText().setMMLText(mMLTrack.getMabiMML());
        mMLText.setExcludeSongPart(mMLTrack.isExcludeSongPart());
        ComposeRank composeRank = !mMLTrack.isExcludeSongPart() ? ComposeRank.getTopRank() : ComposeRank.getTopExcludeSongRank();
        return new MMLOutputPanel(frame, mMLTrack, mMLText.splitMML(composeRank), mMLScore);
    }

    private void checkSplitCopy() {
        boolean bl = this.table.selectedRowCanSplit();
        this.splitButton.setEnabled(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }
}

