/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLRestTicks;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.logger.MMLLogger;

public final class MMLBuilder {
    private static final int STRING_BUILDER_SIZE = 2048;
    private static boolean globalVZeroTempo = true;
    private final MMLEventList eventList;
    private final int startOffset;
    private final int initOct;
    private final List<MMLExceptionList.Entry> errList = new ArrayList<MMLExceptionList.Entry>();
    public static final int INIT_OCT = 4;
    private final boolean percussionMotionFix;
    private int currentTempo = 120;
    private boolean tempoVZeroCombine = true;
    private MMLLogger logger;

    public static void setMMLVZeroTempo(boolean bl) {
        globalVZeroTempo = bl;
    }

    public MMLBuilder setLogger(MMLLogger mMLLogger) {
        this.logger = mMLLogger;
        return this;
    }

    public static MMLBuilder create(MMLEventList mMLEventList) {
        return new MMLBuilder(mMLEventList, 0, 4, false);
    }

    public static MMLBuilder create(MMLEventList mMLEventList, int n) {
        return new MMLBuilder(mMLEventList, n, 4, false);
    }

    public static MMLBuilder create(MMLEventList mMLEventList, int n, boolean bl) {
        return new MMLBuilder(mMLEventList, n, 4, bl);
    }

    public static MMLBuilder create(MMLEventList mMLEventList, int n, int n2) {
        return new MMLBuilder(mMLEventList, n, n2, false);
    }

    public static MMLBuilder create(MMLEventList mMLEventList, int n, int n2, boolean bl) {
        return new MMLBuilder(mMLEventList, n, n2, bl);
    }

    private MMLBuilder(MMLEventList mMLEventList, int n, int n2, boolean bl) {
        this.eventList = mMLEventList;
        this.startOffset = n;
        this.initOct = n2;
        this.percussionMotionFix = bl;
    }

    private char makeTempoChar(List<MMLEventList> list, MMLNoteEvent mMLNoteEvent, int n) throws MMLException {
        boolean[] blArray = new boolean[]{true, true, true, true, true, true, true};
        if (list != null) {
            for (Integer n2 : List.of(Integer.valueOf(mMLNoteEvent.getTickOffset()), Integer.valueOf(mMLNoteEvent.getEndTick()))) {
                for (MMLEventList mMLEventList : list) {
                    MMLNoteEvent mMLNoteEvent2 = mMLEventList.searchOnTickOffset(n2.intValue());
                    if (mMLNoteEvent2 == null || mMLNoteEvent2.getOctave() != n) continue;
                    char c = mMLNoteEvent2.toMMLString().toLowerCase().charAt(0);
                    int n3 = c - 97;
                    blArray[n3] = false;
                }
            }
        }
        for (int i = 0; i < blArray.length; ++i) {
            int n4 = (i + 2) % blArray.length;
            if (!blArray[n4]) continue;
            return (char)(97 + n4);
        }
        return 'c';
    }

    private MMLRestTicks insertRestNoteEvent(StringBuilder stringBuilder, MMLNoteEvent mMLNoteEvent, MMLEvent mMLEvent) throws MMLException {
        int n = mMLEvent.getTickOffset() - mMLNoteEvent.getEndTick();
        MMLNoteEvent mMLNoteEvent2 = mMLNoteEvent.clone();
        MMLRestTicks mMLRestTicks = new MMLRestTicks(n, mMLNoteEvent2);
        if (n > 0) {
            stringBuilder.append(this.percussionMotionFix ? mMLRestTicks.toMMLTextWithMotionFix(this.currentTempo) : mMLRestTicks.toMMLText());
            mMLNoteEvent2.setTick(mMLNoteEvent.getTick() + n);
        }
        return mMLRestTicks;
    }

    private void logNoteOverTempoBoundary(MMLTempoEvent mMLTempoEvent) {
        if (this.logger != null) {
            this.logger.noteOverTempoBoundary(this.eventList, mMLTempoEvent);
        }
    }

    private MMLNoteEvent insertTempoMML(StringBuilder stringBuilder, MMLNoteEvent mMLNoteEvent, MMLTempoEvent mMLTempoEvent, boolean bl, List<MMLEventList> list) {
        MMLNoteEvent mMLNoteEvent2 = mMLNoteEvent.clone();
        if (mMLNoteEvent.getEndTick() < mMLTempoEvent.getTickOffset()) {
            int n = mMLNoteEvent.getOctave();
            MMLRestTicks mMLRestTicks = null;
            try {
                mMLRestTicks = this.insertRestNoteEvent(stringBuilder, mMLNoteEvent, mMLTempoEvent);
                mMLNoteEvent2 = mMLRestTicks.getPrevNoteEvent();
            }
            catch (MMLException mMLException) {
                this.errList.add(new MMLExceptionList.Entry(this.eventList, mMLNoteEvent, mMLException));
            }
            if (bl && (globalVZeroTempo || this.percussionMotionFix) && mMLRestTicks != null && !mMLRestTicks.isLastReplaced()) {
                int n2 = stringBuilder.lastIndexOf("r");
                stringBuilder.replace(n2, n2 + 1, "c");
                MMLNoteEvent mMLNoteEvent3 = new MMLEventList(stringBuilder.toString()).getLastNote();
                try {
                    char c = this.makeTempoChar(list, mMLNoteEvent3, n);
                    stringBuilder.replace(n2, n2 + 1, mMLNoteEvent.getVelocity() != 0 ? "v0" + c : "" + c);
                }
                catch (MMLException mMLException) {
                    this.errList.add(new MMLExceptionList.Entry(this.eventList, mMLNoteEvent3, mMLException));
                }
                mMLNoteEvent2.setVelocity(0);
            }
        }
        stringBuilder.append(mMLTempoEvent.toMMLString());
        return mMLNoteEvent2;
    }

    private void insertNoteWithTempo(StringBuilder stringBuilder, LinkedList<MMLTempoEvent> linkedList, MMLNoteEvent mMLNoteEvent, MMLNoteEvent mMLNoteEvent2, boolean bl, boolean bl2) throws MMLExceptionList {
        MMLNoteEvent mMLNoteEvent3 = mMLNoteEvent2.clone();
        while (bl && !linkedList.isEmpty() && mMLNoteEvent3.getTickOffset() < linkedList.getFirst().getTickOffset() && linkedList.getFirst().getTickOffset() < mMLNoteEvent3.getEndTick()) {
            int n = linkedList.getFirst().getTickOffset() - mMLNoteEvent3.getTickOffset();
            MMLNoteEvent mMLNoteEvent4 = new MMLNoteEvent(mMLNoteEvent3.getNote(), n, mMLNoteEvent3.getTickOffset(), mMLNoteEvent3.getVelocity());
            try {
                mMLNoteEvent = this.insertRestNoteEvent(stringBuilder, mMLNoteEvent, mMLNoteEvent4).getPrevNoteEvent();
                stringBuilder.append(mMLNoteEvent4.toMMLString(mMLNoteEvent));
            }
            catch (MMLException mMLException) {
                this.errList.add(new MMLExceptionList.Entry(this.eventList, mMLNoteEvent, mMLException));
            }
            MMLTempoEvent mMLTempoEvent = linkedList.getFirst();
            if (bl) {
                this.logNoteOverTempoBoundary(mMLTempoEvent);
                stringBuilder.append(mMLTempoEvent.toMMLString());
            }
            this.currentTempo = mMLTempoEvent.getTempo();
            linkedList.removeFirst();
            mMLNoteEvent3.setTick(mMLNoteEvent3.getTick() - n);
            mMLNoteEvent3.setTickOffset(mMLNoteEvent3.getTickOffset() + n);
            mMLNoteEvent = mMLNoteEvent4;
            if (bl && bl2) {
                mMLNoteEvent3.setVelocity(0);
                continue;
            }
            if (mMLNoteEvent3.getTick() <= 0) continue;
            stringBuilder.append('&');
        }
        if (mMLNoteEvent3.getTick() > 0) {
            try {
                mMLNoteEvent = this.insertRestNoteEvent(stringBuilder, mMLNoteEvent, mMLNoteEvent3).getPrevNoteEvent();
                stringBuilder.append(mMLNoteEvent3.toMMLString(mMLNoteEvent));
            }
            catch (MMLException mMLException) {
                this.errList.add(new MMLExceptionList.Entry(this.eventList, mMLNoteEvent3, mMLException));
            }
        }
        if (mMLNoteEvent2.getVelocity() != mMLNoteEvent3.getVelocity()) {
            stringBuilder.append("v").append(mMLNoteEvent2.getVelocity());
        }
    }

    public String toMMLString() throws MMLExceptionList {
        return this.toMMLString(false, true);
    }

    public String toMMLString(boolean bl, boolean bl2) throws MMLExceptionList {
        return this.toMMLString(bl, bl2, null);
    }

    private LinkedList<MMLTempoEvent> makeLocalTempoList(long l) {
        LinkedList<MMLTempoEvent> linkedList = new LinkedList<MMLTempoEvent>(this.eventList.getGlobalTempoList());
        while (linkedList.size() > 1 && linkedList.get(1).getTickOffset() <= this.startOffset) {
            this.currentTempo = linkedList.getFirst().getTempo();
            linkedList.removeFirst();
        }
        return linkedList;
    }

    public String toMMLString(boolean bl, boolean bl2, List<MMLEventList> list) throws MMLExceptionList {
        long l = this.totalTickRelationPart(list);
        LinkedList<MMLTempoEvent> linkedList = this.makeLocalTempoList(l);
        StringBuilder stringBuilder = new StringBuilder(2048);
        MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(12 * this.initOct, 0, this.startOffset, 8);
        for (MMLNoteEvent mMLNoteEvent2 : this.eventList.getMMLNoteEventList()) {
            while (!linkedList.isEmpty() && linkedList.getFirst().getTickOffset() <= mMLNoteEvent2.getTickOffset()) {
                if (bl) {
                    mMLNoteEvent = this.insertTempoMML(stringBuilder, mMLNoteEvent, linkedList.getFirst(), bl2, list);
                }
                this.currentTempo = linkedList.getFirst().getTempo();
                linkedList.removeFirst();
            }
            this.insertNoteWithTempo(stringBuilder, linkedList, mMLNoteEvent, mMLNoteEvent2, bl, bl2);
            mMLNoteEvent = mMLNoteEvent2;
        }
        while (!linkedList.isEmpty()) {
            MMLTempoEvent mMLTempoEvent = linkedList.getFirst();
            if (bl2 && (long)mMLTempoEvent.getTickOffset() >= l) break;
            if (bl) {
                mMLNoteEvent = this.insertTempoMML(stringBuilder, mMLNoteEvent, mMLTempoEvent, bl2, list);
            }
            this.currentTempo = linkedList.getFirst().getTempo();
            linkedList.removeFirst();
        }
        if (!this.errList.isEmpty()) {
            throw new MMLExceptionList(this.errList);
        }
        return stringBuilder.toString();
    }

    private int insertNoteWithTempoMusicQ(StringBuilder stringBuilder, List<MMLTempoEvent> list, int n, MMLNoteEvent mMLNoteEvent, MMLNoteEvent mMLNoteEvent2, List<MMLEventList> list2) {
        MMLNoteEvent mMLNoteEvent3 = mMLNoteEvent2.clone();
        int n2 = n;
        while (list.size() > n2) {
            MMLTempoEvent mMLTempoEvent = list.get(n2);
            long l = mMLTempoEvent.getTickOffset();
            if ((long)mMLNoteEvent3.getTickOffset() >= l || l >= (long)mMLNoteEvent3.getEndTick()) break;
            if (MMLBuilder.searchRelationPartCanInsertTempo(list2, l)) {
                ++n2;
                continue;
            }
            int n3 = mMLTempoEvent.getTickOffset() - mMLNoteEvent3.getTickOffset();
            MMLNoteEvent mMLNoteEvent4 = new MMLNoteEvent(mMLNoteEvent3.getNote(), n3, mMLNoteEvent3.getTickOffset(), mMLNoteEvent3.getVelocity());
            this.logNoteOverTempoBoundary(mMLTempoEvent);
            try {
                mMLNoteEvent = this.insertRestNoteEvent(stringBuilder, mMLNoteEvent, mMLNoteEvent4).getPrevNoteEvent();
                stringBuilder.append(mMLNoteEvent4.toMMLString(mMLNoteEvent));
            }
            catch (MMLException mMLException) {
                this.errList.add(new MMLExceptionList.Entry(this.eventList, mMLNoteEvent4, mMLException));
            }
            stringBuilder.append(mMLTempoEvent.toMMLString());
            list.remove(n2);
            mMLNoteEvent3.setTick(mMLNoteEvent3.getTick() - n3);
            mMLNoteEvent3.setTickOffset(mMLNoteEvent3.getTickOffset() + n3);
            mMLNoteEvent = mMLNoteEvent4;
            if (this.tempoVZeroCombine) {
                mMLNoteEvent3.setVelocity(0);
                continue;
            }
            stringBuilder.append('&');
        }
        if (mMLNoteEvent3.getTick() > 0) {
            try {
                mMLNoteEvent = this.insertRestNoteEvent(stringBuilder, mMLNoteEvent, mMLNoteEvent3).getPrevNoteEvent();
                stringBuilder.append(mMLNoteEvent3.toMMLString(mMLNoteEvent));
            }
            catch (MMLException mMLException) {
                this.errList.add(new MMLExceptionList.Entry(this.eventList, mMLNoteEvent3, mMLException));
            }
        }
        if (mMLNoteEvent2.getVelocity() != mMLNoteEvent3.getVelocity()) {
            stringBuilder.append("v").append(mMLNoteEvent2.getVelocity());
        }
        return n2;
    }

    private static boolean searchRelationPartCanInsertTempo(List<MMLEventList> list, long l) {
        if (list != null) {
            for (MMLEventList mMLEventList : list) {
                MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(l);
                if (mMLNoteEvent != null && (long)mMLNoteEvent.getTickOffset() != l) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean searchRelationPartOnTick(List<MMLEventList> list, long l) {
        if (list != null) {
            for (MMLEventList mMLEventList : list) {
                MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(l);
                MMLNoteEvent mMLNoteEvent2 = mMLEventList.searchPrevNoteOnTickOffset(l);
                if ((mMLNoteEvent == null || (long)mMLNoteEvent.getTickOffset() != l) && (mMLNoteEvent2 == null || (long)mMLNoteEvent2.getEndTick() != l)) continue;
                return true;
            }
        }
        return false;
    }

    private long totalTickRelationPart(List<MMLEventList> list) {
        long l = this.eventList.getTickLength();
        if (list != null) {
            for (MMLEventList mMLEventList : list) {
                if (l >= mMLEventList.getTickLength()) continue;
                l = mMLEventList.getTickLength();
            }
        }
        return l;
    }

    private boolean tickDeltaCheck(int n) {
        int n2;
        if (n == 0) {
            return true;
        }
        if (n < 0) {
            n = -n;
        }
        return n >= (n2 = MMLTicks.minimumTick());
    }

    public String toMMLStringMusicQ(List<MMLTempoEvent> list, List<MMLEventList> list2) throws MMLExceptionList {
        return this.toMMLStringMusicQ(list, list2, false);
    }

    public String toMMLStringMusicQ(List<MMLTempoEvent> list, List<MMLEventList> list2, boolean bl) throws MMLExceptionList {
        long l;
        long l2 = this.totalTickRelationPart(list2);
        StringBuilder stringBuilder = new StringBuilder(2048);
        int n = 0;
        while (list.size() > n + 1 && list.get(n + 1).getTickOffset() <= this.startOffset) {
            list.remove(n);
        }
        MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(12 * this.initOct, 0, this.startOffset, 8);
        for (MMLNoteEvent mMLNoteEvent2 : this.eventList.getMMLNoteEventList()) {
            while (list.size() > n) {
                MMLTempoEvent mMLTempoEvent = list.get(n);
                int n2 = mMLNoteEvent2.getTickOffset() - mMLTempoEvent.getTickOffset();
                int n3 = mMLTempoEvent.getTickOffset() - mMLNoteEvent.getEndTick();
                if (n2 < 0) break;
                if (!bl || this.tickDeltaCheck(n2) && this.tickDeltaCheck(n3)) {
                    mMLNoteEvent = this.insertTempoMML(stringBuilder, mMLNoteEvent, mMLTempoEvent, true, list2);
                    this.currentTempo = list.get(n).getTempo();
                    list.remove(n);
                    continue;
                }
                ++n;
            }
            n = this.insertNoteWithTempoMusicQ(stringBuilder, list, n, mMLNoteEvent, mMLNoteEvent2, list2);
            mMLNoteEvent = mMLNoteEvent2;
        }
        while (list.size() > n && (l = (long)list.get(n).getTickOffset()) < l2) {
            if (!MMLBuilder.searchRelationPartOnTick(list2, l)) {
                mMLNoteEvent = this.insertTempoMML(stringBuilder, mMLNoteEvent, list.get(n), true, list2);
                this.currentTempo = list.get(n).getTempo();
                list.remove(n);
                continue;
            }
            ++n;
        }
        if (!this.errList.isEmpty()) {
            throw new MMLExceptionList(this.errList);
        }
        return stringBuilder.toString();
    }

    public MMLBuilder setNoTempoVZeroCombine() {
        this.tempoVZeroCombine = false;
        return this;
    }
}

