/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.core.IllegalTickOffsetException;
import jp.fourthline.mmlTools.core.MMLException;

public abstract class MMLEvent
implements Serializable {
    private static final long serialVersionUID = -6142467143073639266L;
    public static final int MAX_TICK = 3840000;
    private int tickOffset;

    protected MMLEvent(int n) {
        if (n <= -3840000 || n >= 3840000) {
            throw new IllegalTickOffsetException(n);
        }
        this.tickOffset = n;
    }

    public void setTickOffset(int n) {
        if (n < 0 || n >= 3840000) {
            throw new IllegalTickOffsetException(n);
        }
        this.tickOffset = n;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }

    public abstract String toString();

    public abstract String toMMLString() throws MMLException;

    private static int shiftForInsert(int n, int n2, int n3) {
        if (n >= n2) {
            return n + n3;
        }
        return n;
    }

    private static int shiftForRemove(int n, int n2, int n3, int n4) {
        if (n >= n3) {
            return n - n4;
        }
        if (n > n2) {
            return n2;
        }
        return n;
    }

    public static void insertTick(List<? extends MMLEvent> list, int n, int n2) {
        for (MMLEvent mMLEvent : list) {
            MMLNoteEvent mMLNoteEvent;
            int n3 = mMLEvent.getTickOffset();
            if (mMLEvent instanceof MMLNoteEvent ? n3 + (mMLNoteEvent = (MMLNoteEvent)mMLEvent).getTick() <= n : n3 < n) continue;
            int n4 = MMLEvent.shiftForInsert(n3, n, n2);
            if (mMLEvent instanceof MMLNoteEvent) {
                MMLNoteEvent mMLNoteEvent2 = (MMLNoteEvent)mMLEvent;
                int n5 = n3 + mMLNoteEvent2.getTick();
                int n6 = MMLEvent.shiftForInsert(n5, n, n2);
                mMLNoteEvent2.setTickOffset(n4);
                mMLNoteEvent2.setTick(n6 - n4);
                continue;
            }
            mMLEvent.setTickOffset(n4);
        }
    }

    public static void removeTick(List<? extends MMLEvent> list, int n, int n2) {
        int n3 = n + n2;
        ArrayList<MMLEvent> arrayList = new ArrayList<MMLEvent>();
        for (MMLEvent mMLEvent : list) {
            MMLNoteEvent mMLNoteEvent;
            int n4 = mMLEvent.getTickOffset();
            if (mMLEvent instanceof MMLNoteEvent ? n4 + (mMLNoteEvent = (MMLNoteEvent)mMLEvent).getTick() <= n : n4 < n) continue;
            int n5 = MMLEvent.shiftForRemove(n4, n, n3, n2);
            if (mMLEvent instanceof MMLNoteEvent) {
                MMLNoteEvent mMLNoteEvent2 = (MMLNoteEvent)mMLEvent;
                int n6 = n4 + mMLNoteEvent2.getTick();
                int n7 = MMLEvent.shiftForRemove(n6, n, n3, n2);
                int n8 = n7 - n5;
                if (n8 <= 0) {
                    arrayList.add(mMLNoteEvent2);
                    continue;
                }
                mMLNoteEvent2.setTickOffset(n5);
                mMLNoteEvent2.setTick(n8);
                continue;
            }
            if (n4 < n3) {
                arrayList.add(mMLEvent);
                continue;
            }
            mMLEvent.setTickOffset(n5);
        }
        for (MMLEvent mMLEvent : arrayList) {
            list.remove(mMLEvent);
        }
    }

    public static <T> void updateMapByAddMeasure(Map<Integer, T> map, int n) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        map.forEach((n2, object) -> {
            if (n2 >= n) {
                linkedHashMap.put(n2 + 1, object);
            } else {
                linkedHashMap.put(n2, object);
            }
        });
        map.clear();
        map.putAll(linkedHashMap);
    }

    public static <T> void updateMapByRemoveMeasure(Map<Integer, T> map, int n) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        map.forEach((n2, object) -> {
            if (n2 > n) {
                linkedHashMap.put(n2 - 1, object);
            } else if (n2 < n) {
                linkedHashMap.put(n2, object);
            }
        });
        map.clear();
        map.putAll(linkedHashMap);
    }

    public boolean equals(Object object) {
        if (object instanceof MMLEvent) {
            MMLEvent mMLEvent = (MMLEvent)object;
            return this.tickOffset == mMLEvent.tickOffset;
        }
        return false;
    }
}

