/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import jp.fourthline.mmlTools.ComposeRank;
import jp.fourthline.mmlTools.MMLBuilder;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTempoConverter;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLText;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.logger.MMLLogger;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;

public final class MMLTrack
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2006880378975808647L;
    private final MMLLogger logger = new MMLLogger();
    private static final int MAX_TRACK_NAME_LEN = 32;
    public static final int INITIAL_VOLUME = 100;
    public static final int NO_CHORUS = -1;
    public static final int EXCLUDE_SONG = -2;
    private static IntFunction<Boolean> tempoAllowChordPartFunction = n -> true;
    public static IntFunction<Boolean> percussionMotionFix = n -> false;
    private static final int PART_COUNT = 4;
    private final List<MMLEventList> mmlParts = new ArrayList<MMLEventList>();
    private List<MMLTempoEvent> globalTempoList = new ArrayList<MMLTempoEvent>();
    private boolean generated = false;
    private int program = 0;
    private String trackName = "";
    private int panpot = 64;
    private int volume = 100;
    private boolean visible = true;
    private int commonStartOffset = 0;
    private int startDelta = 0;
    private int startSongDelta = 0;
    private int attackDelayCorrect = 0;
    private int attackSongDelayCorrect = 0;
    private boolean disableNopt = false;
    private final MMLText originalMML = new MMLText();
    private final MMLText mabiMML = new MMLText();
    private int songProgram = -1;
    private boolean fix64Tempo = false;
    private boolean optTempoOnlyMelody = false;
    private String importedData;
    private static Function<MMLStringOptimizer, String> mabiMMLOptimizeFunc = mMLStringOptimizer -> mMLStringOptimizer.preciseOptimize();

    public static void setTempoAllowChordPartFunction(IntFunction<Boolean> intFunction) {
        tempoAllowChordPartFunction = intFunction;
    }

    public static void setPercussionMotionFixFunction(IntFunction<Boolean> intFunction) {
        percussionMotionFix = intFunction;
    }

    public MMLTrack() {
        this(0, 0, 0);
    }

    public MMLTrack(int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n % 6 != 0) {
            throw new IllegalArgumentException();
        }
        this.commonStartOffset = n;
        this.startDelta = n2;
        this.startSongDelta = n3;
        this.mmlParse(false);
        this.generated = true;
    }

    public MMLTrack setMML(String string) {
        return this.setMML(string, false);
    }

    public MMLTrack setMabiMML(String string) {
        return this.setMML(string, true);
    }

    public MMLTrack setMML(String string, boolean bl) {
        if (string.indexOf(10) >= 0) {
            String[] stringArray = string.split("\n", 8);
            boolean bl2 = false;
            if (stringArray.length == 7) {
                for (int i = 2; i < stringArray.length - 1; ++i) {
                    int n = stringArray[i].indexOf(58);
                    if (n < 0) {
                        bl2 = true;
                        break;
                    }
                    stringArray[i] = stringArray[i].substring(n + 1).trim();
                }
                if (!bl2) {
                    return this.setMML(stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                }
            }
        }
        this.originalMML.setMMLText(string);
        this.mabiMML.setMMLText(string);
        this.mmlParse(bl);
        return this;
    }

    public MMLTrack setMML(String string, String string2, String string3, String string4) {
        this.originalMML.setMMLText(string, string2, string3, string4);
        this.mabiMML.setMMLText(string, string2, string3, string4);
        this.mmlParse(false);
        return this;
    }

    public void setImportedData(String string) {
        this.importedData = string;
    }

    private void mmlParse(boolean bl) {
        this.mmlParts.clear();
        this.generated = false;
        for (int i = 0; i < 4; ++i) {
            String string = this.originalMML.getText(i);
            int n = this.getStartOffset(i);
            if (bl) {
                n -= this.getAttackDelayCorrect(i);
            }
            this.mmlParts.add(new MMLEventList(string, this.globalTempoList, n));
        }
    }

    public boolean isEmpty() {
        return this.originalMML.isEmpty();
    }

    public String getOriginalMML() {
        return this.originalMML.getMML();
    }

    public String getMabiMML() {
        return this.mabiMML.getMML();
    }

    public ComposeRank mmlRank() {
        this.mabiMML.setExcludeSongPart(this.isExcludeSongPart());
        return this.mabiMML.mmlRank();
    }

    public String mmlRankFormat() {
        this.mabiMML.setExcludeSongPart(this.isExcludeSongPart());
        return (this.generated ? "" : "*") + this.mabiMML.mmlRankFormat();
    }

    public String[] getMabiMMLArray() {
        String[] stringArray = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.mabiMML.getText(i);
        }
        return stringArray;
    }

    public void setGlobalTempoList(List<MMLTempoEvent> list) {
        this.globalTempoList = list;
        for (MMLEventList mMLEventList : this.mmlParts) {
            mMLEventList.setGlobalTempoList(list);
        }
    }

    public List<MMLTempoEvent> getGlobalTempoList() {
        return this.globalTempoList;
    }

    public MMLTrack setProgram(int n) {
        this.program = n;
        return this;
    }

    public int getProgram() {
        return this.program;
    }

    public void setSongProgram(int n) {
        this.songProgram = n;
    }

    public int getSongProgram() {
        return this.songProgram;
    }

    public void setTrackName(String string) {
        this.trackName = string == null ? "" : (string.length() > 32 ? string.substring(0, 32) : string);
    }

    public String getTrackName() {
        return this.trackName;
    }

    public void setPanpot(int n) {
        if (n > 127) {
            n = 127;
        } else if (n < 0) {
            n = 0;
        }
        this.panpot = n;
    }

    public int getPanpot() {
        return this.panpot;
    }

    public void setVolume(int n) {
        if (n < 0 || n > 127) {
            throw new IllegalArgumentException("illeagl volume: " + n);
        }
        this.volume = n;
    }

    public int getVolume() {
        return this.volume;
    }

    public boolean getFix64() {
        return this.fix64Tempo;
    }

    public void setFix64(boolean bl) {
        this.fix64Tempo = bl;
    }

    public MMLEventList getMMLEventAtIndex(int n) {
        return this.mmlParts.get(n);
    }

    public List<MMLEventList> getMMLEventList() {
        return this.mmlParts;
    }

    public String getImportedData() {
        return this.importedData;
    }

    public long getMaxTickLength() {
        long l = 0L;
        for (MMLEventList mMLEventList : this.mmlParts) {
            long l2 = mMLEventList.getTickLength();
            if (l >= l2) continue;
            l = l2;
        }
        return l;
    }

    private String[] fix64Tempo(String[] stringArray) {
        int n;
        MMLNoteEvent mMLNoteEvent;
        int n2;
        int n3;
        int n4;
        int n5 = MMLTempoEvent.searchOnTick(this.globalTempoList, this.commonStartOffset + this.startDelta);
        if (n5 != (n4 = MMLTempoEvent.searchOnTick(this.globalTempoList, (n3 = MMLEventList.maxEndTick(this.mmlParts.subList(0, 3))) - 1))) {
            for (n2 = 0; n2 < 3; ++n2) {
                mMLNoteEvent = this.mmlParts.get(n2).getLastNote();
                if (mMLNoteEvent == null || mMLNoteEvent.getEndTick() != n3) continue;
                int n6 = n2;
                stringArray[n6] = stringArray[n6] + "t" + n5;
                break;
            }
        }
        n2 = MMLTempoEvent.searchOnTick(this.globalTempoList, this.commonStartOffset + this.startSongDelta);
        mMLNoteEvent = this.mmlParts.get(3).getLastNote();
        if (mMLNoteEvent != null && n2 != (n = MMLTempoEvent.searchOnTick(this.globalTempoList, mMLNoteEvent.getEndTick() - 1))) {
            stringArray[3] = stringArray[3] + "t" + n2;
        }
        return stringArray;
    }

    private String[] internalData() throws MMLExceptionList {
        int n = this.mmlParts.size();
        String[] stringArray = new String[n];
        ArrayList<MMLExceptionList.Entry> arrayList = new ArrayList<MMLExceptionList.Entry>();
        for (int i = 0; i < n; ++i) {
            try {
                MMLEventList mMLEventList = this.mmlParts.get(i);
                String string = MMLBuilder.create(mMLEventList, this.getStartOffset(i)).toMMLString(false, false);
                stringArray[i] = new MMLStringOptimizer(string).toString();
                continue;
            }
            catch (MMLExceptionList mMLExceptionList) {
                arrayList.addAll(mMLExceptionList.getErr());
            }
        }
        if (!arrayList.isEmpty()) {
            throw new MMLExceptionList(arrayList);
        }
        return stringArray;
    }

    public MMLTrack generate() throws MMLExceptionList, MMLVerifyException {
        String[] stringArray;
        this.logger.setEnable(false);
        String string = this.getOriginalMML();
        try {
            this.originalMML.setMMLText(this.getMMLStrings(false, false));
        }
        catch (MMLExceptionList mMLExceptionList) {
            this.originalMML.setMMLText(this.internalData());
        }
        MMLTrack mMLTrack = new MMLTrack(this.commonStartOffset, this.startDelta, this.startSongDelta).setMML(this.getOriginalMML());
        mMLTrack.setGlobalTempoList(this.globalTempoList);
        if (!this.equals(mMLTrack)) {
            System.err.println("Verify error.");
            System.err.println(string);
            System.err.println(this.getOriginalMML());
            throw new MMLVerifyException(this);
        }
        this.logger.setEnable(true);
        String[] stringArray2 = stringArray = this.optTempoOnlyMelody ? this.getMMLStrings(false, true) : this.getMMLStringsMusicQ();
        if (this.fix64Tempo) {
            stringArray = this.fix64Tempo(stringArray);
        }
        this.mabiMML.setMMLText(stringArray);
        this.generated = true;
        return this;
    }

    private String[] getMMLStrings(boolean bl, boolean bl2) throws MMLExceptionList {
        int n;
        int n2 = this.mmlParts.size();
        String[] stringArray = new String[n2];
        ArrayList<MMLExceptionList.Entry> arrayList = new ArrayList<MMLExceptionList.Entry>();
        for (n = 0; n < n2; ++n) {
            boolean bl3 = bl2 && percussionMotionFix.apply(this.program) != false && n == 0;
            int n3 = bl2 ? this.getStartOffsetforMabiMML(n) : this.getStartOffset(n);
            MMLEventList mMLEventList = this.mmlParts.get(n);
            boolean bl4 = n == 0 || n == 3;
            try {
                if (bl4) {
                    List<MMLEventList> list = n == 0 ? this.mmlParts.subList(1, 3) : null;
                    stringArray[n] = MMLBuilder.create(mMLEventList, n3, bl3).setLogger(this.logger).toMMLString(true, bl2, list);
                    continue;
                }
                stringArray[n] = MMLBuilder.create(mMLEventList, n3, bl3).setLogger(this.logger).toMMLString();
                continue;
            }
            catch (MMLExceptionList mMLExceptionList) {
                arrayList.addAll(mMLExceptionList.getErr());
            }
        }
        if (!arrayList.isEmpty()) {
            throw new MMLExceptionList(arrayList);
        }
        if (bl) {
            try {
                stringArray[0] = this.tailFix(stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (MMLException mMLException) {
                mMLException.printStackTrace();
            }
        }
        if (bl2 && this.mmlParts.get(0).getMMLNoteEventList().isEmpty() && stringArray[1].equals("") && stringArray[2].equals("")) {
            stringArray[0] = "";
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = bl2 ? mabiMMLOptimizeFunc.apply(new MMLStringOptimizer(stringArray[n]).setDisableNopt(this.disableNopt)) : new MMLStringOptimizer(stringArray[n]).toString();
        }
        if (this.mmlParts.get(3).getTickLength() == 0L) {
            stringArray[3] = "";
        }
        return stringArray;
    }

    private List<List<MMLEventList>> makeRelationPart() {
        ArrayList<List<MMLEventList>> arrayList = new ArrayList<List<MMLEventList>>();
        ArrayList<MMLEventList> arrayList2 = new ArrayList<MMLEventList>();
        arrayList2.add(this.mmlParts.get(1));
        arrayList2.add(this.mmlParts.get(2));
        ArrayList<MMLEventList> arrayList3 = new ArrayList<MMLEventList>();
        arrayList3.add(this.mmlParts.get(2));
        arrayList3.add(this.mmlParts.get(0));
        ArrayList<MMLEventList> arrayList4 = new ArrayList<MMLEventList>();
        arrayList4.add(this.mmlParts.get(0));
        arrayList4.add(this.mmlParts.get(1));
        arrayList.add(arrayList2);
        arrayList.add(arrayList3);
        arrayList.add(arrayList4);
        return arrayList;
    }

    public String[] getGenericMMLStrings(boolean bl) throws MMLExceptionList {
        int n = this.mmlParts.size();
        String[] stringArray = new String[n];
        LinkedList<MMLTempoEvent> linkedList = new LinkedList<MMLTempoEvent>(this.globalTempoList);
        List<List<MMLEventList>> list = this.makeRelationPart();
        ArrayList<MMLExceptionList.Entry> arrayList = new ArrayList<MMLExceptionList.Entry>();
        for (int i = 0; i < n; ++i) {
            boolean bl2 = percussionMotionFix.apply(this.program) != false && i == 0;
            MMLEventList mMLEventList = this.mmlParts.get(i);
            if (i == 3) {
                linkedList = new LinkedList<MMLTempoEvent>(this.globalTempoList);
            }
            List<MMLEventList> list2 = i < 3 && bl ? list.get(i) : null;
            boolean bl3 = i < 2;
            try {
                stringArray[i] = MMLBuilder.create(mMLEventList, this.getStartOffsetforMabiMML(i), 4, bl2).setLogger(this.logger).toMMLStringMusicQ(linkedList, list2, bl3);
                continue;
            }
            catch (MMLExceptionList mMLExceptionList) {
                arrayList.addAll(mMLExceptionList.getErr());
            }
        }
        if (!arrayList.isEmpty()) {
            throw new MMLExceptionList(arrayList);
        }
        if (this.mmlParts.get(0).getMMLNoteEventList().isEmpty() && stringArray[1].equals("") && stringArray[2].equals("")) {
            stringArray[0] = "";
        }
        return stringArray;
    }

    private String[] getMMLStringsMusicQ() throws MMLExceptionList {
        boolean bl = tempoAllowChordPartFunction.apply(this.program);
        String[] stringArray = this.getGenericMMLStrings(bl);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = mabiMMLOptimizeFunc.apply(new MMLStringOptimizer(stringArray[i]).setDisableNopt(this.disableNopt));
        }
        if (this.mmlParts.get(3).getTickLength() == 0L) {
            stringArray[3] = "";
        }
        return stringArray;
    }

    public static void setMabiMMLOptimizeFunc(Function<MMLStringOptimizer, String> function) {
        mabiMMLOptimizeFunc = function != null ? function : mMLStringOptimizer -> mMLStringOptimizer.preciseOptimize();
    }

    private String tailFix(String string, String string2, String string3) throws MMLException {
        Object object = string;
        MMLTrack mMLTrack = new MMLTrack().setMML(string, string2, string3, "");
        long l = mMLTrack.getMaxTickLength();
        double d = mMLTrack.getPlayTime();
        double d2 = mMLTrack.getMabinogiTime();
        int n = (int)(l - new MMLEventList((String)object).getTickLength());
        if (d > d2) {
            object = (String)object + new MMLTicks("r", n, false).toMMLText();
        } else if (d < d2) {
            if (n > 0) {
                object = (String)object + new MMLTicks("r", n, false).toMMLText() + "v0c64";
            }
            object = (String)object + MMLTempoEvent.getMaxTempoEvent(this.globalTempoList).toMMLString();
        }
        return object;
    }

    public double getPlayTime() {
        int n = (int)this.getMaxTickLength();
        double d = MMLTempoConverter.getTimeOnTickOffset(this.globalTempoList, n);
        return d / 1000.0;
    }

    public double getMabinogiTime() {
        double[] dArray = new double[this.mmlParts.size()];
        int n = (int)this.mmlParts.get(0).getTickLength();
        dArray[0] = MMLTempoConverter.getTimeOnTickOffset(this.globalTempoList, n);
        ArrayList<MMLTempoEvent> arrayList = new ArrayList<MMLTempoEvent>();
        MMLTempoEvent mMLTempoEvent = new MMLTempoEvent(120, 0);
        if (this.globalTempoList.size() > 0) {
            mMLTempoEvent.setTempo(this.globalTempoList.get(this.globalTempoList.size() - 1).getTempo());
        }
        arrayList.add(new MMLTempoEvent(mMLTempoEvent.getTempo(), 0));
        for (int i = 1; i < dArray.length; ++i) {
            int n2 = (int)this.mmlParts.get(i).getTickLength();
            dArray[i] = MMLTempoConverter.getTimeOnTickOffset(arrayList, n2);
        }
        double d = 0.0;
        for (double d2 : dArray) {
            if (!(d < d2)) continue;
            d = d2;
        }
        return d / 1000.0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MMLTrack)) {
            return false;
        }
        MMLTrack mMLTrack = (MMLTrack)object;
        if (this.mmlParts.size() != mMLTrack.mmlParts.size()) {
            return false;
        }
        return Arrays.equals(this.mmlParts.toArray(), mMLTrack.mmlParts.toArray());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isExcludeSongPart() {
        return this.songProgram == -2;
    }

    public void updateStartOffsetNoteEvents(int n, boolean bl, boolean bl2) {
        int n2 = this.mmlParts.size();
        for (int i = 0; i < n2; ++i) {
            if ((!bl || i < 0 || i > 2) && (!bl2 || i != 3)) continue;
            List<MMLNoteEvent> list = this.mmlParts.get(i).getMMLNoteEventList();
            list.forEach(mMLNoteEvent -> mMLNoteEvent.setTickOffset(mMLNoteEvent.getTickOffset() + n));
            list.removeIf(mMLNoteEvent -> mMLNoteEvent.getTickOffset() < 0);
        }
    }

    public MMLTrack setStartOffset(int n, List<MMLTempoEvent> list) {
        int n2 = n - this.commonStartOffset;
        this.updateStartOffsetNoteEvents(n2, true, true);
        if (this.globalTempoList != list) {
            this.globalTempoList.forEach(mMLTempoEvent -> mMLTempoEvent.setTickOffset(mMLTempoEvent.getTickOffset() + n2));
        }
        this.commonStartOffset = n;
        return this;
    }

    private boolean checkStartOffset(int n, List<MMLEventList> list) {
        for (MMLEventList mMLEventList : list) {
            List<MMLNoteEvent> list2 = mMLEventList.getMMLNoteEventList();
            if (list2.size() <= 0 || list2.get(0).getTickOffset() >= n) continue;
            return false;
        }
        return true;
    }

    public MMLTrack setStartDelta(int n) {
        int n2 = this.commonStartOffset + n;
        if (n2 < 0 || !this.checkStartOffset(n2, this.mmlParts.subList(0, 3))) {
            throw new IllegalArgumentException();
        }
        this.startDelta = n;
        return this;
    }

    public MMLTrack setStartSongDelta(int n) {
        int n2 = this.commonStartOffset + n;
        if (n2 < 0 || !this.checkStartOffset(n2, this.mmlParts.subList(3, 4))) {
            throw new IllegalArgumentException();
        }
        this.startSongDelta = n;
        return this;
    }

    public int getStartOffset(int n) {
        return this.commonStartOffset + (switch (n) {
            case 0, 1, 2 -> this.startDelta;
            case 3 -> this.startSongDelta;
            default -> throw new IllegalArgumentException();
        });
    }

    private int getStartOffsetforMabiMML(int n) {
        return this.getStartOffset(n) - this.getAttackDelayCorrect(n);
    }

    public int getCommonStartOffset() {
        return this.commonStartOffset;
    }

    public int getStartDelta() {
        return this.startDelta;
    }

    public int getStartSongDelta() {
        return this.startSongDelta;
    }

    public void setAttackDelayCorrect(int n) {
        this.attackDelayCorrect = n;
    }

    public int getAttackDelayCorrect() {
        return this.attackDelayCorrect;
    }

    public void setAttackSongDelayCorrect(int n) {
        this.attackSongDelayCorrect = n;
    }

    public int getAttackSongDelayCorrect() {
        return this.attackSongDelayCorrect;
    }

    public int getAttackDelayCorrect(int n) {
        return switch (n) {
            case 0, 1, 2 -> this.attackDelayCorrect;
            case 3 -> this.attackSongDelayCorrect;
            default -> throw new IllegalArgumentException();
        };
    }

    public boolean isFantasyTrack() {
        boolean bl = !this.mmlParts.get(0).isEmpty() || !this.mmlParts.get(1).isEmpty() || !this.mmlParts.get(2).isEmpty();
        boolean bl2 = !this.mmlParts.get(3).isEmpty();
        return bl && bl2;
    }

    public void setDisableNopt(boolean bl) {
        this.disableNopt = bl;
    }

    public boolean getDisableNopt() {
        return this.disableNopt;
    }

    public void setOptTempoOnlyMelody(boolean bl) {
        this.optTempoOnlyMelody = bl;
    }

    public boolean getOptTempoMelodyOnly() {
        return this.optTempoOnlyMelody;
    }

    public MMLLogger getLogger() {
        return this.logger;
    }

    public MMLTrack clone() {
        MMLTrack mMLTrack = new MMLTrack(this.commonStartOffset, this.startDelta, this.startSongDelta).setMML(this.getOriginalMML());
        mMLTrack.setGlobalTempoList(this.globalTempoList);
        mMLTrack.setPanpot(this.panpot);
        mMLTrack.setVolume(this.volume);
        mMLTrack.setProgram(this.program);
        mMLTrack.setSongProgram(this.songProgram);
        mMLTrack.setTrackName(this.trackName);
        mMLTrack.setAttackDelayCorrect(this.attackDelayCorrect);
        mMLTrack.setAttackSongDelayCorrect(this.attackSongDelayCorrect);
        mMLTrack.setDisableNopt(this.disableNopt);
        mMLTrack.setImportedData(this.importedData);
        mMLTrack.setOptTempoOnlyMelody(this.optTempoOnlyMelody);
        if (this.generated) {
            try {
                mMLTrack.generate();
            }
            catch (MMLExceptionList | MMLVerifyException exception) {
                exception.printStackTrace();
            }
        }
        return mMLTrack;
    }
}

