/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.fourthline.mmlTools.ComposeRank;

public final class MMLText {
    private static final int DEFAULT_PART_NUM = 4;
    private final String[] text = new String[4];
    private boolean excludeSongPart = false;
    private static String melody_empty_str = "";

    public static void setMelodyEmptyStr(String string) {
        melody_empty_str = string;
    }

    public static String getMelodyEmptyStr() {
        return melody_empty_str;
    }

    public MMLText() {
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = "";
        }
    }

    public MMLText setMMLText(String string) {
        if (!string.startsWith("MML@")) {
            string = "";
            return this;
        }
        int n = 4;
        int n2 = string.indexOf(";");
        if (n2 <= 0) {
            n2 = string.length();
        }
        string = string.substring(n, n2);
        String[] stringArray = string.split(",");
        this.setMMLText(stringArray);
        return this;
    }

    public MMLText setMMLText(String[] stringArray) {
        for (int i = 0; i < stringArray.length && i < this.text.length; ++i) {
            this.text[i] = stringArray[i];
        }
        return this;
    }

    public MMLText setMMLText(String string, int n) {
        if (n >= this.text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.text[n] = string;
        return this;
    }

    public MMLText setMMLText(String string, String string2, String string3, String string4) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        String[] stringArray = new String[]{string, string2, string3, string4};
        this.setMMLText(stringArray);
        return this;
    }

    public boolean isEmpty() {
        for (String string : this.text) {
            if (string.length() <= 0) continue;
            return false;
        }
        return true;
    }

    public String getText(int n) {
        if (n < this.text.length) {
            return this.text[n];
        }
        return "";
    }

    private String melodyPart() {
        String string = this.text[0];
        if (!(string.length() != 0 || this.text[1].length() == 0 && this.text[2].length() == 0 || this.validSongPart())) {
            string = melody_empty_str;
        }
        return string;
    }

    public String getMML() {
        String string = "MML@" + this.melodyPart() + "," + this.text[1] + "," + this.text[2];
        if (this.validSongPart()) {
            string = string + "," + this.text[3];
        }
        string = string + ";";
        return string;
    }

    private boolean validSongPart() {
        return !this.excludeSongPart && this.text[3].length() > 0;
    }

    public ComposeRank mmlRank() {
        if (!this.excludeSongPart) {
            return ComposeRank.mmlRank(this.melodyPart(), this.text[1], this.text[2], this.text[3]);
        }
        return ComposeRank.mmlExcludeSongRank(this.melodyPart(), this.text[1], this.text[2], "");
    }

    public String mmlRankFormat() {
        String string = "Rank " + this.mmlRank().getRank() + " ( " + this.melodyPart().length() + ", " + this.text[1].length() + ", " + this.text[2].length();
        if (this.validSongPart()) {
            string = string + ", " + this.text[3].length();
        }
        string = string + " )";
        return string;
    }

    public List<MMLText> splitMML(ComposeRank composeRank) {
        int[] nArray = new int[]{composeRank.getMelody(), composeRank.getChord1(), composeRank.getChord2(), composeRank.getMelody()};
        StringBuffer[] stringBufferArray = new StringBuffer[nArray.length];
        for (int i = 0; i < stringBufferArray.length; ++i) {
            stringBufferArray[i] = new StringBuffer(this.text[i]);
        }
        ArrayList<MMLText> arrayList = new ArrayList<MMLText>();
        while (Arrays.asList(stringBufferArray).stream().anyMatch(stringBuffer -> stringBuffer.length() != 0)) {
            String[] stringArray = new String[stringBufferArray.length];
            for (int i = 0; i < stringBufferArray.length; ++i) {
                int n = Math.min(stringBufferArray[i].length(), nArray[i]);
                stringArray[i] = stringBufferArray[i].substring(0, n);
                stringBufferArray[i].delete(0, n);
            }
            MMLText mMLText = new MMLText().setMMLText(stringArray);
            mMLText.setExcludeSongPart(this.isExcludeSongPart());
            arrayList.add(mMLText);
        }
        return arrayList;
    }

    public boolean isExcludeSongPart() {
        return this.excludeSongPart;
    }

    public void setExcludeSongPart(boolean bl) {
        this.excludeSongPart = bl;
    }

    public MMLText join(MMLText mMLText) {
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = this.text[i].concat(mMLText.text[i]);
        }
        return this;
    }
}

