/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.core.ParserWarn3ML;

public final class MelodyParser {
    private final String mml_src;
    private String mml_L;
    private int mml_length = -1;
    private int mml_oct = 4;
    private int tempo;
    private final Map<Integer, Integer> tempoList = new TreeMap<Integer, Integer>();
    private char playingNote = (char)32;
    private final List<Integer> warnIndex = new ArrayList<Integer>();
    private static final int R_NOTE = Integer.MIN_VALUE;
    private int minNote = Integer.MIN_VALUE;
    private int maxNote = Integer.MIN_VALUE;
    private int noteNumber = Integer.MIN_VALUE;
    private String gt;

    public MelodyParser(String string) {
        this(string, "4", 120);
    }

    public MelodyParser(String string, String string2, int n) {
        this.mml_src = string == null ? "" : string;
        this.mml_L = string2;
        this.tempo = n;
        this.tempoList.put(0, n);
    }

    public int getTempo() throws MMLException {
        if (this.mml_length < 0) {
            this.cals_length();
        }
        return this.tempo;
    }

    public String getMmlL() throws MMLException {
        if (this.mml_length < 0) {
            this.cals_length();
        }
        return this.mml_L;
    }

    public List<Integer> getWarnIndex() {
        if (this.mml_length < 0) {
            throw new NullPointerException(" non cals. ");
        }
        return this.warnIndex;
    }

    public int getLength() throws MMLException {
        if (this.mml_length < 0) {
            this.cals_length();
        }
        return this.mml_length;
    }

    public int getMinNote() {
        return this.minNote;
    }

    public int getMaxNote() {
        return this.maxNote;
    }

    public int getNoteNumber() {
        return this.noteNumber;
    }

    public String getGt() {
        return this.gt;
    }

    public void setOctave(int n) {
        this.mml_oct = n;
    }

    public int getOctave() {
        return this.mml_oct;
    }

    public boolean checkPitch(int n, int n2) {
        if (this.minNote == Integer.MIN_VALUE && this.maxNote == Integer.MIN_VALUE) {
            return true;
        }
        return this.minNote >= n && this.maxNote <= n2;
    }

    public void mergeParser(MelodyParser melodyParser) throws MMLException {
        int n = this.getLength();
        int n2 = melodyParser.getLength();
        if (this.tempoList.get(0) == melodyParser.tempoList.get(0)) {
            melodyParser.tempoList.remove(0);
        }
        if (n <= n2) {
            this.tempoList.remove(n);
            this.mml_length = n2;
        } else {
            melodyParser.tempoList.remove(n2);
        }
        this.tempoList.putAll(melodyParser.tempoList);
    }

    public Map<Integer, Integer> getTempoList() throws MMLException {
        if (this.tempoList.size() < 2) {
            this.cals_length();
        }
        return this.tempoList;
    }

    public double getPlayLengthByTempoList() throws MMLException {
        double d = 0.0;
        if (this.tempoList.size() < 2) {
            this.cals_length();
        }
        Iterator<Map.Entry<Integer, Integer>> iterator = this.tempoList.entrySet().iterator();
        Map.Entry<Integer, Integer> entry = iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> entry2 = iterator.next();
            if (entry2.getValue().equals(entry.getValue())) continue;
            d += (double)((entry2.getKey() - entry.getKey()) * 60000 / entry.getValue());
            entry = entry2;
        }
        return d / 96.0 / 1000.0;
    }

    private int mmlGT(String string) throws MMLException {
        return MMLTicks.getTick(string);
    }

    private void noteMinMax(int n) {
        if (n == Integer.MIN_VALUE) {
            return;
        }
        if (this.minNote == Integer.MIN_VALUE || this.maxNote == Integer.MIN_VALUE) {
            this.minNote = this.maxNote = n;
            return;
        }
        if (n < this.minNote) {
            this.minNote = n;
        }
        if (n > this.maxNote) {
            this.maxNote = n;
        }
    }

    private int noteIndex(char c, char c2) {
        int n = -1;
        if (c < 'a') {
            c = (char)(c + 32);
        }
        switch (c) {
            case 'c': {
                n = 0;
                break;
            }
            case 'd': {
                n = 2;
                break;
            }
            case 'e': {
                n = 4;
                break;
            }
            case 'f': {
                n = 5;
                break;
            }
            case 'g': {
                n = 7;
                break;
            }
            case 'a': {
                n = 9;
                break;
            }
            case 'b': {
                n = 11;
                break;
            }
            default: {
                n = -1;
            }
        }
        switch (c2) {
            case '#': 
            case '+': {
                ++n;
                break;
            }
            case '-': {
                --n;
                break;
            }
        }
        return n;
    }

    private void mmlOperation(String string) throws ParserWarn3ML {
        try {
            switch (string.charAt(0)) {
                case 'L': 
                case 'l': {
                    this.mml_L = string.substring(1);
                    break;
                }
                case 'T': 
                case 't': {
                    int n = Integer.parseInt(string.substring(1));
                    this.tempoList.put(this.mml_length, n);
                    if (n <= 255 && n >= 32) {
                        this.tempo = n;
                    }
                    if (this.playingNote != 'r' && this.playingNote != 'R') break;
                    throw new ParserWarn3ML();
                }
                case 'O': 
                case 'o': {
                    this.mml_oct = Integer.parseInt(string.substring(1));
                    break;
                }
                case '<': {
                    if (this.mml_oct <= 0) break;
                    --this.mml_oct;
                    break;
                }
                case '>': {
                    if (this.mml_oct >= 8) break;
                    ++this.mml_oct;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("skip: " + string);
        }
    }

    public int noteGT(String string) throws MMLException, ParserWarn3ML {
        int n;
        if (!MMLTokenizer.isNote(string.charAt(0))) {
            this.mmlOperation(string);
            return 0;
        }
        this.playingNote = string.charAt(0);
        if (this.playingNote == 'n' || this.playingNote == 'N') {
            try {
                this.noteNumber = Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw MMLException.createIllegalNote(string);
            }
            this.noteMinMax(this.noteNumber);
            this.gt = "";
            return this.mmlGT(this.mml_L);
        }
        char c = string.charAt(0);
        char c2 = ' ';
        this.gt = this.mml_L;
        int n2 = string.length();
        if (n2 > 1) {
            n = 1;
            c2 = string.charAt(1);
            if (c2 == '+' || c2 == '-' || c2 == '#') {
                ++n;
            }
            if (n < n2) {
                String string2 = string.substring(n);
                char c3 = string2.charAt(0);
                if (string2.length() > 0 && (c3 == '.' || Character.isDigit(c3))) {
                    this.gt = string2;
                }
                if (this.gt.startsWith(".")) {
                    this.gt = this.mml_L + ".";
                }
            }
        }
        n = this.noteIndex(c, c2);
        this.noteNumber = this.mml_oct * 12 + n;
        if (c != 'r' && c != 'R') {
            this.noteMinMax(this.noteNumber);
        } else {
            this.noteNumber = Integer.MIN_VALUE;
        }
        return this.mmlGT(this.gt);
    }

    protected void reset() {
        this.mml_length = 0;
        this.warnIndex.removeAll(this.warnIndex);
    }

    private int cals_length() throws MMLException {
        MMLTokenizer mMLTokenizer = new MMLTokenizer(this.mml_src);
        this.reset();
        while (mMLTokenizer.hasNext()) {
            int[] nArray = mMLTokenizer.getIndex();
            String string = mMLTokenizer.next();
            try {
                this.mml_length += this.noteGT(string);
            }
            catch (ParserWarn3ML parserWarn3ML) {
                System.err.println(parserWarn3ML.getMessage() + nArray[1]);
                this.warnIndex.add(nArray[1]);
            }
        }
        try {
            this.mmlOperation("T0");
        }
        catch (ParserWarn3ML parserWarn3ML) {
            // empty catch block
        }
        return this.mml_length;
    }
}

