/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.Marker;
import jp.fourthline.mmlTools.core.ResourceLoader;
import jp.fourthline.mmlTools.parser.AbstractMMLParser;
import jp.fourthline.mmlTools.parser.MMLParseException;
import jp.fourthline.mmlTools.parser.SectionContents;
import jp.fourthline.mmlTools.parser.TextParser;

public final class MMSFile
extends AbstractMMLParser {
    private static final String PATCH_NAME = "mms_instPatch";
    private static final int[] mmsInstTable = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 18};
    private final MMLScore score = new MMLScore();

    @Override
    public MMLScore parse(InputStream inputStream) throws MMLParseException {
        List<SectionContents> list = SectionContents.makeSectionContentsByInputStream(inputStream, "Shift_JIS");
        if (list.isEmpty()) {
            throw new MMLParseException("empty");
        }
        for (SectionContents sectionContents : list) {
            String string = sectionContents.getName();
            if (string.matches("\\[part[0-9]+\\]")) {
                System.out.println("part");
                MMLTrack mMLTrack = this.parseMMSPart(sectionContents.getContents());
                System.out.println(mMLTrack.getOriginalMML());
                System.out.println(mMLTrack.getProgram());
                this.score.addTrack(mMLTrack);
                continue;
            }
            if (string.equals("[infomation]")) {
                this.parseInfomation(sectionContents.getContents());
                continue;
            }
            if (!string.equals("[marker]")) continue;
            this.parseMarker(sectionContents.getContents());
        }
        return this.score;
    }

    private int convertInstProgram(int n) {
        return mmsInstTable[n];
    }

    private void parseInfomation(String string2) {
        new TextParser().pattern("title=", this.score::setTitle).pattern("auther=", this.score::setAuthor).pattern("rythmNum=", string -> this.score.setTimeCountOnly(Integer.valueOf(string))).pattern("rythmBase=", string -> this.score.setBaseOnly(Integer.valueOf(string))).parse(string2);
    }

    private void parseMarker(String string2) {
        LinkedList linkedList = new LinkedList();
        new TextParser().pattern("label", string -> linkedList.add(new Marker(string.substring(5), 0))).pattern("position", string -> {
            int n = Integer.parseInt(string.substring(5));
            ((Marker)linkedList.getLast()).setTickOffset(n);
        }).parse(string2);
        this.score.getMarkerList().addAll(linkedList);
    }

    private MMLTrack parseMMSPart(String string2) {
        int[] nArray = new int[]{0, 0};
        String[] stringArray = new String[]{"", "", "", ""};
        new TextParser().pattern("instrument=", string -> {
            nArray[0] = this.convertInstProgram(Integer.parseInt(string));
        }).pattern("panpot=", string -> {
            nArray[1] = Integer.parseInt(string) + 64;
        }).pattern("name=", string -> {
            stringArray[0] = string;
        }).pattern("ch0_mml=", string -> {
            stringArray[1] = string;
        }).pattern("ch1_mml=", string -> {
            stringArray[2] = string;
        }).pattern("ch2_mml=", string -> {
            stringArray[3] = string;
        }).parse(string2);
        MMLTrack mMLTrack = new MMLTrack().setMML(stringArray[1], stringArray[2], stringArray[3], "");
        mMLTrack.setTrackName(stringArray[0]);
        mMLTrack.setProgram(nArray[0]);
        mMLTrack.setPanpot(nArray[1]);
        return mMLTrack;
    }

    static {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PATCH_NAME, new ResourceLoader());
            for (String string : resourceBundle.keySet()) {
                String string2 = resourceBundle.getString(string).replaceAll("#.*", "");
                int n = Integer.parseInt(string.trim());
                int n2 = Integer.parseInt(string2.trim());
                System.out.println("[MMS-PATCH] " + n + " -> " + n2);
                for (int i = 0; i < mmsInstTable.length; ++i) {
                    if (mmsInstTable[i] != n) continue;
                    MMSFile.mmsInstTable[i] = n2;
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

