/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.TransferHandler;
import jp.fourthline.mabiicco.ActionDispatcher;

public final class FileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 7618330769836269887L;
    private final ActionDispatcher dispacher;

    public FileTransferHandler(ActionDispatcher actionDispatcher) {
        this.dispacher = actionDispatcher;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        int n = transferSupport.getDropAction();
        if (n == 2 || n == 1) {
            return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        int n = transferSupport.getDropAction();
        try {
            for (Object e : (List)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)) {
                File file;
                if (!(e instanceof File) || !(file = (File)e).isFile()) continue;
                if (n == 2) {
                    this.dispacher.checkAndOpenMMLFile(file);
                } else {
                    this.dispacher.fileImport(file);
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

