/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import sun.swing.FilePane;

public final class FixFileChooser
extends JFileChooser
implements PropertyChangeListener {
    private static final long serialVersionUID = -346484285443111970L;
    private static final String VIEW_TYPE_DETAILS = "viewTypeDetails";
    private static final String VIEW_TYPE = "viewType";
    private final JTable detailsTable;

    public FixFileChooser() {
        this.viewDetails();
        this.detailsTable = this.findChildComponent(this, JTable.class);
        this.addViewTypeAction();
    }

    private void viewDetails() {
        Action action = this.getActionMap().get(VIEW_TYPE_DETAILS);
        if (action != null) {
            action.actionPerformed(null);
        }
    }

    private <T> T findChildComponent(Container container, Class<T> clazz) {
        for (Component component : container.getComponents()) {
            Container container2;
            T t;
            if (clazz.isInstance(component)) {
                return clazz.cast(component);
            }
            if (!(component instanceof Container) || (t = this.findChildComponent(container2 = (Container)component, clazz)) == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public void setCurrentDirectory(File file) {
        super.setCurrentDirectory(file);
        this.fixNameColumnWidth();
    }

    private void fixNameColumnWidth() {
        if (this.detailsTable != null) {
            int n;
            int n2;
            Container container = this.detailsTable.getParent().getParent();
            if (container instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container;
                jScrollPane.setVerticalScrollBarPolicy(22);
            }
            if ((n2 = this.detailsTable.getPreferredSize().width) < (n = this.detailsTable.getParent().getSize().width)) {
                TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
                tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n - n2);
            }
        }
    }

    private void addViewTypeAction() {
        FilePane filePane = this.findChildComponent(this, FilePane.class);
        if (filePane != null) {
            filePane.addPropertyChangeListener(VIEW_TYPE, this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue().equals(1)) {
            this.fixNameColumnWidth();
        }
    }
}

