/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;

public enum Laf implements SettingButtonGroupItem
{
    SYSTEM(UIManager.getSystemLookAndFeelClassName(), "ui.system", true),
    LIGHT(FlatLightLaf.class.getCanonicalName(), "ui.light", true),
    DARK(FlatDarkLaf.class.getCanonicalName(), "ui.dark", false);

    private final String lafName;
    private final String text;
    private final boolean lightMode;

    private Laf(String string2, String string3, boolean bl) {
        this.lafName = string2;
        this.text = AppResource.appText(string3);
        this.lightMode = bl;
    }

    public Laf update() {
        try {
            UIManager.setLookAndFeel(this.lafName);
            Laf.setUIFont();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            exception.printStackTrace();
            return null;
        }
        return this;
    }

    @Override
    public String getButtonName() {
        return this.text;
    }

    public boolean isLight() {
        return this.lightMode;
    }

    private static void setUIFont() {
        String string = AppResource.appText("ui.font");
        if (!string.equals("ui.font")) {
            FontUIResource fontUIResource = new FontUIResource(string, 0, 11);
            for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof FontUIResource)) continue;
                UIManager.put(entry.getKey(), fontUIResource);
            }
        }
    }
}

