/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import javax.swing.JOptionPane;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.FileTransferHandler;
import jp.fourthline.mabiicco.IllegalTickTableException;
import jp.fourthline.mabiicco.Laf;
import jp.fourthline.mabiicco.LauncherSupport;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.Splash;
import jp.fourthline.mabiicco.Splash2;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.DLSSetupDialog;
import jp.fourthline.mabiicco.ui.MainFrame;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTickTable;
import jp.fourthline.mmlTools.core.NanoTime;
import jp.fourthline.mmlTools.parser.MidiFile;

public final class MabiIcco {
    private final String[] args;
    private final ISplash splash = System.getProperty("mabiicco.splash") == null ? new Splash() : new Splash2();
    private final MabiIccoProperties appProperties;
    private final MabiDLS dls;

    public MabiIcco(String[] stringArray) {
        this.args = stringArray;
        this.splash.setVisible(true);
        this.appProperties = MabiIccoProperties.getInstance();
        this.dls = MabiDLS.getInstance();
    }

    public void start() throws Exception {
        this.splash.updateProgress(AppResource.appText("init.midi"), 10);
        this.initialize();
    }

    private boolean tempoAllowChordPart(int n) {
        InstClass instClass = this.dls.getInstByProgram(n);
        if (instClass != null) {
            return instClass.getType().allowTempoChordPart();
        }
        return true;
    }

    public boolean percussionMotionFix(int n) {
        if (((Boolean)this.appProperties.percussionMotionFix.get()).booleanValue()) {
            InstClass instClass = this.dls.getInstByProgram(n);
            InstType instType = instClass.getType();
            return instType == InstType.KPUR || instType == InstType.PERCUSSION;
        }
        return false;
    }

    private void initialize() throws Exception {
        CompletableFuture.runAsync(() -> MMLTickTable.getInstance());
        ActionDispatcher actionDispatcher = ActionDispatcher.getInstance();
        this.dls.initializeMIDI();
        this.splash.updateProgress("OK\n", 20);
        MMLTrack.setTempoAllowChordPartFunction(this::tempoAllowChordPart);
        MMLTrack.setPercussionMotionFixFunction(this::percussionMotionFix);
        if (((Boolean)this.appProperties.useDefaultSoundBank.get()).booleanValue()) {
            this.dls.loadingDefaultSound();
        } else {
            this.loadingDLS();
        }
        if (!((Boolean)this.appProperties.useDefaultSoundBank.get()).booleanValue()) {
            MidiFile.enableInstPatch();
        }
        if (!MMLTickTable.getInstance().verify()) {
            throw new IllegalTickTableException();
        }
        MainFrame mainFrame = new MainFrame(actionDispatcher, actionDispatcher);
        mainFrame.setTransferHandler(new FileTransferHandler(actionDispatcher));
        this.splash.updateProgress("", 100);
        actionDispatcher.setMainFrame(mainFrame).initialize();
        if (!actionDispatcher.recoveryCheck() && this.args.length > 0) {
            this.startOpen(actionDispatcher, this.args[0]);
        }
        mainFrame.setVisible(true);
        this.splash.dispose();
        this.dls.getWavout().startDataLine();
    }

    private void startOpen(ActionDispatcher actionDispatcher, String string) {
        File file = new File(string);
        if (!file.exists()) {
            String[] stringArray = LauncherSupport.getCommandLineArgs(this.args.length);
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            file = new File(stringArray[0]);
        }
        actionDispatcher.checkAndOpenMMLFile(file);
    }

    private void loadingDLS() {
        this.splash.updateProgress(AppResource.appText("init.dls"), 20);
        BooleanSupplier booleanSupplier = () -> {
            try {
                return this.tryloadDLSFiles(20.0, 80.0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        };
        boolean bl = booleanSupplier.getAsBoolean();
        while (!bl) {
            if (bl) continue;
            Object[] objectArray = new Object[]{AppResource.appText("start.selectDLS"), AppResource.appText("start.useInternal"), AppResource.appText("start.exit")};
            int n = JOptionPane.showOptionDialog(null, AppResource.appText("start.message"), AppResource.appText("start.title"), -1, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                if (!new DLSSetupDialog(null).showDialog()) continue;
                bl = booleanSupplier.getAsBoolean();
                continue;
            }
            if (n == 1) {
                this.appProperties.useDefaultSoundBank.set(true);
                this.dls.loadingDefaultSound();
                bl = true;
                continue;
            }
            if (n != 2) continue;
            System.exit(0);
        }
        this.splash.updateProgress("OK\n", 90);
    }

    private boolean tryloadDLSFiles(double d, double d2) throws IOException {
        double d3;
        List<File> list;
        List<File> list2 = this.appProperties.getDlsFile();
        if (list2.size() > 0 && !list2.equals(list = this.dls.loadingDLSFiles(list2, arg_0 -> this.lambda$tryloadDLSFiles$2(d3 = d2 - d, d, arg_0)))) {
            System.out.println("Update DLS file list:");
            System.out.println(" > " + list2);
            System.out.println(" > " + list);
            this.appProperties.setDlsFile(list);
        }
        return this.dls.getAvailableInstByInstType(InstType.MAIN_INST_LIST).length > 0;
    }

    public static void main(String[] stringArray) {
        try {
            NanoTime nanoTime = NanoTime.start();
            MabiIccoProperties mabiIccoProperties = MabiIccoProperties.getInstance();
            if (((Boolean)mabiIccoProperties.uiscaleDisable.get()).booleanValue()) {
                System.setProperty("sun.java2d.uiScale.enabled", "false");
            }
            ((Laf)mabiIccoProperties.laf.get()).update();
            MMLException.setLocalizeFunc(string -> AppResource.appText(string));
            new MabiIcco(stringArray).start();
            System.out.println("started " + nanoTime.ms() + "ms");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                throwable.printStackTrace(new PrintStream(AppResource.getErrFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, throwable.getMessage(), "ERROR", 0);
            System.exit(0);
        }
    }

    private /* synthetic */ void lambda$tryloadDLSFiles$2(double d, double d2, double d3) {
        double d4 = d * d3 + d2;
        this.splash.updateProgress("", (int)d4);
    }

    public static interface ISplash {
        public void setVisible(boolean var1);

        public void updateProgress(String var1, int var2);

        public void dispose();
    }
}

