/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.Laf;
import jp.fourthline.mabiicco.MMLOptimizeLevel;
import jp.fourthline.mabiicco.midi.MMLMidiTrack;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mabiicco.ui.PianoRollScaler;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.TimeBox;
import jp.fourthline.mabiicco.ui.color.ColorSet;
import jp.fourthline.mabiicco.ui.color.ScaleColor;
import jp.fourthline.mabiicco.ui.editor.VelocityEditor;
import jp.fourthline.mmlTools.MMLBuilder;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.core.MMLText;
import jp.fourthline.mmlTools.core.ResourceLoader;

public final class MabiIccoProperties {
    private final PreloadedProperties properties = new PreloadedProperties();
    private static final MabiIccoProperties instance = new MabiIccoProperties();
    private static final String CONFIG_FILE = ".mabiicco.config";
    private static final String RECENT_FILE = "app.recent_file";
    private final StringProperty dls_file = new StringProperty("app.dls_file", AppResource.appText("default.dls_file"));
    public final Property<Boolean> windowMaximize = new BooleanProperty("window.maximize", false);
    private static final String WINDOW_X = "window.x";
    private static final String WINDOW_Y = "window.y";
    private static final String WINDOW_WIDTH = "window.width";
    private static final String WINDOW_HEIGHT = "window.height";
    public final EnumProperty<PianoRollView.NoteHeight> pianoRollNoteHeight = new EnumProperty(this, "view.pianoRoll.heightScale", (Enum[])PianoRollView.NoteHeight.values(), (Enum)PianoRollView.NoteHeight.H8);
    public final EnumProperty<TimeBox.Type> timebox = new EnumProperty(this, "view.timeBox", (Enum[])TimeBox.Type.values(), (Enum)TimeBox.Type.MEASURE);
    public final EnumProperty<SoundEnv> soundEnv = new EnumProperty(this, "function.sound_env", (Enum[])SoundEnv.values(), (Enum)SoundEnv.MABINOGI);
    public final Property<Boolean> enableClickPlay = new BooleanProperty("function.enable_click_play", true);
    public final Property<Boolean> enableViewTempo = new BooleanProperty("function.enable_view_tempo", true);
    public final Property<Boolean> enableViewMarker = new BooleanProperty("function.enable_view_marker", true);
    public final Property<Boolean> enableEdit = new BooleanProperty("function.enable_edit", true);
    public final Property<Boolean> viewRange = new BooleanProperty("view.pianoRoll.range", true);
    public final Property<Boolean> instAttr = new BooleanProperty("view.instrument.attribute", true);
    public final Property<Boolean> showAllVelocity = new BooleanProperty("view.pianoRoll.show_all_velocity", false);
    public final Property<Boolean> viewVelocityLine = new BooleanProperty("view.velocity.line", true);
    public final Property<Boolean> activePartSwitch = new BooleanProperty("function.active_part_switch", false);
    public final EnumProperty<MMLOptimizeLevel> mmlOptimizeLevel = new EnumProperty(this, "function.mml_optimize_level", (Enum[])MMLOptimizeLevel.values(), (Enum)MMLOptimizeLevel.LV2, mMLOptimizeLevel -> mMLOptimizeLevel.change());
    public final Property<String> midiInputDevice = new StringProperty("midi.input_device");
    public final EnumProperty<ScaleColor> scaleColor = new EnumProperty(this, "scale.color", (Enum[])ScaleColor.values(), (Enum)ScaleColor.C_MAJOR);
    public final Property<Boolean> midiChordInput = new BooleanProperty("midi.chord_input", false);
    public static final int MAX_FILE_HISTORY = 8;
    private static final String FILE_HISTORY = "file.history";
    public final Property<Boolean> percussionMotionFix = new BooleanProperty("function.percussion_motion_fix", false);
    public final Property<String> mmlEmptyCorrection = new StringProperty("function.mml_empty_correction", AppResource.appText("mml.emptyCorrection.default"), string -> MMLText.setMelodyEmptyStr(string));
    public final Property<Boolean> mmlVZeroTempo = new BooleanProperty("function.mml_vzero_tempo", false, bl -> MMLBuilder.setMMLVZeroTempo(bl));
    public final Property<Boolean> mmlFix64Tempo = new BooleanProperty("function.mml_fix64_tempo", false, bl -> MMLScore.setMMLFix64(bl));
    public final EnumProperty<Laf> laf = new EnumProperty(this, "ui.laf", (Enum[])Laf.values(), (Enum)Laf.LIGHT, laf -> ColorSet.update(laf.isLight()));
    public final Property<Boolean> uiscaleDisable = new BooleanProperty("ui.scale_disable", false);
    public final Property<MMLMidiTrack.OverlapMode> overlapMode = new FixedProperty<MMLMidiTrack.OverlapMode>(MMLMidiTrack.OverlapMode.ALL);
    public final Property<Boolean> useDefaultSoundBank = new BooleanProperty("function.use_default_soundbank", false);
    public final Property<Boolean> enableTempoDeleteWithConvert = new BooleanProperty("function.tempoDeleteWithConvert", false);
    public final EnumProperty<PianoRollScaler.MouseScrollWidth> mouseScrollWidth = new EnumProperty(this, "function.mouse_scroll_width", (Enum[])PianoRollScaler.MouseScrollWidth.values(), (Enum)PianoRollScaler.MouseScrollWidth.AUTO);
    public final Property<Boolean> reGenerateWithOpen = new BooleanProperty("function.reGenerateWithOpen", true);
    public final Property<Boolean> velocityEditor = new BooleanProperty("function.velocityEditor", false);
    public final EnumProperty<VelocityEditor.VelocityWidth> velocityWidth = new EnumProperty(this, "function.velocityEditor.velocity_width", (Enum[])VelocityEditor.VelocityWidth.values(), (Enum)VelocityEditor.VelocityWidth.W4);
    public final Property<String> drumConvertCustomMap = new StringProperty("function.drum_convert_custom_map");
    private final LinkedList<File> fileHistory = new LinkedList();

    public static MabiIccoProperties getInstance() {
        return instance;
    }

    private MabiIccoProperties() {
        this.initFileHistory();
    }

    public String getRecentFile() {
        return this.properties.getProperty(RECENT_FILE, "");
    }

    public void setRecentFile(String string) {
        this.properties.setProperty(RECENT_FILE, string);
        this.properties.save();
    }

    public List<File> getDlsFile() {
        return this.convertDLSList((String)this.dls_file.get());
    }

    public List<File> getDlsDefaultFile() {
        return this.convertDLSList((String)this.dls_file.getDefault());
    }

    private List<File> convertDLSList(String string) {
        String[] stringArray = string.split(",", 64);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : stringArray) {
            if (!string2.toLowerCase().endsWith(".dls")) continue;
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    public void setDlsFile(List<File> list) {
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (list.size() > 0) {
                for (File file : list) {
                    stringBuilder.append(file.getPath()).append(',');
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            this.dls_file.set(stringBuilder.toString());
        }
    }

    public Rectangle getWindowRect() {
        String string = this.properties.getProperty(WINDOW_X, null);
        String string2 = this.properties.getProperty(WINDOW_Y, null);
        String string3 = this.properties.getProperty(WINDOW_WIDTH, null);
        String string4 = this.properties.getProperty(WINDOW_HEIGHT, null);
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return null;
        }
        return new Rectangle(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
    }

    public void setWindowRect(Rectangle rectangle) {
        if (!((Boolean)this.windowMaximize.get()).booleanValue() && rectangle.getX() >= 0.0 && rectangle.getY() >= 0.0) {
            this.properties.setProperty(WINDOW_X, Integer.toString((int)rectangle.getX()));
            this.properties.setProperty(WINDOW_Y, Integer.toString((int)rectangle.getY()));
            this.properties.setProperty(WINDOW_WIDTH, Integer.toString((int)rectangle.getWidth()));
            this.properties.setProperty(WINDOW_HEIGHT, Integer.toString((int)rectangle.getHeight()));
            this.properties.save();
        }
    }

    private void initFileHistory() {
        for (int i = 0; i < 8; ++i) {
            String string = this.properties.getProperty(FILE_HISTORY + i);
            if (string == null) continue;
            this.fileHistory.addLast(new File(string));
        }
    }

    public File[] getFileHistory() {
        File[] fileArray = new File[this.fileHistory.size()];
        return this.fileHistory.toArray(fileArray);
    }

    public void setFileHistory(File file) {
        this.fileHistory.remove(file);
        this.fileHistory.addFirst(file);
        while (this.fileHistory.size() > 8) {
            this.fileHistory.removeLast();
        }
        for (int i = 0; i < this.fileHistory.size(); ++i) {
            this.properties.setProperty(FILE_HISTORY + i, this.fileHistory.get(i).getAbsolutePath());
        }
        this.properties.save();
    }

    private static final class PreloadedProperties
    extends Properties {
        private static final long serialVersionUID = 7450043736414817020L;
        private final boolean test_mode = System.getProperty("mabiicco.test_mode") != null;
        private final String path = ResourceLoader.getAppConfigPath(".mabiicco.config");

        private PreloadedProperties() {
            if (!this.test_mode) {
                try (FileInputStream fileInputStream = new FileInputStream(this.path);){
                    super.load(fileInputStream);
                }
                catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        private void save() {
            if (!this.test_mode) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.path);){
                    this.store(fileOutputStream, "");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private final class StringProperty
    extends AbstractProperty<String> {
        private StringProperty(String string) {
            super(string, "", null);
        }

        private StringProperty(String string, String string2) {
            super(string, string2, null);
        }

        private StringProperty(String string, String string2, Consumer<String> consumer) {
            super(string, string2, consumer);
        }

        @Override
        protected String parseValue(String string) {
            return string;
        }

        @Override
        protected String stringValue(String string) {
            return string == null ? (String)this.defaultValue : string;
        }
    }

    private final class BooleanProperty
    extends AbstractProperty<Boolean> {
        private BooleanProperty(String string, boolean bl) {
            super(string, bl, null);
        }

        private BooleanProperty(String string, boolean bl, Consumer<Boolean> consumer) {
            super(string, bl, consumer);
        }

        @Override
        protected Boolean parseValue(String string) {
            return Boolean.parseBoolean(string);
        }

        @Override
        protected String stringValue(Boolean bl) {
            return Boolean.toString(bl);
        }
    }

    public static interface Property<T>
    extends Supplier<T> {
        public void set(T var1);
    }

    public static final class EnumProperty<T extends Enum<T>>
    extends AbstractProperty<T> {
        private final T[] values;
        final /* synthetic */ MabiIccoProperties this$0;

        private EnumProperty(String string, T[] TArray, T t) {
            this(var1_1, string, (Enum[])TArray, (Enum)t, null);
        }

        private EnumProperty(String string, T[] TArray, T t, Consumer<T> consumer) {
            this.this$0 = var1_1;
            super(string, t, null);
            this.values = TArray;
            this.optDo = consumer;
            if (consumer != null) {
                consumer.accept((Enum)this.get());
            }
        }

        @Override
        protected T parseValue(String string) {
            for (T t : this.values) {
                if (!this.stringValue(t).equals(string)) continue;
                return t;
            }
            try {
                int n = Integer.parseInt(string);
                if (n >= 0 && n < this.values.length) {
                    T t = this.values[n];
                    this.set((Object)t);
                    return t;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return (T)((Enum)this.defaultValue);
        }

        @Override
        protected String stringValue(T t) {
            return ((Enum)t).name();
        }

        public T[] getValues() {
            return this.values;
        }

        @Override
        public T getDefault() {
            return (T)((Enum)this.defaultValue);
        }
    }

    public static class FixedProperty<T>
    implements Property<T> {
        private final T value;

        private FixedProperty(T t) {
            this.value = t;
        }

        @Override
        public void set(T t) {
            throw new AssertionError();
        }

        @Override
        public T get() {
            return this.value;
        }
    }

    private abstract class AbstractProperty<T>
    implements Property<T> {
        protected final String name;
        protected final T defaultValue;
        protected Consumer<T> optDo;

        private AbstractProperty(String string, T t, Consumer<T> consumer) {
            this.name = string;
            this.defaultValue = t;
            this.optDo = consumer;
            if (consumer != null) {
                consumer.accept(this.get());
            }
        }

        @Override
        public void set(T t) {
            MabiIccoProperties.this.properties.setProperty(this.name, this.stringValue(t));
            MabiIccoProperties.this.properties.save();
            if (this.optDo != null) {
                this.optDo.accept(t);
            }
        }

        @Override
        public T get() {
            String string = MabiIccoProperties.this.properties.getProperty(this.name, this.stringValue(this.defaultValue));
            T t = this.parseValue(string);
            if (t == null) {
                t = this.defaultValue;
            }
            return t;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        protected abstract T parseValue(String var1);

        protected abstract String stringValue(T var1);
    }
}

