/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIcco;
import jp.fourthline.mabiicco.SmoothProgressBar;

public final class Splash
extends JDialog
implements MabiIcco.ISplash {
    private static final long serialVersionUID = -4276613664298174063L;
    private final SplashPanel splashPanel = new SplashPanel();

    public Splash() {
        this.getContentPane().add(this.splashPanel);
        this.setUndecorated(true);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void updateProgress(String string, int n) {
        this.splashPanel.textArea.setText(this.splashPanel.textArea.getText() + string);
        this.splashPanel.progress.setValue(n);
    }

    public static final class SplashPanel
    extends JPanel {
        private static final long serialVersionUID = 2210455372955295858L;
        private static final int WIDTH = 300;
        private static final int HEIGHT = 220;
        private final ImageIcon img;
        private final JProgressBar progress = new SmoothProgressBar();
        private final JLabel version = new JLabel();
        private final JTextArea textArea = new JTextArea();

        private SplashPanel() {
            this.setLayout(null);
            this.img = AppResource.getImageIcon("/img/title.png");
            this.setPreferredSize(new Dimension(300, 220));
            this.progress.setMaximum(100);
            this.add(this.progress);
            this.progress.setBounds(4, 206, 292, 12);
            this.add(this.version);
            this.version.setText("Version: " + AppResource.getVersionText());
            this.version.setBounds(160, 60, 120, 14);
            this.add(this.textArea);
            this.textArea.setEditable(false);
            this.textArea.setFocusable(false);
            this.textArea.setBounds(20, 100, 260, 80);
            this.textArea.setBorder(new RoundBorder(20, 10));
            this.setOpaque(false);
            this.setBorder(new LineBorder(Color.GRAY, 1, false));
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawImage(this.img.getImage(), 0, 0, this);
            super.paint(graphics);
        }
    }

    static final class RoundBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 429150943820077975L;
        private final int r;
        private final Insets insets;

        RoundBorder(int n, int n2) {
            this.r = n;
            this.insets = new Insets(n2, n2, n2, n2);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(0.6f, 0.6f, 0.6f));
            graphics2D.drawRoundRect(0, 0, n3 - 1, n4 - 1, this.r, this.r);
            graphics2D.dispose();
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }
    }
}

