/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.PolyphonyMonitor;

public final class ExtendMessage
extends ShortMessage {
    public static boolean debug = false;
    private final int channel;

    public ExtendMessage(int n, int n2, int n3, int n4) throws InvalidMidiDataException {
        super(n, n2 & 0xF, n3, n4);
        this.channel = n2;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public static final class ExtendReceiver
    implements Receiver {
        private final Receiver target;
        private final boolean[][] cache;

        public ExtendReceiver(Receiver receiver, int n) {
            this.target = receiver;
            this.cache = new boolean[n][];
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = new boolean[128];
                for (int j = 0; j < this.cache[i].length; ++j) {
                    this.cache[i][j] = false;
                }
            }
        }

        private void allStop(int n) {
            for (int i = 0; i < this.cache.length; ++i) {
                for (int j = 0; j < this.cache[i].length; ++j) {
                    if (!this.cache[i][j]) continue;
                    try {
                        this.target.send(new ExtendMessage(144, i, j, 0), 0L);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        invalidMidiDataException.printStackTrace();
                    }
                    this.cache[i][j] = false;
                }
            }
            MabiDLS.getInstance().allNoteOff();
        }

        private String messageString(MidiMessage midiMessage, long l) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = midiMessage.getStatus() & 0xF0;
            int n2 = midiMessage.getStatus() & 0xF;
            stringBuilder.append(midiMessage.getClass().getName()).append(' ');
            switch (n) {
                case 128: {
                    stringBuilder.append("NOTE_OFF");
                    break;
                }
                case 144: {
                    stringBuilder.append("NOTE_ON");
                    break;
                }
                case 192: {
                    stringBuilder.append("PROGRAM_CHANGE");
                    break;
                }
                default: {
                    stringBuilder.append("unkown(").append(n).append(")");
                }
            }
            stringBuilder.append(' ');
            stringBuilder.append(n2).append(' ');
            if (midiMessage instanceof ExtendMessage) {
                ExtendMessage extendMessage = (ExtendMessage)midiMessage;
                stringBuilder.append("ch=").append(extendMessage.getChannel()).append(' ');
            }
            for (Object object : (ExtendMessage)midiMessage.getMessage()) {
                stringBuilder.append((int)object).append(' ');
            }
            return stringBuilder.toString();
        }

        @Override
        public void send(MidiMessage midiMessage, long l) {
            if (midiMessage instanceof ExtendMessage) {
                ExtendMessage extendMessage = (ExtendMessage)midiMessage;
                int n = extendMessage.getCommand();
                if (n == 144 || n == 128) {
                    int n2 = extendMessage.getChannel();
                    int n3 = extendMessage.getData1();
                    this.cache[n2][n3] = n == 144;
                    this.target.send(midiMessage, l);
                    if (debug) {
                        System.out.println(this.messageString(midiMessage, l));
                    }
                }
            } else if (midiMessage instanceof ShortMessage) {
                ShortMessage shortMessage = (ShortMessage)midiMessage;
                int n = shortMessage.getCommand();
                int n4 = shortMessage.getChannel();
                int n5 = shortMessage.getData1();
                if (n == 176 && n4 >= 0 && n5 == 123) {
                    this.allStop(n4);
                }
            }
            PolyphonyMonitor.getInstance().update();
        }

        @Override
        public void close() {
            this.target.close();
        }
    }
}

