/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import java.util.Arrays;
import java.util.List;

public interface InstType {
    public static final InstType NONE = new NoneType();
    public static final InstType NORMAL = new NormalType();
    public static final InstType PERCUSSION = new PercussionType(false);
    public static final InstType KPUR = new PercussionType(true);
    public static final InstType VOICE = new SongType();
    public static final InstType CHORUS = new SongType();
    public static final InstType DRUMS = new DrumsType();
    public static final List<InstType> MAIN_INST_LIST = Arrays.asList(NORMAL, PERCUSSION, KPUR, VOICE, DRUMS);
    public static final List<InstType> SUB_INST_LIST = List.of(CHORUS);
    public static final int VOICE_PLAYBACK_CHANNEL = 10;

    public boolean[] getEnablePart();

    public boolean allowTranspose();

    public boolean allowTempoChordPart();

    public int convertVelocityMML2Midi(int var1);

    public boolean allowExcludeSongPart();

    public static InstType getInstType(String string) {
        switch (string) {
            case "0": {
                return NONE;
            }
            case "N": {
                return NORMAL;
            }
            case "P": {
                return PERCUSSION;
            }
            case "V": {
                return VOICE;
            }
            case "C": {
                return CHORUS;
            }
            case "K": {
                return KPUR;
            }
            case "D": {
                return DRUMS;
            }
        }
        throw new AssertionError();
    }

    public static class NoneType
    extends NormalType {
        private NoneType() {
            super(NormalType.NONE_PART, false, false, false);
        }

        @Override
        public int convertVelocityMML2Midi(int n) {
            return 0;
        }
    }

    public static class NormalType
    implements InstType {
        private static final boolean[] NONE_PART = new boolean[]{false, false, false, false};
        private static final boolean[] ONE_PART = new boolean[]{true, false, false, false};
        private static final boolean[] THREE_PART = new boolean[]{true, true, true, false};
        private static final boolean[] SONG_PART = new boolean[]{false, false, false, true};
        private final boolean[] enablePart;
        private final boolean allowTranspose;
        private final boolean allowTempoChordPart;
        private final boolean allowExcludeSongPart;

        private NormalType() {
            this(THREE_PART, true, true, true);
        }

        private NormalType(boolean[] blArray, boolean bl, boolean bl2, boolean bl3) {
            this.enablePart = blArray;
            this.allowTranspose = bl;
            this.allowTempoChordPart = bl2;
            this.allowExcludeSongPart = bl3;
        }

        @Override
        public final boolean[] getEnablePart() {
            return this.enablePart;
        }

        @Override
        public final boolean allowTranspose() {
            return this.allowTranspose;
        }

        @Override
        public final boolean allowTempoChordPart() {
            return this.allowTempoChordPart;
        }

        @Override
        public int convertVelocityMML2Midi(int n) {
            if (n > 15) {
                n = 15;
            } else if (n < 0) {
                n = 0;
            }
            return n * 8;
        }

        @Override
        public boolean allowExcludeSongPart() {
            return this.allowExcludeSongPart;
        }
    }

    public static class PercussionType
    extends NormalType {
        private PercussionType(boolean bl) {
            super(NormalType.ONE_PART, bl, false, true);
        }

        @Override
        public int convertVelocityMML2Midi(int n) {
            if (n > 11) {
                n = 11;
            } else if (n < 0) {
                n = 0;
            }
            return n * 11;
        }
    }

    public static class SongType
    extends NormalType {
        private SongType() {
            super(NormalType.SONG_PART, true, false, false);
        }
    }

    public static class DrumsType
    extends NormalType {
        private DrumsType() {
            super(NormalType.THREE_PART, false, true, true);
        }
    }
}

