/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import java.util.ArrayList;
import java.util.List;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;
import jp.fourthline.mmlTools.MMLNoteEvent;

public final class MMLMidiTrack {
    private final InstClass inst;
    private final ArrayList<MMLNoteEvent> noteEventList;
    private int attackDelayCorrect = 0;
    private final OverlapMode overlapMode;

    public MMLMidiTrack(InstClass instClass) {
        this.overlapMode = (OverlapMode)MabiIccoProperties.getInstance().overlapMode.get();
        this.inst = instClass;
        this.noteEventList = new ArrayList();
    }

    public List<MMLNoteEvent> getNoteEventList() {
        return this.noteEventList;
    }

    public void setAttackDelayCorrect(int n) {
        this.attackDelayCorrect = n;
    }

    public void clear() {
        this.noteEventList.clear();
    }

    public void add(List<MMLNoteEvent> list) {
        for (MMLNoteEvent mMLNoteEvent : list) {
            this.addItem(mMLNoteEvent.clone());
        }
    }

    private void addItem(MMLNoteEvent mMLNoteEvent) {
        int n = mMLNoteEvent.getTickOffset();
        int n2 = 0;
        if (this.attackDelayCorrect != 0) {
            if ((n += this.attackDelayCorrect) < 0) {
                int n3 = mMLNoteEvent.getTick() + n;
                if (n3 <= 0) {
                    return;
                }
                n = 0;
                mMLNoteEvent.setTick(n3);
            }
            mMLNoteEvent.setTickOffset(n);
        }
        for (MMLNoteEvent mMLNoteEvent2 : this.noteEventList) {
            if (mMLNoteEvent2.getTickOffset() > n) break;
            ++n2;
            if (mMLNoteEvent2.getTickOffset() != n || mMLNoteEvent2.getNote() != mMLNoteEvent.getNote()) continue;
            break;
        }
        if ((mMLNoteEvent = this.overlapNote(n2, mMLNoteEvent)) != null) {
            this.noteEventList.add(n2, mMLNoteEvent);
        }
    }

    private MMLNoteEvent overlapNote(int n, MMLNoteEvent mMLNoteEvent) {
        MMLNoteEvent mMLNoteEvent2;
        if (this.overlapMode.isOverlap(this.inst, mMLNoteEvent.getNote())) {
            return mMLNoteEvent;
        }
        int n2 = mMLNoteEvent.getTickOffset();
        if (n > 0) {
            mMLNoteEvent2 = this.noteEventList.get(n - 1);
            if (mMLNoteEvent.getNote() == mMLNoteEvent2.getNote() && mMLNoteEvent2.getTickOffset() == n2) {
                if (mMLNoteEvent2.getTick() >= mMLNoteEvent.getTick()) {
                    this.noteEventList.get(n - 1).setTick(mMLNoteEvent.getTick());
                }
                return null;
            }
        }
        if (n < this.noteEventList.size()) {
            mMLNoteEvent2 = this.noteEventList.get(n);
            this.trimOverlapNote(mMLNoteEvent, mMLNoteEvent2);
        }
        return mMLNoteEvent;
    }

    private void trimOverlapNote(MMLNoteEvent mMLNoteEvent, MMLNoteEvent mMLNoteEvent2) {
        int n;
        if (mMLNoteEvent.getTickOffset() >= mMLNoteEvent2.getTickOffset()) {
            new AssertionError();
        }
        if (mMLNoteEvent.getNote() == mMLNoteEvent2.getNote() && (n = mMLNoteEvent.getEndTick() - mMLNoteEvent2.getTickOffset()) > 0) {
            mMLNoteEvent.setTick(mMLNoteEvent.getTick() - n);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OverlapMode implements SettingButtonGroupItem
    {
        NONE{

            @Override
            public boolean isOverlap(InstClass instClass, int n) {
                return false;
            }
        }
        ,
        INST{

            @Override
            public boolean isOverlap(InstClass instClass, int n) {
                return instClass.isOverlap(n);
            }
        }
        ,
        ALL{

            @Override
            public boolean isOverlap(InstClass instClass, int n) {
                return true;
            }
        };

        private final String name = AppResource.appText("menu.overlap_mode." + super.name().toLowerCase());

        @Override
        public String getButtonName() {
            return this.name;
        }

        public abstract boolean isOverlap(InstClass var1, int var2);
    }
}

