/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jp.fourthline.mabiicco.midi.ISoundDataLine;
import jp.fourthline.mabiicco.midi.IWavoutState;
import jp.fourthline.mmlTools.core.NanoTime;

public final class WavoutDataLine
implements SourceDataLine,
IWavoutState {
    private final SourceDataLine parent;
    private final AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private boolean rec = false;
    private OutputStream outputStream = null;
    private File tempFile = null;
    private OutputStream tempOutputStream = null;
    private Runnable endNotify;
    private ISoundDataLine soundDataLine = null;
    private final AtomicInteger lineStallCounter = new AtomicInteger(0);
    private Thread dataLineObserverThread;
    private final Runnable dataLineObserver = () -> {
        try {
            System.out.println("start DataLineAutoFlush.");
            while (true) {
                Thread.sleep(100L);
                if (this.lineStallCounter.incrementAndGet() <= 3) continue;
                this.reconnect();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    };
    private long time;
    private long curLen;

    private void reconnect() {
        this.parent.flush();
        System.out.println(System.currentTimeMillis() + " flush");
    }

    public WavoutDataLine() throws LineUnavailableException {
        this.parent = AudioSystem.getSourceDataLine(this.format);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public long getLen() {
        return this.curLen;
    }

    public void startRec(File file, Runnable runnable) throws IOException {
        try {
            this.tempFile = File.createTempFile("wavout_", ".tmp", file.getParentFile());
            System.out.println("startRec:" + this.tempFile);
            this.tempOutputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile), 65536);
            this.rec = true;
            this.outputStream = new FileOutputStream(file);
            this.endNotify = runnable;
            this.time = 0L;
            this.curLen = 0L;
        }
        catch (IOException iOException) {
            if (this.tempOutputStream != null) {
                this.tempOutputStream.close();
                this.tempOutputStream = null;
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
                this.tempFile = null;
            }
            throw iOException;
        }
    }

    public void stopRec() {
        if (this.rec && this.endNotify != null) {
            this.rec = false;
            this.endNotify.run();
            this.endNotify = null;
        }
        this.rec = false;
    }

    public boolean isRec() {
        return this.rec;
    }

    @Override
    public void drain() {
        this.parent.drain();
    }

    @Override
    public void flush() {
        this.parent.flush();
    }

    @Override
    public void start() {
        this.parent.start();
    }

    @Override
    public void stop() {
        this.parent.stop();
    }

    @Override
    public boolean isRunning() {
        return this.parent.isRunning();
    }

    @Override
    public boolean isActive() {
        return this.parent.isActive();
    }

    @Override
    public AudioFormat getFormat() {
        return this.parent.getFormat();
    }

    @Override
    public int getBufferSize() {
        return this.parent.getBufferSize();
    }

    @Override
    public int available() {
        return this.parent.available();
    }

    @Override
    public int getFramePosition() {
        return this.parent.getFramePosition();
    }

    @Override
    public long getLongFramePosition() {
        return this.parent.getLongFramePosition();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.parent.getMicrosecondPosition();
    }

    @Override
    public float getLevel() {
        return this.parent.getLevel();
    }

    @Override
    public Line.Info getLineInfo() {
        return this.parent.getLineInfo();
    }

    @Override
    public void open() throws LineUnavailableException {
        this.parent.open();
    }

    @Override
    public void close() {
        this.parent.close();
    }

    @Override
    public boolean isOpen() {
        return this.parent.isOpen();
    }

    @Override
    public Control[] getControls() {
        return this.parent.getControls();
    }

    @Override
    public boolean isControlSupported(Control.Type type) {
        return this.parent.isControlSupported(type);
    }

    @Override
    public Control getControl(Control.Type type) {
        return this.parent.getControl(type);
    }

    @Override
    public void addLineListener(LineListener lineListener) {
        this.parent.addLineListener(lineListener);
    }

    @Override
    public void removeLineListener(LineListener lineListener) {
        this.parent.removeLineListener(lineListener);
    }

    @Override
    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        this.parent.open(audioFormat, n);
    }

    @Override
    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.parent.open(audioFormat);
    }

    private void wavoutEndCheck(byte[] byArray, int n, int n2) {
        if (!this.rec && this.tempOutputStream != null) {
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] == 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                try {
                    this.tempOutputStream.close();
                    long l = this.tempFile.length();
                    AudioInputStream audioInputStream = new AudioInputStream(new FileInputStream(this.tempFile), this.format, l / (long)this.format.getFrameSize());
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.outputStream);
                    audioInputStream.close();
                    this.outputStream.close();
                    System.out.println("stopRec: " + l);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.tempFile.delete();
                this.tempOutputStream = null;
            }
        }
    }

    @Override
    public int write(byte[] byArray, int n, int n2) {
        this.wavoutEndCheck(byArray, n, n2);
        if (this.tempOutputStream != null) {
            NanoTime nanoTime = NanoTime.start();
            this.curLen += (long)n2;
            try {
                this.tempOutputStream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.time += nanoTime.ms();
        }
        if (this.soundDataLine != null) {
            this.soundDataLine.write(byArray);
        }
        int n3 = this.parent.write(byArray, n, n2);
        this.lineStallCounter.set(0);
        return n3;
    }

    @Override
    public void setSoundDataLine(ISoundDataLine iSoundDataLine) {
        this.soundDataLine = iSoundDataLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDataLine() {
        WavoutDataLine wavoutDataLine = this;
        synchronized (wavoutDataLine) {
            if ("true".equals(System.getProperties().get("mabiicco.dlaf")) && this.dataLineObserverThread == null) {
                this.dataLineObserverThread = new Thread(this.dataLineObserver, "DataLine Observer");
                this.dataLineObserverThread.start();
            }
        }
    }
}

