/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.CircleIcon;
import jp.fourthline.mabiicco.ui.UIUtils;

public final class About {
    private String readNotice() {
        try {
            InputStream inputStream = About.class.getResourceAsStream("/NOTICE");
            if (inputStream == null) {
                inputStream = new FileInputStream("NOTICE");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String string = bufferedReader.lines().collect(Collectors.joining("\n"));
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public void show(Frame frame) {
        String string = AppResource.appText("menu.about");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Version:  ").append(AppResource.getVersionText());
        stringBuilder.append('\n').append("Runtime: ").append(AppResource.getRuntimeVersion());
        JOptionPane.showMessageDialog(frame, stringBuilder.toString(), string, -1);
    }

    public void showLicenses(Frame frame) {
        String string = AppResource.appText("3rd_licenses");
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        String string2 = this.readNotice();
        String[] stringArray = string2.split("================================================================================\n=");
        for (int i = 1; i < stringArray.length; ++i) {
            String string3 = stringArray[i].substring(0, stringArray[i].indexOf(10)).trim();
            JTextArea jTextArea = new JTextArea(stringArray[i]);
            jTextArea.setEditable(false);
            jTextArea.setCaretPosition(0);
            jTabbedPane.add(string3, new JScrollPane(jTextArea));
        }
        jPanel.setPreferredSize(new Dimension(600, 400));
        JOptionPane.showMessageDialog(frame, jPanel, string, -1);
    }

    private String getAccText(List<KeyStroke> list) {
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(keyStroke -> {
            if (keyStroke != null) {
                int n;
                int n2;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if ((n2 = keyStroke.getModifiers()) > 0) {
                    stringBuilder.append(KeyEvent.getKeyModifiersText(n2));
                    stringBuilder.append("+");
                }
                if ((n = keyStroke.getKeyCode()) != 0) {
                    stringBuilder.append(KeyEvent.getKeyText(n));
                } else {
                    stringBuilder.append(keyStroke.getKeyChar());
                }
            }
        });
        return stringBuilder.toString();
    }

    public void showShortcutInfo(Frame frame, Map<String, List<KeyStroke>> map) {
        Vector<String> vector = new Vector<String>();
        vector.add(AppResource.appText("shortcut.table.key"));
        vector.add(AppResource.appText("shortcut.table.function"));
        Vector vector2 = new Vector();
        map.entrySet().forEach(entry -> {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            Vector<String> vector2 = new Vector<String>();
            vector2.add(this.getAccText(list));
            vector2.add(string);
            vector2.add(vector2);
        });
        JTable jTable = UIUtils.createTable(vector2, vector);
        jTable.getColumnModel().getColumn(0).setMinWidth(200);
        jTable.getColumnModel().getColumn(0).setMaxWidth(200);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        String string = AppResource.appText("menu.shortcutInfo");
        JOptionPane.showMessageDialog(frame, jScrollPane, string, -1);
    }

    private Icon getInstIcon(InstClass instClass) {
        InstType instType = instClass.getType();
        if (instType instanceof InstType.SongType) {
            return ListItem.S_ICON;
        }
        if (instType instanceof InstType.DrumsType) {
            return ListItem.D_ICON;
        }
        if (instType instanceof InstType.PercussionType) {
            return ListItem.P_ICON;
        }
        if (instType instanceof InstType.NormalType) {
            return ListItem.N_ICON;
        }
        return ListItem.B_ICON;
    }

    public void showInstList(Frame frame) {
        MabiDLS mabiDLS = MabiDLS.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        List<InstClass> list = mabiDLS.getAllInst();
        mabiDLS.getInstsMap().forEach((file, list2) -> {
            ListItem listItem = new ListItem(file, ListItem.DLS_ICON);
            list2.forEach(instClass -> {
                boolean bl = list.contains(instClass);
                ListItem listItem2 = new ListItem(instClass, bl, this.getInstIcon((InstClass)instClass));
                listItem.add(listItem2);
                if (bl) {
                    listItem2.add(new ListItem((Object)instClass.getMidiName(), ListItem.B_ICON));
                    listItem2.add(new ListItem((Object)("transposable: " + instClass.getType().allowTranspose()), null));
                    for (int i = instClass.getUpperNote(); i >= instClass.getLowerNote(); --i) {
                        if (!instClass.isValid(i)) continue;
                        listItem2.add(new ListItem((Object)String.format("%s: %s%s", i, instClass.getAttention(i), instClass.isOverlap(i) ? ", overlap" : ""), null));
                    }
                }
            });
            defaultMutableTreeNode.add(listItem);
        });
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setCellRenderer(new DLSInfoRenderer());
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        String string = AppResource.appText("menu.instList");
        JOptionPane.showMessageDialog(frame, jScrollPane, string, -1);
    }

    private static class ListItem
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -3147229489704024291L;
        private static final Icon N_ICON = new CircleIcon(8, Color.BLUE);
        private static final Icon P_ICON = new CircleIcon(8, Color.ORANGE);
        private static final Icon S_ICON = new CircleIcon(8, Color.GREEN);
        private static final Icon D_ICON = new CircleIcon(8, Color.MAGENTA);
        private static final Icon B_ICON = new CircleIcon(8, Color.WHITE, Color.GRAY);
        private static final Icon DLS_ICON = AppResource.getImageIcon("/img/dls_icon.png");
        private final Icon icon;

        private ListItem(Object object, Icon icon) {
            this(object, true, icon);
        }

        private ListItem(Object object, boolean bl, Icon icon) {
            super(object, bl);
            this.icon = icon;
        }
    }

    private static class DLSInfoRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 4935457943334555902L;

        private DLSInfoRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setText(string);
            if (object instanceof ListItem) {
                ListItem listItem = (ListItem)object;
                this.setIcon(listItem.icon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

