/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import javax.sound.midi.Sequencer;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.color.ColorManager;
import jp.fourthline.mabiicco.ui.color.ColorSet;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mabiicco.ui.editor.IMarkerEditor;
import jp.fourthline.mabiicco.ui.editor.MMLTempoEditor;
import jp.fourthline.mabiicco.ui.editor.MarkerEditor;
import jp.fourthline.mabiicco.ui.editor.StartOffsetEditor;
import jp.fourthline.mabiicco.ui.editor.TimeSignatureEditor;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.Marker;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;

public final class ColumnPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
IViewTargetMarker {
    private static final long serialVersionUID = -6609938350741425221L;
    private static final ColorSet BEAT_BORDER_COLOR = ColorSet.create(new Color(0.4f, 0.4f, 0.4f), new Color(128, 128, 128));
    private static final Color TEMPO_MAKER_FILL_COLOR = new Color(0.4f, 0.8f, 0.8f);
    private static final Color MAKER_FILL_COLOR = new Color(0.2f, 0.8f, 0.2f);
    private static final Color TIME_SIGNATURE_FILL_COLOR = new Color(255, 165, 0);
    private static final Color TARGET_MAKER_FILL_COLOR = new Color(0.9f, 0.7f, 0.0f, 0.6f);
    private static final ColorSet START_COMMON_OFFSET_COLOR = ColorSet.create(new Color(255, 167, 227), Color.decode("#993366"));
    private static final ColorSet START_OFFSET_COLOR = ColorSet.create(new Color(255, 202, 227), Color.decode("#996666"));
    private static final ColorSet TEXT_COLOR = ColorSet.create(Color.DARK_GRAY, Color.LIGHT_GRAY);
    private static final int DRAW_HEIGHT = 32;
    private static final int DRAW_OFFSET_HEIGHT = 6;
    private static final int DRAW_HEIGHT_ERR_BAR = 10;
    private final PianoRollView pianoRollView;
    private final IMMLManager mmlManager;
    private final IEditAlign editAlign;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final ArrayList<IMarkerEditor> markerEditor = new ArrayList();
    private final MabiDLS dls = MabiDLS.getInstance();
    private final MabiIccoProperties appProperties = MabiIccoProperties.getInstance();
    private OptionalInt targetMarker = OptionalInt.empty();
    private static final float[] dash = new float[]{2.0f, 4.0f};
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);

    public ColumnPanel(Frame frame, final PianoRollView pianoRollView, IMMLManager iMMLManager, IEditAlign iEditAlign) {
        this.pianoRollView = pianoRollView;
        this.mmlManager = iMMLManager;
        this.editAlign = iEditAlign;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        MMLTempoEditor mMLTempoEditor = new MMLTempoEditor(frame, iMMLManager, iEditAlign, (IViewTargetMarker)this);
        this.markerEditor.add(mMLTempoEditor);
        this.markerEditor.add(new MarkerEditor(frame, iMMLManager, iEditAlign, (IViewTargetMarker)this));
        this.markerEditor.add(new TimeSignatureEditor(frame, iMMLManager, iEditAlign, (IViewTargetMarker)this));
        this.markerEditor.add(new StartOffsetEditor(frame, iMMLManager, iEditAlign, this));
        this.markerEditor.forEach(iMarkerEditor -> iMarkerEditor.getMenuItems().forEach(this.popupMenu::add));
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                ColumnPanel.this.PaintOff();
                pianoRollView.repaint();
            }
        });
        ActionDispatcher.getInstance().addUpdateUIComponent(this.popupMenu);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), 44);
    }

    @Override
    public int getWidth() {
        return this.pianoRollView.getWidth();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        UIUtils.setRenderingHint(graphics2D);
        this.paintStartOffset(graphics2D);
        this.paintErr(graphics2D);
        this.paintRuler(graphics2D);
        this.paintMarker(graphics2D);
        this.paintTempoEvents(graphics2D);
        this.paintTimeSignature(graphics2D);
        this.pianoRollView.paintSequenceLine(graphics2D, this.getHeight());
        this.paintTargetMarker(graphics2D);
        if (((Boolean)this.appProperties.viewVelocityLine.get()).booleanValue()) {
            this.paintVelocityLine(graphics2D);
        }
        graphics2D.dispose();
    }

    private void paintStartOffset(Graphics2D graphics2D) {
        int n = this.getWidth();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashStroke);
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawLine(0, 32, n, 32);
        graphics2D.setStroke(stroke);
        int n2 = this.pianoRollView.convertTicktoX(this.mmlManager.getActiveTrack().getCommonStartOffset());
        int n3 = this.pianoRollView.convertTicktoX(this.mmlManager.getActiveMMLPartStartOffset());
        graphics2D.setColor(START_COMMON_OFFSET_COLOR.get());
        graphics2D.fillRect(0, 32, n2, 6);
        graphics2D.setColor(START_OFFSET_COLOR.get());
        graphics2D.fillRect(0, 38, n3, 6);
    }

    private void paintErr(Graphics2D graphics2D) {
        List<MMLExceptionList.Entry> list = this.mmlManager.getMMLScore().getMMLErr();
        graphics2D.setColor(Color.RED);
        for (MMLExceptionList.Entry entry : list) {
            int n = this.pianoRollView.convertTicktoX(entry.getNote().getTickOffset());
            int n2 = Math.max(this.pianoRollView.convertTicktoX(entry.getNote().getTick()), 2);
            graphics2D.fillRect(n, 1, n2, 10);
        }
    }

    private void paintRuler(Graphics2D graphics2D) {
        TimeSignature timeSignature;
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        Iterator<TimeSignature> iterator = mMLScore.getTimeSignatureList().iterator();
        int n = mMLScore.getTimeCountOnly() * mMLScore.getBeatTick();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getHeight();
        long l = this.pianoRollView.convertXtoTick(this.getWidth());
        graphics2D.setColor(BEAT_BORDER_COLOR.get());
        int n5 = 0;
        TimeSignature timeSignature2 = timeSignature = iterator.hasNext() ? iterator.next() : null;
        if (timeSignature != null) {
            n5 = timeSignature.getMeasureOffset();
        }
        while ((long)n3 < l) {
            int n6 = this.pianoRollView.convertTicktoX(n3);
            int n7 = 0;
            graphics2D.drawLine(n6, n7, n6, n4);
            graphics2D.drawString(Integer.toString(n2), n6 + 2, n7 + 10);
            if (timeSignature != null && n2 >= n5) {
                n = timeSignature.getNumTime() * timeSignature.getBaseTick();
                TimeSignature timeSignature3 = timeSignature = iterator.hasNext() ? iterator.next() : null;
                if (timeSignature != null) {
                    n5 = timeSignature.getMeasureOffset();
                }
            }
            ++n2;
            n3 += n;
        }
    }

    private void paintTempoEvents(Graphics2D graphics2D) {
        if (((Boolean)this.appProperties.enableViewTempo.get()).booleanValue()) {
            for (MMLTempoEvent mMLTempoEvent : this.mmlManager.getMMLScore().getTempoEventList()) {
                this.drawMarker(graphics2D, mMLTempoEvent, TEMPO_MAKER_FILL_COLOR, 0);
            }
        }
    }

    private void paintMarker(Graphics2D graphics2D) {
        if (((Boolean)this.appProperties.enableViewMarker.get()).booleanValue()) {
            for (Marker marker : this.mmlManager.getMMLScore().getMarkerList()) {
                this.drawMarker(graphics2D, marker, MAKER_FILL_COLOR, -11);
            }
        }
    }

    private void paintTimeSignature(Graphics2D graphics2D) {
        for (TimeSignature timeSignature : this.mmlManager.getMMLScore().getTimeSignatureList()) {
            this.drawMarker(graphics2D, timeSignature, TIME_SIGNATURE_FILL_COLOR, 11);
        }
    }

    private void drawMarker(Graphics2D graphics2D, MMLEvent mMLEvent, Color color, int n) {
        try {
            String string = mMLEvent.toMMLString();
            int n2 = this.pianoRollView.convertTicktoX(mMLEvent.getTickOffset());
            int[] nArray = new int[]{n2 - 3, n2 + 3, n2 + 3, n2, n2 - 3};
            int[] nArray2 = new int[]{-10, -10, -4, -1, -4};
            int n3 = 0;
            while (n3 < nArray2.length) {
                int n4 = n3++;
                nArray2[n4] = nArray2[n4] + (32 + n);
            }
            graphics2D.setColor(TEXT_COLOR.get());
            graphics2D.drawString(string, n2 + 6, 30 + n);
            graphics2D.setColor(color);
            graphics2D.fillPolygon(nArray, nArray2, nArray.length);
            graphics2D.setColor(BEAT_BORDER_COLOR.get());
            graphics2D.drawPolygon(nArray, nArray2, nArray.length);
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
        }
    }

    private void paintTargetMarker(Graphics2D graphics2D) {
        if (this.targetMarker.isEmpty()) {
            return;
        }
        int n = this.pianoRollView.convertTicktoX(this.targetMarker.getAsInt());
        int[] nArray = new int[]{n - 5, n + 5, n + 5, n, n - 5};
        int[] nArray2 = new int[]{8, 8, 27, 32, 27};
        graphics2D.setColor(TARGET_MAKER_FILL_COLOR);
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        graphics2D.setColor(BEAT_BORDER_COLOR.get());
        graphics2D.drawPolygon(nArray, nArray2, nArray.length);
    }

    private void paintVelocityLine(Graphics2D graphics2D) {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        int n = this.mmlManager.getActiveTrackIndex();
        Color color = ColorManager.defaultColor().getActiveRectColor(n);
        graphics2D.setColor(color);
        for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
            int n2 = this.pianoRollView.convertTicktoX(mMLNoteEvent.getTickOffset());
            int n3 = this.pianoRollView.convertTicktoX(mMLNoteEvent.getTick());
            int n4 = mMLNoteEvent.getVelocity();
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > 15) {
                n4 = 15;
            }
            int n5 = 32 - n4 - 2;
            graphics2D.drawLine(n2, n5, n2 + n3 - 1, n5);
        }
    }

    private void setSequenceBar(int n) {
        Sequencer sequencer = this.dls.getSequencer();
        if (!sequencer.isRunning()) {
            long l = this.pianoRollView.convertXtoTick(n);
            l -= l % (long)this.editAlign.getEditAlign();
            this.pianoRollView.setSequenceTick(l);
            this.repaint();
            this.pianoRollView.repaint();
        } else {
            long l = this.pianoRollView.convertXtoTick(n);
            int n2 = this.mmlManager.getMMLScore().getTempoOnTick(l);
            sequencer.setTickPosition(l);
            sequencer.setTempoInBPM(n2);
            System.out.printf("Sequence update: tick(%d), tempo(%d)\n", l, n2);
        }
    }

    private void playAllNoteOnTick(int n) {
        Sequencer sequencer = this.dls.getSequencer();
        if (!((Boolean)this.appProperties.enableClickPlay.get()).booleanValue()) {
            return;
        }
        if (!sequencer.isRunning()) {
            MMLScore mMLScore = this.mmlManager.getMMLScore();
            long l = this.pianoRollView.convertXtoTick(n);
            int n2 = 0;
            List<MMLNoteEvent[]> list = mMLScore.getNoteListOnTickOffset(l);
            for (MMLNoteEvent[] mMLNoteEventArray : list) {
                int n3 = 0;
                for (MMLNoteEvent mMLNoteEvent : mMLNoteEventArray) {
                    if (n < 0) {
                        this.dls.playNotes(mMLScore, null, n2, n3);
                    } else {
                        this.dls.playNotes(mMLScore, new MMLNoteEvent[]{mMLNoteEvent}, n2, n3);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private void popupAction(Component component, int n, int n2) {
        int n3 = (int)this.pianoRollView.convertXtoTick(n);
        int n4 = (int)this.pianoRollView.convertXtoTick(6);
        this.markerEditor.forEach(iMarkerEditor -> iMarkerEditor.activateEditMenuItem(n3, n4));
        this.popupMenu.show(component, n, n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupAction(mouseEvent.getComponent(), n, n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.setSequenceBar(n);
            this.playAllNoteOnTick(n);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.playAllNoteOnTick(-1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.playAllNoteOnTick(n);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void PaintOnTarget(int n) {
        this.targetMarker = OptionalInt.of(n);
        this.repaint();
    }

    @Override
    public void PaintOff() {
        this.targetMarker = OptionalInt.empty();
        this.repaint();
    }
}

