/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.FixFileChooser;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.DLSLoader;
import jp.fourthline.mabiicco.ui.UIUtils;

public final class DLSSetupDialog
extends JDialog {
    private static final long serialVersionUID = -2667995940954447811L;
    private final FileTableModel tableModel;
    private final JButton removeButton = new JButton(AppResource.appText("remove"));
    private boolean changed = false;

    public DLSSetupDialog(JFrame jFrame) {
        super(jFrame, AppResource.appText("menu.select_dls"), true);
        this.tableModel = new FileTableModel(MabiIccoProperties.getInstance().getDlsFile());
        JTable jTable = new JTable(this.tableModel);
        jTable.setSelectionMode(0);
        jTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.removeButton.setEnabled(jTable.getSelectedRow() != -1);
            }
        });
        JButton jButton = new JButton(AppResource.appText("add"));
        jButton.addActionListener(actionEvent -> this.addDLSFile(this.showAddDLSFileDialog()));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(actionEvent -> this.removeRow(jTable.getSelectedRow()));
        JButton jButton2 = new JButton(AppResource.appText("default"));
        jButton2.addActionListener(actionEvent -> this.setDefault());
        jButton.setAlignmentX(0.5f);
        this.removeButton.setAlignmentX(0.5f);
        jButton2.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.removeButton);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jButton2);
        String string = "<html>" + AppResource.appText("start.selectDLS.hint").replace("\n", "<br>") + "</html>";
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JPanel jPanel2 = UIUtils.createTitledPanel(string, new BorderLayout(5, 5), 10);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "East");
        JButton jButton3 = new JButton(AppResource.appText("ok"));
        JButton jButton4 = new JButton(AppResource.appText("cancel"));
        jButton3.addActionListener(actionEvent -> this.onOK());
        jButton4.addActionListener(actionEvent -> this.onCancel());
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pack();
        this.setSize(new Dimension(600, 300));
        this.setLocationRelativeTo(jFrame);
    }

    void addDLSFile(List<File> list) {
        if (list != null) {
            this.tableModel.addRow(list);
        }
    }

    private List<File> showAddDLSFileDialog() {
        int n;
        FixFileChooser fixFileChooser = new FixFileChooser();
        fixFileChooser.setMultiSelectionEnabled(true);
        fixFileChooser.setFileFilter(new FileNameExtensionFilter("DLS File (*.dls)", "dls"));
        String string = MabiIccoProperties.getInstance().getRecentFile();
        if (string != null && !string.isEmpty()) {
            ((JFileChooser)fixFileChooser).setCurrentDirectory(new File(string).getParentFile());
        }
        if ((n = fixFileChooser.showOpenDialog(this)) == 0) {
            return Arrays.asList(fixFileChooser.getSelectedFiles());
        }
        return null;
    }

    void removeRow(int n) {
        if (n != -1) {
            this.tableModel.removeRow(n);
        }
    }

    void setDefault() {
        this.tableModel.reset(MabiIccoProperties.getInstance().getDlsDefaultFile());
    }

    void onOK() {
        DLSLoader dLSLoader = new DLSLoader(this.tableModel.files);
        MabiIccoProperties.getInstance().setDlsFile(dLSLoader.getFileList());
        this.changed = true;
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    List<File> getFileList() {
        return this.tableModel.files;
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.changed;
    }

    private static class FileTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6882861566466408372L;
        private final String[] columnNames = new String[]{AppResource.appText("file.dls")};
        private final List<File> files;

        public FileTableModel(List<File> list) {
            this.files = new ArrayList<File>(list);
        }

        @Override
        public int getRowCount() {
            return this.files.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.files.get(n).getAbsolutePath();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        private void reset(List<File> list) {
            this.files.clear();
            this.files.addAll(new DLSLoader(list).getFileList());
            this.fireTableDataChanged();
        }

        private void addRow(List<File> list) {
            for (File file : list) {
                if (this.files.contains(file)) continue;
                if (this.files.size() >= 64) break;
                this.files.add(file);
            }
            this.fireTableDataChanged();
        }

        private void removeRow(int n) {
            if (n >= 0 && n < this.files.size()) {
                this.files.remove(n);
            }
            this.fireTableDataChanged();
        }
    }
}

