/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.MMLTrackView;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.Measure;

public final class MMLErrView {
    private final Vector<Vector<String>> dataList;

    public MMLErrView(MMLScore mMLScore) {
        this.dataList = this.makeList(mMLScore);
    }

    Vector<Vector<String>> getDataList() {
        return this.dataList;
    }

    private Vector<String> makeData(MMLScore mMLScore, MMLTrack mMLTrack, int n, int n2, int n3, String string) {
        Vector<String> vector = new Vector<String>();
        vector.add(Integer.toString(n + 1));
        vector.add(mMLTrack.getTrackName());
        if (n2 >= 0) {
            vector.add(MMLTrackView.MMLPART_NAME[n2]);
        } else {
            vector.add("-");
        }
        if (n3 >= 0) {
            vector.add(new Measure(mMLScore, n3).toString());
        } else {
            vector.add("-");
        }
        vector.add(string);
        return vector;
    }

    private Vector<Vector<String>> makeList(MMLScore mMLScore) {
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        List<MMLVerifyException> list = mMLScore.getVerifyErr();
        ArrayList<MMLExceptionList.Entry> arrayList = new ArrayList<MMLExceptionList.Entry>(mMLScore.getMMLErr());
        int n = 0;
        for (MMLTrack mMLTrack : mMLScore.getTrackList()) {
            int n2 = 0;
            for (MMLVerifyException mMLVerifyException : list) {
                if (mMLTrack != mMLVerifyException.getTrack()) continue;
                vector.add(this.makeData(mMLScore, mMLTrack, n, -1, -1, mMLVerifyException.getLocalizedMessage()));
            }
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                ArrayList<MMLExceptionList.Entry> arrayList2 = new ArrayList<MMLExceptionList.Entry>();
                for (MMLExceptionList.Entry entry : arrayList) {
                    if (!mMLEventList.getMMLNoteEventList().contains(entry.getNote()) || arrayList2.contains(entry)) continue;
                    arrayList2.add(entry);
                    vector.add(this.makeData(mMLScore, mMLTrack, n, n2, entry.getNote().getTickOffset(), entry.getException().getLocalizedMessage()));
                }
                arrayList.removeAll(arrayList2);
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public void showMMLErrList(Frame frame) {
        Vector<String> vector = new Vector<String>();
        vector.add(AppResource.appText("#"));
        vector.add(AppResource.appText("track"));
        vector.add(AppResource.appText("part"));
        vector.add(AppResource.appText("mml.err.position"));
        vector.add(AppResource.appText("mml.err.value"));
        JTable jTable = new JTable(new DefaultTableModel(this.dataList, vector){
            private static final long serialVersionUID = 5392169416298424707L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        jTable.getColumnModel().getColumn(0).setMinWidth(20);
        jTable.getColumnModel().getColumn(0).setMaxWidth(20);
        jTable.getColumnModel().getColumn(1).setMinWidth(100);
        jTable.getColumnModel().getColumn(1).setMaxWidth(100);
        jTable.getColumnModel().getColumn(2).setMinWidth(100);
        jTable.getColumnModel().getColumn(2).setMaxWidth(100);
        jTable.getColumnModel().getColumn(3).setMinWidth(100);
        jTable.getColumnModel().getColumn(3).setMaxWidth(100);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setRequestFocusEnabled(false);
        jTable.setFocusable(false);
        jTable.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        String string = AppResource.appText("menu.mmlErrList");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)new JLabel("" + this.dataList.size()), "South");
        JOptionPane.showMessageDialog(frame, jPanel, string, -1);
    }
}

