/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;
import javax.sound.midi.Sequencer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.IEditState;
import jp.fourthline.mabiicco.IFileState;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.AbstractMMLManager;
import jp.fourthline.mabiicco.ui.ColumnPanel;
import jp.fourthline.mabiicco.ui.KeyboardView;
import jp.fourthline.mabiicco.ui.MMLErrView;
import jp.fourthline.mabiicco.ui.MMLTrackView;
import jp.fourthline.mabiicco.ui.MainView;
import jp.fourthline.mabiicco.ui.PartButtonIcon;
import jp.fourthline.mabiicco.ui.PianoRollScaler;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.TrackTabbedPane;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.color.ScaleColor;
import jp.fourthline.mabiicco.ui.editor.KeyboardEditor;
import jp.fourthline.mabiicco.ui.editor.MMLEditor;
import jp.fourthline.mabiicco.ui.editor.MMLScoreUndoEdit;
import jp.fourthline.mabiicco.ui.editor.MMLTextEditor;
import jp.fourthline.mabiicco.ui.editor.VelocityEditor;
import jp.fourthline.mabiicco.ui.mml.MMLInputPanel;
import jp.fourthline.mabiicco.ui.mml.MMLOutputPanel;
import jp.fourthline.mabiicco.ui.mml.MMLPartChangePanel;
import jp.fourthline.mabiicco.ui.mml.MMLXImportPanel;
import jp.fourthline.mabiicco.ui.mml.TrackPropertyPanel;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.Measure;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.core.NanoTime;

public final class MMLSeqView
extends AbstractMMLManager
implements ChangeListener,
ActionListener,
MainView {
    private static final int INITIAL_TRACK_COUNT = 1;
    private final JScrollPane scrollPane;
    private final PianoRollView pianoRollView;
    private final PianoRollScaler pianoRollScaler;
    private final KeyboardView keyboardView;
    private final JTabbedPane tabbedPane;
    private final ColumnPanel columnView;
    private final JScrollPane velocityScrollPane;
    private final JPanel mainPanel;
    private final MMLScoreUndoEdit undoEdit = new MMLScoreUndoEdit(this);
    private final MMLEditor editor;
    private final KeyboardEditor keyboardEditor;
    private final VelocityEditor velocityEditor;
    private final JPanel panel;
    private final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(4);
    private final Frame parentFrame;
    private boolean currentEditMode = true;

    public MMLSeqView(Frame frame) {
        this.parentFrame = frame;
        this.panel = new JPanel(false);
        this.panel.setLayout(new BorderLayout(0, 0));
        this.mainPanel = new JPanel(new BorderLayout());
        this.pianoRollView = new PianoRollView();
        this.keyboardView = new KeyboardView(this, this.pianoRollView);
        this.scrollPane = new JScrollPane(this.pianoRollView, 22, 32);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.pianoRollView.getNoteHeight());
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.editor = new MMLEditor(frame, this.keyboardView, this.pianoRollView, this);
        this.columnView = new ColumnPanel(frame, this.pianoRollView, this, this.editor);
        this.velocityEditor = new VelocityEditor(this, this.pianoRollView, this.editor);
        this.velocityScrollPane = new JScrollPane(this.velocityEditor, 22, 32);
        this.mainPanel.add((Component)this.velocityScrollPane, "South");
        this.velocityScrollPane.setRowHeaderView(new VelocityEditor.VelocityEditorHeader(this.velocityEditor, this.velocityEditor));
        UIUtils.scrollChain(this.scrollPane, this.velocityScrollPane);
        this.setVelocityViewEnable((Boolean)MabiIccoProperties.getInstance().enableEdit.get());
        this.panel.add((Component)this.mainPanel, "Center");
        this.pianoRollView.setViewportAndParent(this.scrollPane.getViewport(), this);
        this.tabbedPane = new TrackTabbedPane(this);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setPreferredSize(new Dimension(0, 200));
        this.panel.add((Component)this.tabbedPane, "South");
        this.pianoRollScaler = new PianoRollScaler(this, this.pianoRollView, this.scrollPane, this, this.editor);
        this.pianoRollScaler.addScrollPane(this.scrollPane);
        this.pianoRollScaler.addScrollPane(this.velocityScrollPane);
        this.pianoRollScaler.addChangeScaleListener(this.velocityEditor);
        this.keyboardEditor = new KeyboardEditor(frame, this, this.keyboardView, this.editor, this.pianoRollView);
        this.scrollPane.setRowHeaderView(this.keyboardView);
        this.scrollPane.setColumnHeaderView(this.columnView);
        this.initialSetView();
        this.initializeMMLTrack();
        this.startSequenceThread();
    }

    public void setNoteAlignChanger(IntConsumer intConsumer) {
        this.keyboardEditor.setNoteAlignChanger(intConsumer);
    }

    public boolean recovery(String string) {
        boolean bl = this.undoEdit.recover(string);
        System.out.println("recover: " + bl);
        if (bl) {
            this.mmlScore = this.mmlScore.toGeneratedScore(false);
            this.undoEdit.revertState();
            this.updateTrackTabIcon();
            this.updateActivePart(false);
            this.updateProgramSelect();
        }
        return bl;
    }

    public String getRecoveryData() {
        return this.undoEdit.getBackupString();
    }

    @Override
    public void repaint() {
        boolean bl = (Boolean)MabiIccoProperties.getInstance().enableEdit.get();
        if (this.currentEditMode != bl) {
            this.currentEditMode = bl;
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getComponentAt(i);
                mMLTrackView.setVisibleMMLTextPanel(this.currentEditMode);
            }
            this.resetTrackView();
            this.tabbedPane.setPreferredSize(new Dimension(0, this.currentEditMode ? 200 : 60));
        }
        this.setVelocityViewEnable(bl);
        this.panel.repaint();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void initialSetView() {
        EventQueue.invokeLater(() -> {
            int n = this.pianoRollView.getTotalHeight() / 2 - this.scrollPane.getHeight() / 2;
            this.scrollPane.getViewport().setViewPosition(new Point(0, n));
        });
    }

    public void initializeMMLTrack() {
        this.mmlScore = new MMLScore();
        this.tabbedPane.removeAll();
        for (int i = 0; i < 1; ++i) {
            this.addMMLTrack(null);
        }
        this.panel.repaint();
        this.undoEdit.initState();
    }

    private String getNewTrackName() {
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        for (int i = 0; i <= 24; ++i) {
            linkedList.add((CallSite)((Object)("Track" + (i + 1))));
        }
        for (MMLTrack mMLTrack : this.mmlScore.getTrackList()) {
            linkedList.remove(mMLTrack.getTrackName());
        }
        return (String)linkedList.getFirst();
    }

    @Override
    public void addMMLTrack(MMLTrack mMLTrack) {
        int n;
        if (mMLTrack == null) {
            mMLTrack = new MMLTrack();
            mMLTrack.setTrackName(this.getNewTrackName());
        }
        if ((n = this.mmlScore.addTrack(mMLTrack)) < 0) {
            return;
        }
        this.tabbedPane.add(mMLTrack.getTrackName(), MMLTrackView.getInstance(n, this, this));
        this.tabbedPane.setSelectedIndex(n);
        this.updateTrackTabIcon();
        MabiDLS.getInstance().setMute(n, false);
        this.updateActivePart(true);
        this.updateSelectedTrackAndMMLPart();
        this.updateProgramSelect();
    }

    @Override
    public void moveTrack(int n) {
        int n2 = this.tabbedPane.getSelectedIndex();
        MabiDLS mabiDLS = MabiDLS.getInstance();
        boolean bl = mabiDLS.getMute(n2);
        this.mmlScore.moveTrack(n2, n);
        if (n2 < n) {
            for (int i = n2 + 1; i < n; ++i) {
                mabiDLS.setMute(i, mabiDLS.getMute(i + 1));
            }
        } else {
            for (int i = this.mmlScore.getTrackCount() - 1; i > n; --i) {
                mabiDLS.setMute(i, mabiDLS.getMute(i - 1));
            }
        }
        mabiDLS.setMute(n, bl);
        this.tabbedPane.setSelectedIndex(n);
        this.resetTrackView();
        this.updateActivePart(false);
    }

    public void removeMMLTrack() {
        int n = this.tabbedPane.getSelectedIndex();
        this.mmlScore.removeTrack(n);
        this.resetTrackView();
        for (int i = n; i < this.mmlScore.getTrackCount(); ++i) {
            MabiDLS mabiDLS = MabiDLS.getInstance();
            mabiDLS.setMute(i, mabiDLS.getMute(i + 1));
        }
        if (this.mmlScore.getTrackCount() == 0) {
            this.addMMLTrack(null);
        } else {
            this.mainPanel.repaint();
            this.updateSelectedTrackAndMMLPart();
        }
        this.updateActivePart(true);
    }

    private void updateTrackTabIcon() {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.tabbedPane.setIconAt(i, PartButtonIcon.getInstance(1, i));
        }
    }

    public void startSequence() {
        new Thread(() -> {
            NanoTime nanoTime = NanoTime.start();
            long l = this.pianoRollView.getSequencePosition();
            MabiDLS.getInstance().createSequenceAndStart(this.mmlScore, l);
            ActionDispatcher.getInstance().showTime("play", nanoTime);
        }).start();
    }

    @Override
    public void setMMLScore(MMLScore mMLScore) {
        this.mmlScore = mMLScore;
        this.tabbedPane.removeAll();
        int n = 0;
        for (MMLTrack mMLTrack : mMLScore.getTrackList()) {
            Object object = mMLTrack.getTrackName();
            if (object == null) {
                object = "Track" + (n + 1);
            }
            this.tabbedPane.add((String)object, MMLTrackView.getInstance(n, this, this));
            ++n;
        }
        this.undoEdit.initState();
        this.initialSetView();
        this.pianoRollView.setSequenceTick(0L);
        this.updateTrackTabIcon();
        this.updateActivePart(false);
        this.updateProgramSelect();
        this.mainPanel.repaint();
    }

    @Override
    public void setMMLselectedTrack(MMLTrack mMLTrack) {
        if (this.mmlScore.getTrackCount() == 1) {
            this.mmlScore.getTempoEventList().clear();
        }
        int n = this.tabbedPane.getSelectedIndex();
        this.mmlScore.setTrack(n, mMLTrack);
        this.tabbedPane.setTitleAt(n, mMLTrack.getTrackName());
        MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getComponentAt(n);
        mMLTrackView.updateTrack();
        this.updateSelectedTrackAndMMLPart();
        this.updateActivePart(false);
    }

    public MMLTrack getSelectedTrack() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        return this.mmlScore.getTrack(n);
    }

    public PianoRollView.PaintMode getPaintMode() {
        return this.pianoRollView.getPaintMode();
    }

    public void setPaintMode(PianoRollView.PaintMode paintMode) {
        this.pianoRollView.setPaintMode(paintMode);
    }

    public void editTrackPropertyAction() {
        MMLTrack mMLTrack = this.getSelectedTrack();
        new TrackPropertyPanel(mMLTrack, this).showDialog(this.parentFrame);
        this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), mMLTrack.getTrackName());
    }

    private void setViewPosition(int n) {
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        Dimension dimension = jViewport.getExtentSize();
        double d = point.getX();
        double d2 = d + dimension.getWidth();
        if ((double)n < d || (double)n > d2) {
            point.setLocation((double)n, point.getY());
            jViewport.setViewPosition(point);
        }
    }

    public void setPianoRollHeightScale(PianoRollView.NoteHeight noteHeight) {
        this.pianoRollView.setNoteHeight(noteHeight);
        this.keyboardView.updateHeight();
        this.panel.repaint();
    }

    public void resetViewPosition() {
        this.setViewPosition(this.pianoRollView.getSequenceX());
    }

    public void setStartPosition() {
        Sequencer sequencer = MabiDLS.getInstance().getSequencer();
        if (!sequencer.isRunning()) {
            this.setViewPosition(0);
            this.pianoRollView.setSequenceTick(0L);
            this.panel.repaint();
        } else {
            sequencer.setTempoInBPM(120.0f);
            sequencer.setTickPosition(0L);
        }
    }

    public void pauseTickPosition() {
        Sequencer sequencer = MabiDLS.getInstance().getSequencer();
        long l = sequencer.getTickPosition();
        l -= l % (long)MMLTicks.minimumTick();
        this.pianoRollView.setSequenceTick(l);
    }

    public void inputClipBoardAction() {
        MMLInputPanel mMLInputPanel = new MMLInputPanel(this.parentFrame, this.getNewTrackName(), this);
        mMLInputPanel.showDialog();
    }

    public void mml_xImportAction() {
        new MMLXImportPanel(this.parentFrame, this.getNewTrackName(), this).showDialog();
    }

    public void mml_xExportAction() {
        MMLTrack mMLTrack = this.getSelectedTrack();
        if (!mMLTrack.mmlRank().canCompose()) {
            MMLOutputPanel.createSelectedTrackMMLSplitPanel(this.parentFrame, mMLTrack, this.mmlScore).showDialog();
        }
    }

    public void outputClipBoardAction() {
        MMLOutputPanel mMLOutputPanel = new MMLOutputPanel(this.parentFrame, this.mmlScore.getTrackList(), this.mmlScore);
        mMLOutputPanel.showDialog();
    }

    public void mmlImport() {
        String string = MMLInputPanel.getClipboardString();
        if (new MMLTrack().setMML(string).isEmpty()) {
            return;
        }
        this.getSelectedTrack().setMabiMML(string);
        this.resetTrackView();
        this.undoEdit.saveState();
        this.panel.repaint();
    }

    public void mmlExport() {
        String string = this.getActiveTrack().getMabiMML();
        MMLOutputPanel.copyToClipboard(this.parentFrame, string, AppResource.appText("mml.output.done"));
    }

    private void updateSelectedTrackAndMMLPart() {
        MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getSelectedComponent();
        if (mMLTrackView != null) {
            mMLTrackView.updateMuteButton();
            int n = this.getActivePartProgram();
            this.editor.reset();
            InstClass instClass = MabiDLS.getInstance().getInstByProgram(n);
            this.pianoRollView.setRelativeInst(instClass);
            this.keyboardView.setRelativeInst(instClass);
            this.mainPanel.repaint();
        }
    }

    @Override
    public int getActiveTrackIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public int getActiveMMLPartIndex() {
        MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getSelectedComponent();
        return mMLTrackView != null ? mMLTrackView.getSelectedMMLPartIndex() : 0;
    }

    @Override
    public MMLEventList getActiveMMLPart() {
        if (!this.currentEditMode) {
            return null;
        }
        MMLTrack mMLTrack = this.getActiveTrack();
        return mMLTrack.getMMLEventAtIndex(this.getActiveMMLPartIndex());
    }

    public void setEditAlign(int n) {
        this.editor.setEditAlign(n);
    }

    public PianoRollScaler getPianoRollScaler() {
        return this.pianoRollScaler;
    }

    private void resetTrackView() {
        int n = this.tabbedPane.getSelectedIndex();
        int n2 = ((MMLTrackView)this.tabbedPane.getSelectedComponent()).getSelectedMMLPartIndex();
        this.tabbedPane.removeAll();
        int n3 = 0;
        for (MMLTrack mMLTrack : this.mmlScore.getTrackList()) {
            this.tabbedPane.add(mMLTrack.getTrackName(), MMLTrackView.getInstance(n3, this, this));
            ++n3;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (this.mmlScore.getTrackCount() > 0) {
            MMLTrack mMLTrack = this.mmlScore.getTrack(n);
            int n4 = mMLTrack.getProgram();
            if (!(InstClass.getEnablePartByProgram(n4)[n2] || n2 == 3 && mMLTrack.getSongProgram() >= 0)) {
                n2 = InstClass.getFirstPartNumberOnProgram(n4);
            }
            this.tabbedPane.setSelectedIndex(n);
            ((MMLTrackView)this.tabbedPane.getSelectedComponent()).setSelectMMLPartOfIndex(n2);
            this.updateTrackTabIcon();
        }
    }

    public void undo() {
        if (this.undoEdit.canUndo()) {
            NanoTime nanoTime = NanoTime.start();
            this.undoEdit.undo();
            this.mmlScore = this.mmlScore.toGeneratedScore(false);
            this.resetTrackView();
            this.updateSelectedTrackAndMMLPart();
            this.updateActivePart(false);
            ActionDispatcher.getInstance().showTime("undo", nanoTime);
        }
    }

    public void redo() {
        if (this.undoEdit.canRedo()) {
            NanoTime nanoTime = NanoTime.start();
            this.undoEdit.redo();
            this.mmlScore = this.mmlScore.toGeneratedScore(false);
            this.resetTrackView();
            this.updateSelectedTrackAndMMLPart();
            this.updateActivePart(false);
            ActionDispatcher.getInstance().showTime("redo", nanoTime);
        }
    }

    public void nextStepTimeTo(boolean bl) {
        int n = (int)this.pianoRollView.getSequencePlayPosition();
        n = Measure.nextMeasure(this.mmlScore, n, bl);
        Sequencer sequencer = MabiDLS.getInstance().getSequencer();
        if (!sequencer.isRunning()) {
            this.pianoRollView.setSequenceTick(n);
            this.panel.repaint();
        } else {
            int n2 = this.mmlScore.getTempoOnTick(n);
            sequencer.setTickPosition(n);
            sequencer.setTempoInBPM(n2);
        }
        this.updatePianoRollView();
    }

    public void partChange() {
        MMLPartChangePanel mMLPartChangePanel = new MMLPartChangePanel(this.parentFrame, this, this.editor);
        mMLPartChangePanel.showDialog();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.tabbedPane) {
            this.updateSelectedTrackAndMMLPart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateSelectedTrackAndMMLPart();
    }

    @Override
    public void generateActiveTrack() {
        this.updateActivePart(true);
    }

    @Override
    public void updateActivePart(boolean bl) {
        NanoTime nanoTime = NanoTime.start();
        if (bl) {
            try {
                this.mmlScore.generateAll();
            }
            catch (MMLExceptionList | MMLVerifyException exception) {
                this.showErrMessage(this.mmlScore, exception);
                System.err.println("REVERT: " + exception.getMessage());
                this.undoEdit.revertState();
                this.editor.reset();
            }
            this.panel.repaint();
        }
        this.updateAllMMLPart();
        ActionDispatcher.getInstance().showTime("update", nanoTime);
    }

    private void updateAllMMLPart() {
        if (this.tabbedPane.getTabCount() != this.mmlScore.getTrackCount()) {
            this.resetTrackView();
            this.updateProgramSelect();
        }
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getComponentAt(i);
            mMLTrackView.updateTrack();
        }
        MabiDLS.getInstance().updateMidiControl(this.mmlScore);
        this.undoEdit.saveState();
        this.panel.repaint();
    }

    @Override
    public void updateActiveTrackProgram(int n, int n2, int n3) {
        MMLTrack mMLTrack = this.mmlScore.getTrack(n);
        int n4 = mMLTrack.getProgram();
        mMLTrack.setProgram(n2);
        mMLTrack.setSongProgram(n3);
        this.updateSelectedTrackAndMMLPart();
        if (MMLTrack.percussionMotionFix.apply(n4) != MMLTrack.percussionMotionFix.apply(n2)) {
            this.generateActiveTrack();
        } else {
            this.undoEdit.saveState();
        }
        this.updateProgramSelect();
    }

    @Override
    public boolean selectTrackOnExistNote(int n, int n2) {
        PianoRollView.PaintMode paintMode = this.pianoRollView.getPaintMode();
        int n3 = this.tabbedPane.getSelectedIndex();
        int n4 = this.mmlScore.getTrackCount();
        for (int i = 0; i < n4; ++i) {
            int n5 = 0;
            int n6 = (i + n3) % n4;
            MMLTrack mMLTrack = this.mmlScore.getTrack(n6);
            if (paintMode != PianoRollView.PaintMode.ALL_TRACK && (paintMode != PianoRollView.PaintMode.ACTIVE_TRACK || mMLTrack != this.getSelectedTrack())) continue;
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(n2);
                if (mMLNoteEvent != null && n == mMLNoteEvent.getNote()) {
                    this.tabbedPane.setSelectedIndex(n6);
                    MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getSelectedComponent();
                    mMLTrackView.setSelectMMLPartOfIndex(n5);
                    this.updateSelectedTrackAndMMLPart();
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public void switchTrack(boolean bl) {
        int n = this.tabbedPane.getSelectedIndex();
        n = bl ? (n + 1 < this.tabbedPane.getTabCount() ? ++n : 0) : (n - 1 >= 0 ? --n : this.tabbedPane.getTabCount() - 1);
        this.tabbedPane.setSelectedIndex(n);
        this.updateSelectedTrackAndMMLPart();
    }

    public void switchMMLPart(boolean bl) {
        MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getSelectedComponent();
        mMLTrackView.switchMMLPart(bl);
        this.updateSelectedTrackAndMMLPart();
    }

    public IFileState getFileState() {
        return this.undoEdit;
    }

    public IEditState getEditState() {
        return this.editor;
    }

    public long getEditSequencePosition() {
        return this.pianoRollView.getSequencePosition();
    }

    public void addTicks(boolean bl) {
        int n = (int)this.pianoRollView.getSequencePosition();
        this.mmlScore.addTicks(n, bl);
        this.updateActivePart(true);
    }

    public void removeTicks(boolean bl) {
        int n = (int)this.pianoRollView.getSequencePosition();
        this.mmlScore.removeTicks(n, bl);
        this.updateActivePart(true);
    }

    private void startSequenceThread() {
        this.scheduledExecutor.scheduleWithFixedDelay(() -> {
            if (MabiDLS.getInstance().getSequencer().isRunning()) {
                EventQueue.invokeLater(() -> this.updatePianoRollView(true));
            }
        }, 500L, 25L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void updatePianoRollView() {
        this.updatePianoRollView(false);
    }

    private void updatePianoRollView(boolean bl) {
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        int n = this.pianoRollView.convertY2Note(point.y) - 1;
        this.updatePianoRollView(n, bl);
    }

    @Override
    public void updatePianoRollView(int n) {
        this.updatePianoRollView(n, false);
    }

    private void updatePianoRollView(int n, boolean bl) {
        this.pianoRollView.updateRunningSequencePosition();
        int n2 = (int)this.pianoRollView.getSequencePlayPosition();
        int n3 = this.pianoRollView.convertTicktoX(n2);
        Measure measure = new Measure(this.mmlScore, n2);
        int n4 = this.pianoRollView.convertTicktoX(measure.measuredTick());
        JViewport jViewport = this.scrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        Dimension dimension = jViewport.getExtentSize();
        int n5 = point.x;
        int n6 = point.x;
        int n7 = this.pianoRollView.convertTicktoX(Measure.measuredTick(this.mmlScore, (int)this.pianoRollView.convertXtoTick(n5 + dimension.width) - measure.getMeasureTick()));
        if (n5 > n3 || n5 + dimension.width < n3) {
            n6 = n3;
        } else if (n4 > n7 && dimension.width > this.pianoRollView.convertTicktoX(measure.getMeasureTick()) && this.pianoRollView.getWidth() - dimension.width > n5) {
            n6 = n4;
        }
        long l = this.pianoRollView.convertNote2Y(n);
        int n8 = point.y;
        int n9 = n8 + dimension.height - this.pianoRollView.getNoteHeight() * 2;
        if (l >= (long)n8) {
            if (l > (long)n9) {
                l -= (long)dimension.height;
                l += (long)(this.pianoRollView.getNoteHeight() * 2);
            } else {
                l = point.y;
            }
        }
        point.setLocation((double)n6, l);
        jViewport.setViewPosition(point);
        UIUtils.viewportSetPositionWorkaround(jViewport, point);
        if (bl) {
            this.scrollPane.repaint();
        } else {
            this.mainPanel.repaint();
        }
    }

    @Override
    public int getActivePartProgram() {
        MMLTrackView mMLTrackView = (MMLTrackView)this.tabbedPane.getSelectedComponent();
        MMLTrack mMLTrack = this.getSelectedTrack();
        if (mMLTrackView != null) {
            int n = mMLTrackView.getSelectedMMLPartIndex();
            if (n == 3) {
                return MabiDLS.getInstance().selectSongProgram(mMLTrack.getProgram(), mMLTrack.getSongProgram());
            }
            return mMLTrack.getProgram();
        }
        return 0;
    }

    private void updateProgramSelect() {
        this.scheduledExecutor.submit(() -> MabiDLS.getInstance().loadRequiredInstruments(this.mmlScore));
    }

    public void showKeyboardInput() {
        this.editor.reset();
        this.repaint();
        this.keyboardEditor.setVisible(true);
    }

    public void setScaleColor(ScaleColor scaleColor) {
        this.pianoRollView.setScaleColor(scaleColor);
        this.pianoRollView.repaint();
    }

    @Override
    public long getSequencePosition() {
        return this.pianoRollView.getSequencePlayPosition();
    }

    public void mmlTextEditor() {
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            return;
        }
        try {
            new MMLTextEditor(this.parentFrame, this, this.pianoRollView).showDialog();
        }
        catch (MMLExceptionList mMLExceptionList) {
            this.showErrMessage(this.mmlScore, mMLExceptionList);
        }
    }

    private void setVelocityViewEnable(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (Boolean)MabiIccoProperties.getInstance().velocityEditor.get() != false && bl;
        if (bl2 != this.velocityScrollPane.isVisible()) {
            this.velocityScrollPane.setVisible(bl2);
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    private void showErrMessage(MMLScore mMLScore, Exception exception) {
        MMLErrView mMLErrView = new MMLErrView(mMLScore);
        EventQueue.invokeLater(() -> {
            String string = AppResource.appText("fail.mml_modify") + "\n" + exception.getLocalizedMessage();
            Object[] objectArray = new String[]{"OK", "detail"};
            int n = JOptionPane.showOptionDialog(this.parentFrame, string, AppResource.getAppTitle(), -1, 2, null, objectArray, objectArray[0]);
            if (n == 1) {
                mMLErrView.showMMLErrList(this.parentFrame);
            }
        });
    }
}

