/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.IEditStateObserver;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mabiicco.ui.LevelMonitor;
import jp.fourthline.mabiicco.ui.MMLSeqView;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.PolyphonyMonitor;
import jp.fourthline.mabiicco.ui.TimeBox;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.EditTool;
import jp.fourthline.mabiicco.ui.editor.NoteAlign;

public final class MainFrame
extends JFrame
implements ComponentListener,
ActionListener {
    private static final long serialVersionUID = -7484797594534384422L;
    private final JPanel contentPane;
    private final JTextField statusField;
    private final MMLSeqView mmlSeqView;
    private final JComboBox<NoteAlign> noteTypeSelect = new JComboBox<NoteAlign>(NoteAlign.values());
    private final JComboBox<PianoRollView.PaintMode> paintModeSelect = new JComboBox<PianoRollView.PaintMode>(PianoRollView.PaintMode.values());
    private final TimeBox timeBox;
    private final ActionListener listener;
    private final MabiIccoProperties appProperties = MabiIccoProperties.getInstance();
    private final ArrayList<PlayStateComponent<?>> noplayFunctions = new ArrayList();
    private final Map<String, List<KeyStroke>> shortcutMap = new LinkedHashMap<String, List<KeyStroke>>();
    private PlayStateComponent<JMenuItem> reloadMenuItem = null;
    private PlayStateComponent<JMenuItem> undoMenu = null;
    private PlayStateComponent<JMenuItem> redoMenu = null;
    private PlayStateComponent<JMenuItem> saveMenuItem = null;
    private PlayStateComponent<JMenuItem> cutMenu = null;
    private PlayStateComponent<JMenuItem> copyMenu = null;
    private PlayStateComponent<JMenuItem> pasteMenu = null;
    private PlayStateComponent<JMenuItem> deleteMenu = null;
    private PlayStateComponent<JMenuItem> removeRestsBetweenNotesMenu = null;
    private PlayStateComponent<JMenuItem> octUpMenu = null;
    private PlayStateComponent<JMenuItem> octDownMenu = null;
    private PlayStateComponent<JMenuItem> velocityUpMenu = null;
    private PlayStateComponent<JMenuItem> velocityDownMenu = null;
    private PlayStateComponent<JMenuItem> xExportMenu = null;
    private JButton loopButton = null;
    private final MenuWithIndex[] fileHistory = new MenuWithIndex[8];
    private List<JToggleButton> editToolButton;

    public MainFrame(ActionListener actionListener, final IEditStateObserver iEditStateObserver) {
        this.listener = actionListener;
        this.setTitleAndFileName(null);
        this.setDefaultCloseOperation(3);
        this.loadWindowPeoperties();
        this.addComponentListener(this);
        this.setIconImage(AppResource.getImageIcon("/img/MabiIcco_Icon(Large).png").getImage());
        this.setJMenuBar(this.createMenuBar());
        this.contentPane = new JPanel();
        this.initKeyAction();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.contentPane.add((Component)jPanel, "North");
        this.mmlSeqView = new MMLSeqView(this);
        this.mmlSeqView.setNoteAlignChanger(this::changeNoteTypeSelect);
        this.contentPane.add((Component)this.mmlSeqView.getPanel(), "Center");
        this.contentPane.setFocusable(false);
        this.timeBox = new TimeBox(this.mmlSeqView);
        JToolBar jToolBar = this.createToolBar();
        jPanel.add(jToolBar);
        JPanel jPanel2 = new JPanel();
        this.contentPane.add((Component)jPanel2, "South");
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        this.statusField.setFocusable(false);
        jPanel2.add((Component)this.statusField, "South");
        this.statusField.setColumns(10);
        this.setCanReloadFile(false);
        this.setCanUndo(false);
        this.setCanRedo(false);
        this.setCanSaveFile(false);
        this.setSelectedEdit(false);
        this.setPasteEnable(false);
        this.setRemoveRestsBetweenNotesEnable(false);
        this.setXExport(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.quitEvent();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                iEditStateObserver.notifyUpdateEditState();
            }
        });
    }

    private void quitEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "quit");
        this.listener.actionPerformed(actionEvent);
    }

    private PlayStateComponent<JMenuItem> createMenuItem(JMenu jMenu, String string, String string2) {
        return this.createMenuItem(jMenu, string, string2, false, null);
    }

    private PlayStateComponent<JMenuItem> createMenuItem(JMenu jMenu, String string, String string2, boolean bl) {
        return this.createMenuItem(jMenu, string, string2, bl, null);
    }

    private PlayStateComponent<JMenuItem> createMenuItem(JMenu jMenu, String string, String string2, KeyStroke keyStroke) {
        return this.createMenuItem(jMenu, string, string2, false, keyStroke);
    }

    private PlayStateComponent<JMenuItem> createMenuItem(JMenu jMenu, String string, String string2, boolean bl, KeyStroke keyStroke) {
        ImageIcon imageIcon;
        JMenuItem jMenuItem = new JMenuItem(AppResource.appText(string));
        String string3 = AppResource.appText(string + ".icon");
        if (!string3.equals(string + ".icon") && (imageIcon = AppResource.getImageIcon(string3)) != null) {
            jMenuItem.setIcon(imageIcon);
        }
        return this.createMenuItem(jMenu, jMenuItem, string2, bl, keyStroke);
    }

    private PlayStateComponent<JMenuItem> createMenuItem(JMenu jMenu, JMenuItem jMenuItem, String string, boolean bl, KeyStroke keyStroke) {
        PlayStateComponent<JMenuItem> playStateComponent = new PlayStateComponent<JMenuItem>(jMenuItem);
        jMenuItem.addActionListener(this.listener);
        jMenuItem.setActionCommand(string);
        if (bl) {
            this.noplayFunctions.add(playStateComponent);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
            this.addShortcutMap(jMenuItem.getText(), keyStroke);
        }
        jMenu.add(jMenuItem);
        return playStateComponent;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(AppResource.appText("menu.file"));
        jMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "menu.newFile", "newFile", true, KeyStroke.getKeyStroke(78, 128));
        this.createMenuItem(jMenu, "menu.openFile", "fileOpen", true, KeyStroke.getKeyStroke(79, 128));
        this.reloadMenuItem = this.createMenuItem(jMenu, "menu.reloadFile", "reloadFile", true);
        this.saveMenuItem = this.createMenuItem(jMenu, "menu.saveFile", "save_file", KeyStroke.getKeyStroke(83, 128));
        this.createMenuItem(jMenu, "menu.saveAsFile", "saveas_file", KeyStroke.getKeyStroke(83, 192));
        jMenu.add(new JSeparator());
        this.createMenuItem(jMenu, "mml.input.import", "file_import", true);
        this.createMenuItem(jMenu, "menu.midiExport", "midi_export");
        this.createMenuItem(jMenu, "wavout", "wavout", true);
        this.createMenuItem(jMenu, "mml.export", "other_mml_export");
        this.createMenuItem(jMenu, "menu.scoreProperty", "score_property");
        jMenu.add(new JSeparator());
        for (int i = 0; i < this.fileHistory.length; ++i) {
            this.fileHistory[i] = new MenuWithIndex();
            this.createMenuItem(jMenu, this.fileHistory[i], "file_open_with_history", true, null);
        }
        this.updateFileHistoryMenu();
        jMenu.add(new JSeparator());
        this.createMenuItem(jMenu, "menu.quit", "quit");
        JMenu jMenu2 = new JMenu(AppResource.appText("menu.edit"));
        jMenuBar.add(jMenu2);
        this.undoMenu = this.createMenuItem(jMenu2, "menu.undo", "undo", KeyStroke.getKeyStroke(90, 128));
        this.redoMenu = this.createMenuItem(jMenu2, "menu.redo", "redo", KeyStroke.getKeyStroke(89, 128));
        jMenu2.add(new JSeparator());
        this.cutMenu = this.createMenuItem(jMenu2, "menu.cut", "cut", KeyStroke.getKeyStroke(88, 128));
        this.copyMenu = this.createMenuItem(jMenu2, "menu.copy", "copy", KeyStroke.getKeyStroke(67, 128));
        this.pasteMenu = this.createMenuItem(jMenu2, "menu.paste", "paste", KeyStroke.getKeyStroke(86, 128));
        this.deleteMenu = this.createMenuItem(jMenu2, "menu.delete", "delete", KeyStroke.getKeyStroke(127, 0));
        jMenu2.add(new JSeparator());
        this.createMenuItem(jMenu2, "menu.selectAll", "select_all", KeyStroke.getKeyStroke(65, 128));
        jMenu2.add(new JSeparator());
        this.createMenuItem(jMenu2, "menu.changePart", "part_change", true);
        this.createMenuItem(jMenu2, "menu.addMeasure", "add_measure", true);
        this.createMenuItem(jMenu2, "menu.removeMeasure", "remove_measure", true);
        this.createMenuItem(jMenu2, "menu.addBeat", "add_beat", true);
        this.createMenuItem(jMenu2, "menu.removeBeat", "remove_beat", true);
        this.createMenuItem(jMenu2, "edit.transpose", "transpose", true);
        this.createMenuItem(jMenu2, "edit.tracks.velocity", "tracks_edit", true);
        this.removeRestsBetweenNotesMenu = this.createMenuItem(jMenu2, "edit.remove_rests_between_notes", "remote_rests_between_notes", true, KeyStroke.getKeyStroke(127, 64));
        this.octUpMenu = this.createMenuItem(jMenu2, "edit.oct_up", "octave_up", true, KeyStroke.getKeyStroke(38, 64));
        this.octDownMenu = this.createMenuItem(jMenu2, "edit.oct_down", "octave_down", true, KeyStroke.getKeyStroke(40, 64));
        this.velocityUpMenu = this.createMenuItem(jMenu2, "edit.velocity_up", "velocity_up", true, KeyStroke.getKeyStroke(38, 512));
        this.velocityDownMenu = this.createMenuItem(jMenu2, "edit.velocity_down", "velocity_down", true, KeyStroke.getKeyStroke(40, 512));
        if (((SoundEnv)MabiIccoProperties.getInstance().soundEnv.get()).useDLS()) {
            this.createMenuItem(jMenu2, "edit.drum_convert", "midi_mabi_drum_convert", true);
        }
        jMenu2.add(new JSeparator());
        this.createMenuItem(jMenu2, "view.setUserViewMeasure", "set_user_view_measure", true, KeyStroke.getKeyStroke(76, 128));
        this.createMenuItem(jMenu2, "edit.allClearTempo", "all_clear_tempo", true);
        this.createMenuItem(jMenu2, "mml.generate", "mml_generate", true);
        this.createMenuItem(jMenu2, "edit.keyboard.input", "keyboard_input", true, KeyStroke.getKeyStroke(75, 128));
        this.createMenuItem(jMenu2, "mml.text_edit", "mml_text_edit", true, KeyStroke.getKeyStroke(74, 128));
        JMenu jMenu3 = new JMenu(AppResource.appText("menu.track"));
        jMenuBar.add(jMenu3);
        this.createMenuItem(jMenu3, "menu.addTrack", "addTrack", true, KeyStroke.getKeyStroke(84, 128));
        this.createMenuItem(jMenu3, "menu.removeTrack", "removeTrack", true, KeyStroke.getKeyStroke(84, 192));
        this.createMenuItem(jMenu3, "menu.duplicateTrack", "duplicateTrack", true, KeyStroke.getKeyStroke(68, 128));
        jMenu3.add(new JSeparator());
        this.createMenuItem(jMenu3, "menu.trackProperty", "trackProperty", true, KeyStroke.getKeyStroke(10, 512));
        this.createMenuItem(jMenu3, "edit.tracks.view", "tracks_view", false);
        jMenu3.add(new JSeparator());
        this.createMenuItem(jMenu3, "menu.mml_import", "mml_import", true, KeyStroke.getKeyStroke(86, 192));
        this.createMenuItem(jMenu3, "menu.mml_export", "mml_export", KeyStroke.getKeyStroke(67, 192));
        jMenu3.add(new JSeparator());
        this.createMenuItem(jMenu3, "menu.mml_x_import", "mml_x_import", true);
        this.xExportMenu = this.createMenuItem(jMenu3, "menu.mml_x_export", "mml_x_export", true);
        JMenu jMenu4 = new JMenu(AppResource.appText("menu.operate"));
        jMenuBar.add(jMenu4);
        this.createMenuItem(jMenu4, "menu.head", "setStartPosition", KeyStroke.getKeyStroke(114, 0));
        this.createMenuItem(jMenu4, "menu.play", "play", KeyStroke.getKeyStroke(116, 0));
        this.createMenuItem(jMenu4, "menu.stop", "stop", KeyStroke.getKeyStroke(27, 0));
        this.createMenuItem(jMenu4, "menu.pause", "pause");
        jMenu4.add(new JSeparator());
        this.createMenuItem(jMenu4, "menu.prev", "prev_time", KeyStroke.getKeyStroke(115, 0));
        this.createMenuItem(jMenu4, "menu.next", "next_time", KeyStroke.getKeyStroke(117, 0));
        JMenu jMenu5 = new JMenu(AppResource.appText("menu.setting"));
        jMenuBar.add(jMenu5);
        UIUtils.createGroupMenu(jMenu5, "menu.noteHeight", this.appProperties.pianoRollNoteHeight);
        UIUtils.createGroupMenu(jMenu5, "menu.scale_color", this.appProperties.scaleColor);
        this.createCheckMenu(jMenu5, "view.tempo", this.appProperties.enableViewTempo);
        this.createCheckMenu(jMenu5, "view.marker", this.appProperties.enableViewMarker);
        this.createCheckMenu(jMenu5, "view.range", this.appProperties.viewRange);
        this.createCheckMenu(jMenu5, "view.instAttr", this.appProperties.instAttr);
        this.createCheckMenu(jMenu5, "view.showAllVelocity", this.appProperties.showAllVelocity);
        this.createCheckMenu(jMenu5, "view.velocity", this.appProperties.viewVelocityLine);
        UIUtils.createGroupMenu(jMenu5, "ui.laf", this.appProperties.laf);
        this.createCheckMenu(jMenu5, "ui.scale_disable", this.appProperties.uiscaleDisable);
        jMenu5.add(new JSeparator());
        this.createCheckMenu(jMenu5, "edit.enable", this.appProperties.enableEdit);
        this.createCheckMenu(jMenu5, "edit.active_part_switch", this.appProperties.activePartSwitch);
        this.createCheckMenu(jMenu5, "clickPlayMenu", this.appProperties.enableClickPlay);
        this.createCheckMenu(jMenu5, "edit.tempoDeleteWithConvert", this.appProperties.enableTempoDeleteWithConvert);
        UIUtils.createGroupMenu(jMenu5, "ui.mouse_scroll_width", this.appProperties.mouseScrollWidth);
        this.createCheckMenu(jMenu5, "velocity_editor", this.appProperties.velocityEditor);
        jMenu5.add(new JSeparator());
        UIUtils.createGroupMenu(jMenu5, "mml.optimize_level", this.appProperties.mmlOptimizeLevel);
        this.createCheckMenu(jMenu5, "mml.percussion_motion_fix", this.appProperties.percussionMotionFix, "mml_generate");
        this.createCheckMenu(jMenu5, "mml.vzero_tempo", this.appProperties.mmlVZeroTempo, "mml_generate");
        this.createCheckMenu(jMenu5, "mml.fix64_tempo", this.appProperties.mmlFix64Tempo, "mml_generate");
        this.createMenuItem(jMenu5, "mml.emptyCorrection", "input_empty_correction", true);
        this.createCheckMenu(jMenu5, "mml.regenerate_with_open", this.appProperties.reGenerateWithOpen);
        jMenu5.add(new JSeparator());
        UIUtils.createGroupMenu(jMenu5, "menu.sound_env", this.appProperties.soundEnv);
        this.createCheckMenu(jMenu5, "menu.useDefaultSoundbank", this.appProperties.useDefaultSoundBank, "use_default_soundbank", true);
        this.createMenuItem(jMenu5, "menu.select_dls", "select_dls", true);
        JMenu jMenu6 = new JMenu(AppResource.appText("menu.help"));
        jMenuBar.add(jMenu6);
        this.createMenuItem(jMenu6, "menu.about", "about");
        this.createMenuItem(jMenu6, "menu.shortcutInfo", "shortcut_info");
        this.createMenuItem(jMenu6, "menu.mmlErrList", "mml_err_list");
        if (!((Boolean)this.appProperties.useDefaultSoundBank.get()).booleanValue()) {
            this.createMenuItem(jMenu6, "menu.instList", "inst_list");
        }
        this.createMenuItem(jMenu6, "menu.polyphonyMonitor", "polyphony_monitor");
        this.createMenuItem(jMenu6, "menu.licenses", "show_licenses");
        return jMenuBar;
    }

    private void createCheckMenu(JMenu jMenu, String string, MabiIccoProperties.Property<Boolean> property) {
        this.createCheckMenu(jMenu, string, property, null, false);
    }

    private void createCheckMenu(JMenu jMenu, String string, MabiIccoProperties.Property<Boolean> property, String string2) {
        this.createCheckMenu(jMenu, string, property, string2, false);
    }

    private void createCheckMenu(JMenu jMenu, String string, MabiIccoProperties.Property<Boolean> property, String string2, boolean bl) {
        this.createCheckMenu(jMenu, string, property, string2, bl, null);
    }

    private void createCheckMenu(JMenu jMenu, String string, MabiIccoProperties.Property<Boolean> property, String string2, boolean bl, KeyStroke keyStroke) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(AppResource.appText(string));
        String string3 = string + ".detail";
        String string4 = AppResource.appText(string3);
        if (string4 != string3) {
            jCheckBoxMenuItem.setToolTipText(string4);
        }
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setSelected((Boolean)property.get());
        jCheckBoxMenuItem.setActionCommand(string2);
        jCheckBoxMenuItem.addActionListener(actionEvent -> {
            boolean bl = (Boolean)property.get();
            property.set(!bl);
            jCheckBoxMenuItem.setSelected(!bl);
            if (this.mmlSeqView != null) {
                this.mmlSeqView.repaint();
            }
            if (string2 != null) {
                this.listener.actionPerformed(actionEvent);
            }
        });
        if (bl) {
            this.noplayFunctions.add(new PlayStateComponent<JCheckBoxMenuItem>(jCheckBoxMenuItem));
        }
        if (keyStroke != null) {
            jCheckBoxMenuItem.setAccelerator(keyStroke);
            this.addShortcutMap(jCheckBoxMenuItem.getText(), keyStroke);
        }
    }

    private PlayStateComponent<JButton> createToolButton(JComponent jComponent, String string, String string2, boolean bl) {
        JButton jButton = new JButton("");
        PlayStateComponent<JButton> playStateComponent = new PlayStateComponent<JButton>(jButton);
        ImageIcon imageIcon = null;
        String string3 = AppResource.appText(string + ".icon");
        if (!string3.equals(string + ".icon")) {
            imageIcon = AppResource.getImageIcon(AppResource.appText(string3));
        }
        if (imageIcon == null) {
            jButton.setText(AppResource.appText(string));
        } else {
            jButton.setToolTipText(AppResource.appText(string));
            jButton.setIcon(imageIcon);
        }
        jButton.setFocusable(false);
        jButton.addActionListener(this.listener);
        jButton.setActionCommand(string2);
        if (bl) {
            this.noplayFunctions.add(playStateComponent);
        }
        jComponent.add(jButton);
        return playStateComponent;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = UIUtils.createToolBar();
        this.createToolButton(jToolBar, "menu.newFile", "newFile", true);
        this.createToolButton(jToolBar, "menu.openFile", "fileOpen", true);
        jToolBar.add(this.newToolBarSeparator());
        this.createToolButton(jToolBar, "menu.head", "setStartPosition", false);
        this.createToolButton(jToolBar, "menu.prev", "prev_time", false);
        this.createToolButton(jToolBar, "menu.play", "play", false);
        this.createToolButton(jToolBar, "menu.next", "next_time", false);
        this.createToolButton(jToolBar, "menu.pause", "pause", false);
        this.createToolButton(jToolBar, "menu.stop", "stop", false);
        this.loopButton = this.createToolButton(jToolBar, "menu.loop", "toggle_loop", false).get();
        jToolBar.add(this.newToolBarSeparator());
        this.createToolButton(jToolBar, "menu.addMeasure", "add_measure", true);
        this.createToolButton(jToolBar, "menu.removeMeasure", "remove_measure", true);
        this.createToolButton(jToolBar, "menu.addBeat", "add_beat", true);
        this.createToolButton(jToolBar, "menu.removeBeat", "remove_beat", true);
        jToolBar.add(this.newToolBarSeparator());
        this.createToolButton(jToolBar, "menu.inputMML", "inputFromClipboard", true);
        this.createToolButton(jToolBar, "menu.outputMML", "outputToClipboard", false);
        jToolBar.add(this.newToolBarSeparator());
        this.editToolButton = UIUtils.createGroupJToggleButton(jToolBar, EditTool.values(), EditTool.NORMAL);
        jToolBar.add(this.newToolBarSeparator());
        this.createToolButton(jToolBar, "view.scale.up", "view_scale_up", false);
        this.createToolButton(jToolBar, "view.scale.down", "view_scale_down", false);
        this.noteTypeSelect.setFocusable(false);
        this.noteTypeSelect.addActionListener(this);
        this.noteTypeSelect.setSelectedItem((Object)NoteAlign.DEFAULT_ALIGN);
        this.setEditAlign();
        jToolBar.add(this.noteTypeSelect);
        this.paintModeSelect.setFocusable(false);
        this.paintModeSelect.addActionListener(this);
        this.paintModeSelect.setSelectedItem((Object)this.mmlSeqView.getPaintMode());
        jToolBar.add(this.paintModeSelect);
        jToolBar.add(this.newToolBarSeparator());
        this.timeBox.setFont(AppResource.MONO_FONT);
        this.timeBox.setFocusable(false);
        this.timeBox.setType((TimeBox.Type)((Object)this.appProperties.timebox.get()));
        this.timeBox.addActionListener(actionEvent -> this.appProperties.timebox.set((Object)this.timeBox.getType()));
        this.timeBox.setPreferredSize(new Dimension(240, 20));
        jToolBar.add(this.timeBox);
        jToolBar.add(this.newToolBarSeparator());
        LevelMonitor levelMonitor = new LevelMonitor();
        jToolBar.add(levelMonitor);
        JTextField jTextField = PolyphonyMonitor.getInstance().getTextField();
        jToolBar.add(jTextField);
        return jToolBar;
    }

    private JSeparator newToolBarSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setForeground(Color.DARK_GRAY);
        return separator;
    }

    public void setTitleAndFileName(String string) {
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        this.setTitle(AppResource.getAppTitle() + " [" + string2 + "]");
    }

    private void loadWindowPeoperties() {
        Rectangle rectangle = this.appProperties.getWindowRect();
        if (rectangle == null) {
            this.setSize(1024, 768);
            this.setLocationRelativeTo(null);
        } else {
            this.setBounds(rectangle);
        }
        if (((Boolean)this.appProperties.windowMaximize.get()).booleanValue()) {
            this.setExtendedState(6);
        }
    }

    private void updateWindowProperties() {
        int n = this.getExtendedState();
        if ((n & 6) == 6) {
            this.appProperties.windowMaximize.set(true);
        } else {
            this.appProperties.windowMaximize.set(false);
            this.appProperties.setWindowRect(this.getBounds());
        }
    }

    public MMLSeqView getMMLSeqView() {
        return this.mmlSeqView;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.updateWindowProperties();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateWindowProperties();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void disableNoplayItems() {
        for (PlayStateComponent<?> playStateComponent : this.noplayFunctions) {
            playStateComponent.setNoplay(false);
        }
    }

    public void enableNoplayItems() {
        for (PlayStateComponent<?> playStateComponent : this.noplayFunctions) {
            playStateComponent.setNoplay(true);
        }
        EventQueue.invokeLater(() -> {
            this.mmlSeqView.resetViewPosition();
            this.mmlSeqView.repaint();
        });
    }

    private void setEditAlign() {
        NoteAlign noteAlign = (NoteAlign)((Object)this.noteTypeSelect.getSelectedItem());
        int n = noteAlign.getAlign();
        this.mmlSeqView.setEditAlign(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.noteTypeSelect)) {
            this.setEditAlign();
        } else if (object.equals(this.paintModeSelect)) {
            PianoRollView.PaintMode paintMode = (PianoRollView.PaintMode)((Object)this.paintModeSelect.getSelectedItem());
            this.mmlSeqView.setPaintMode(paintMode);
            this.mmlSeqView.repaint();
        }
    }

    public void setCanReloadFile(boolean bl) {
        this.reloadMenuItem.setEnabled(bl);
    }

    public void setCanUndo(boolean bl) {
        this.undoMenu.setEnabled(bl);
    }

    public void setCanRedo(boolean bl) {
        this.redoMenu.setEnabled(bl);
    }

    public void setCanSaveFile(boolean bl) {
        this.saveMenuItem.setEnabled(bl);
    }

    public void setSelectedEdit(boolean bl) {
        this.cutMenu.setEnabled(bl);
        this.copyMenu.setEnabled(bl);
        this.deleteMenu.setEnabled(bl);
        this.octUpMenu.setEnabled(bl);
        this.octDownMenu.setEnabled(bl);
        this.velocityUpMenu.setEnabled(bl);
        this.velocityDownMenu.setEnabled(bl);
    }

    public void setPasteEnable(boolean bl) {
        this.pasteMenu.setEnabled(bl);
    }

    public void setRemoveRestsBetweenNotesEnable(boolean bl) {
        this.removeRestsBetweenNotesMenu.setEnabled(bl);
    }

    public void setXExport(boolean bl) {
        this.xExportMenu.setEnabled(bl);
    }

    public void updateLoop(boolean bl) {
        this.loopButton.setSelected(bl);
    }

    public void updateFileHistoryMenu() {
        File[] fileArray = this.appProperties.getFileHistory();
        for (int i = 0; i < this.fileHistory.length; ++i) {
            if (i < fileArray.length && fileArray[i] != null) {
                this.fileHistory[i].setText(i + 1 + " " + fileArray[i].getName());
                this.fileHistory[i].setToolTipText(fileArray[i].getAbsolutePath());
                this.fileHistory[i].set(i);
                this.fileHistory[i].setVisible(true);
                continue;
            }
            this.fileHistory[i].setVisible(false);
        }
    }

    public void setStatusText(String string) {
        this.statusField.setText(string);
    }

    private void changeNoteTypeSelect(int n) {
        if (n >= 0 && n < this.noteTypeSelect.getItemCount()) {
            this.noteTypeSelect.setSelectedIndex(n);
        }
    }

    private void changeEditTool(int n) {
        if (n >= 0 && n < this.editToolButton.size()) {
            JToggleButton jToggleButton = this.editToolButton.get(n);
            jToggleButton.setSelected(true);
            this.listener.actionPerformed(new ActionEvent(jToggleButton, 0, "change_action"));
        }
    }

    private void addShortcutMap(String string, KeyStroke keyStroke) {
        this.shortcutMap.values().forEach(list -> list.forEach(keyStroke2 -> {
            if (keyStroke2.equals(keyStroke)) {
                throw new AssertionError((Object)("addShortcutMap ERROR: " + string + " / " + keyStroke2));
            }
        }));
        if (this.shortcutMap.containsKey(string)) {
            this.shortcutMap.get(string).add(keyStroke);
        } else {
            ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
            arrayList.add(keyStroke);
            this.shortcutMap.put(string, arrayList);
        }
    }

    public Map<String, List<KeyStroke>> getShortcutMap() {
        return this.shortcutMap;
    }

    private void initKeyAction() {
        this.createKeyAction("select_paintMode.activePart", KeyStroke.getKeyStroke(121, 0), () -> this.paintModeSelect.setSelectedItem((Object)PianoRollView.PaintMode.ACTIVE_PART), AppResource.appText("shortcut.select_paintMode.activePart"));
        this.createKeyAction("select_paintMode.activeTrack", KeyStroke.getKeyStroke(122, 0), () -> this.paintModeSelect.setSelectedItem((Object)PianoRollView.PaintMode.ACTIVE_TRACK), AppResource.appText("shortcut.select_paintMode.activeTrack"));
        this.createKeyAction("select_paintMode.allTrack", KeyStroke.getKeyStroke(123, 0), () -> this.paintModeSelect.setSelectedItem((Object)PianoRollView.PaintMode.ALL_TRACK), AppResource.appText("shortcut.select_paintMode.allTrack"));
        this.createKeyAction("switch_track_next", KeyStroke.getKeyStroke(39, 0), () -> this.listener.actionPerformed(new ActionEvent(this, 0, "switch_track_next")), AppResource.appText("shortcut.track_next"));
        this.createKeyAction("switch_track_prev", KeyStroke.getKeyStroke(37, 0), () -> this.listener.actionPerformed(new ActionEvent(this, 0, "switch_track_prev")), AppResource.appText("shortcut.track_prev"));
        this.createKeyAction("switch_mmlpart_next", KeyStroke.getKeyStroke(40, 0), () -> this.listener.actionPerformed(new ActionEvent(this, 0, "switch_mmlpart_next")), AppResource.appText("shortcut.part_next"));
        this.createKeyAction("switch_mmlpart_prev", KeyStroke.getKeyStroke(38, 0), () -> this.listener.actionPerformed(new ActionEvent(this, 0, "switch_mmlpart_prev")), AppResource.appText("shortcut.part_prev"));
        this.createKeyAction("play", KeyStroke.getKeyStroke(32, 0), () -> this.listener.actionPerformed(new ActionEvent(this, 0, "play")), AppResource.appText("shortcut.play"));
        for (NoteAlign enum_ : NoteAlign.values()) {
            if (enum_.getKeyCodeList() == null) continue;
            AtomicInteger atomicInteger = new AtomicInteger();
            enum_.getKeyCodeList().forEach(n -> this.createKeyAction(enum_.name() + "." + atomicInteger.incrementAndGet(), KeyStroke.getKeyStroke(n, 0), () -> this.changeNoteTypeSelect(Arrays.asList(NoteAlign.values()).indexOf((Object)enum_)), enum_.toString()));
        }
        for (Enum enum_ : EditTool.values()) {
            int n2 = ((EditTool)enum_).getKeyCode();
            this.createKeyAction("edit_tool." + enum_.toString(), KeyStroke.getKeyStroke(n2, 0), () -> this.lambda$initKeyAction$15((EditTool)enum_), AppResource.appText("edit_tool") + ": " + ((EditTool)enum_).getButtonName());
        }
    }

    private void createKeyAction(String string, KeyStroke keyStroke, Runnable runnable, String string2) {
        new KeyAction(string, keyStroke, this.contentPane, runnable);
        this.addShortcutMap(string2, keyStroke);
    }

    private /* synthetic */ void lambda$initKeyAction$15(EditTool editTool) {
        this.changeEditTool(List.of(EditTool.values()).indexOf(editTool));
    }

    static final class PlayStateComponent<T extends JComponent> {
        private boolean noplay = true;
        private boolean enable = true;
        private final T component;

        PlayStateComponent(T t) {
            this.component = t;
        }

        void setNoplay(boolean bl) {
            this.noplay = bl;
            ((JComponent)this.component).setEnabled(this.enable && this.noplay);
        }

        void setEnabled(boolean bl) {
            this.enable = bl;
            ((JComponent)this.component).setEnabled(this.enable && this.noplay);
        }

        T get() {
            return this.component;
        }
    }

    private static class MenuWithIndex
    extends JMenuItem
    implements IntSupplier {
        private static final long serialVersionUID = -7944526274796801310L;
        private int index;

        private MenuWithIndex() {
        }

        public void set(int n) {
            this.index = n;
        }

        @Override
        public int getAsInt() {
            return this.index;
        }
    }

    private static final class KeyAction
    extends AbstractAction {
        private static final long serialVersionUID = -5439131294063926971L;
        private Runnable function;

        private KeyAction() {
        }

        private KeyAction(String string, KeyStroke keyStroke, JComponent jComponent, Runnable runnable) {
            this.function = runnable;
            jComponent.getInputMap().put(keyStroke, string);
            jComponent.getInputMap(2).put(keyStroke, string);
            jComponent.getActionMap().put(string, this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.function.run();
        }
    }
}

