/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.util.Arrays;
import java.util.List;
import javax.sound.midi.Sequencer;
import javax.swing.JComboBox;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoConverter;
import jp.fourthline.mmlTools.MMLTempoEvent;

public final class TimeBox
extends JComboBox<StringBuffer>
implements Runnable {
    private static final long serialVersionUID = 6907274508888816165L;
    private static final int UPDATE_TIME = 200;
    private static final int RUNNING_UPDATE_TIME = 25;
    private final IMMLManager mmlManager;
    private final Sequencer sequencer;
    private final StringBuffer time1 = new StringBuffer("time MM:SS/MM:SS (t120)     ");
    private final StringBuffer time2 = new StringBuffer();
    private final List<Type> types = Arrays.asList(Type.values());

    public TimeBox(IMMLManager iMMLManager) {
        this.mmlManager = iMMLManager;
        this.addItem(this.time1);
        this.addItem(this.time2);
        this.sequencer = MabiDLS.getInstance().getSequencer();
        new Thread((Runnable)this, "TimeBox Thread").start();
    }

    private void update(long l) {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        List<MMLTempoEvent> list = mMLScore.getTempoEventList();
        long l2 = Math.round(MMLTempoConverter.getTimeOnTickOffset(list, (int)l));
        int n = mMLScore.getTotalTickLength();
        long l3 = Math.round(MMLTempoConverter.getTimeOnTickOffset(list, n));
        int n2 = MMLTempoEvent.searchOnTick(list, (int)l);
        String string = String.format("time %d:%02d.%d/%d:%02d.%d (t%d)", l2 / 60L / 1000L, l2 / 1000L % 60L, l2 / 100L % 10L, l3 / 60L / 1000L, l3 / 1000L % 60L, l3 / 100L % 10L, n2);
        String string2 = mMLScore.getBarTextTick((int)l) + "/" + mMLScore.getBarTextTick(n) + " (t" + n2 + ")";
        boolean bl = false;
        if (!this.time1.toString().equals(string)) {
            this.time1.replace(0, this.time1.length(), string);
            bl = true;
        }
        if (!this.time2.toString().equals(string2)) {
            this.time2.replace(0, this.time2.length(), string2);
            bl = true;
        }
        if (bl) {
            this.repaint();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.update(this.mmlManager.getSequencePosition());
                    Thread.sleep(this.sequencer.isRunning() ? 25L : 200L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setType(Type type) {
        int n = this.types.indexOf((Object)type);
        this.setSelectedIndex(n);
    }

    public Type getType() {
        return this.types.get(this.getSelectedIndex());
    }

    public static enum Type {
        MEASURE,
        TIME;

    }
}

