/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.io.IOException;
import java.util.OptionalInt;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;

public final class TrackTabbedPane
extends JTabbedPane
implements DragGestureListener {
    private static final long serialVersionUID = -5972755124410009800L;
    private OptionalInt targetIndex = OptionalInt.empty();

    public TrackTabbedPane(IMMLManager iMMLManager) {
        super(1, 1);
        new DragSource().createDefaultDragGestureRecognizer(this, 2, this);
        this.setTransferHandler(new TrackTabTransferHandler(this, iMMLManager));
        this.setFocusable(false);
    }

    public boolean updateTargetIndex(OptionalInt optionalInt) {
        this.targetIndex = optionalInt;
        this.repaint();
        return optionalInt.isPresent();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.targetIndex.isPresent()) {
            Rectangle rectangle = this.getBoundsAt(this.targetIndex.getAsInt());
            int n = rectangle.x;
            int n2 = rectangle.height;
            int[] nArray = new int[]{n - 4, n + 4, n, n, n};
            int[] nArray2 = new int[]{0, 0, 4, n2, 4};
            graphics.setColor(Color.CYAN);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.BLUE);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Component component = dragGestureEvent.getComponent();
        if (!(component instanceof TrackTabbedPane)) {
            return;
        }
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            return;
        }
        TrackTabbedPane trackTabbedPane = (TrackTabbedPane)component;
        if (trackTabbedPane.getTabCount() > 1) {
            dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new TrackTabTransfer(trackTabbedPane));
        }
    }

    private static final class TrackTabTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -145263268894584091L;
        private final DataFlavor dataFlavor;
        private final TrackTabbedPane pane;
        private final IMMLManager mmlManager;

        public TrackTabTransferHandler(TrackTabbedPane trackTabbedPane, IMMLManager iMMLManager) {
            this.pane = trackTabbedPane;
            this.mmlManager = iMMLManager;
            this.dataFlavor = new DataFlavor(TrackTabbedPane.class, "obj/TabbedPane");
        }

        private OptionalInt getTargetIndex(Point point) {
            for (int i = 0; i < this.pane.getTabCount(); ++i) {
                if (!this.pane.getBoundsAt(i).contains(point)) continue;
                if (this.pane.getSelectedIndex() == i) break;
                return OptionalInt.of(i);
            }
            return OptionalInt.empty();
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            int n = transferSupport.getDropAction();
            if (n == 2 && transferSupport.isDataFlavorSupported(this.dataFlavor)) {
                Point point = transferSupport.getDropLocation().getDropPoint();
                return this.pane.updateTargetIndex(this.getTargetIndex(point));
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Point point = transferSupport.getDropLocation().getDropPoint();
            int n = this.getTargetIndex(point).getAsInt();
            this.mmlManager.moveTrack(n);
            this.pane.updateTargetIndex(OptionalInt.empty());
            return true;
        }
    }

    private static final class TrackTabTransfer
    implements Transferable {
        private final TrackTabbedPane content;
        private final DataFlavor[] f = new DataFlavor[]{new DataFlavor(TrackTabbedPane.class, "obj/TabbedPane")};

        private TrackTabTransfer(TrackTabbedPane trackTabbedPane) {
            this.content = trackTabbedPane;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.f;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.content;
        }
    }
}

