/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.ui.SettingButtonGroupIconItem;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;

public final class UIUtils {
    private UIUtils() {
    }

    public static void setDefaultFocus(JSpinner jSpinner) {
        UIUtils.setDefaultFocus(((JSpinner.NumberEditor)jSpinner.getEditor()).getTextField());
    }

    public static void setDefaultFocus(final JTextField jTextField) {
        jTextField.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                jTextField.requestFocusInWindow();
                jTextField.selectAll();
            }
        });
    }

    public static void scrollChain(JScrollPane jScrollPane, JScrollPane jScrollPane2) {
        jScrollPane.getViewport().addChangeListener(new ScrollChainListener(jScrollPane2.getViewport()));
        jScrollPane2.getViewport().addChangeListener(new ScrollChainListener(jScrollPane.getViewport()));
    }

    public static void drawRect(Graphics2D graphics2D, Color color, Color color2, int n, int n2, int n3, int n4) {
        graphics2D.setColor(color2);
        if (n3 != 0) {
            graphics2D.fillRect(n + 1, n2 + 1, n3, n4 - 1);
        } else {
            graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
        }
        graphics2D.setColor(color);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 + 1, n2 + n4 - 1, n + n3 + 1, n2 + 1);
        graphics2D.drawLine(n + 2, n2, n + n3, n2);
        graphics2D.drawLine(n + n3, n2 + n4, n + 2, n2 + n4);
    }

    public static void createGroupMenu(JComponent jComponent, String string, MabiIccoProperties.EnumProperty<? extends SettingButtonGroupItem> enumProperty) {
        ActionDispatcher actionDispatcher = ActionDispatcher.getInstance();
        JMenu jMenu = new JMenu(AppResource.appText(string));
        jComponent.add(jMenu);
        ButtonGroup buttonGroup = new ButtonGroup();
        Object object = enumProperty.getDefault();
        for (Enum enum_ : enumProperty.getValues()) {
            Object object2 = AppResource.appText(enum_.getButtonName());
            if (enum_ == object) {
                object2 = (String)object2 + " (default)";
            }
            GroupRadioMenuItemWith<Enum> groupRadioMenuItemWith = new GroupRadioMenuItemWith<Enum>((String)object2, enum_);
            groupRadioMenuItemWith.setActionCommand("change_action");
            groupRadioMenuItemWith.addActionListener(actionDispatcher);
            groupRadioMenuItemWith.setSelected(enum_.equals(enumProperty.get()));
            jMenu.add(groupRadioMenuItemWith);
            buttonGroup.add(groupRadioMenuItemWith);
        }
    }

    public static void createGroupMenu(JComponent jComponent, SettingButtonGroupItem[] settingButtonGroupItemArray, ActionListener actionListener, SettingButtonGroupItem settingButtonGroupItem) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (SettingButtonGroupItem settingButtonGroupItem2 : settingButtonGroupItemArray) {
            String string = AppResource.appText(settingButtonGroupItem2.getButtonName());
            GroupRadioMenuItemWith<SettingButtonGroupItem> groupRadioMenuItemWith = new GroupRadioMenuItemWith<SettingButtonGroupItem>(string, settingButtonGroupItem2);
            groupRadioMenuItemWith.addActionListener(actionListener);
            groupRadioMenuItemWith.setSelected(settingButtonGroupItem2.equals(settingButtonGroupItem));
            jComponent.add(groupRadioMenuItemWith);
            buttonGroup.add(groupRadioMenuItemWith);
        }
    }

    public static List<JMenuItem> createGroupActionMenu(JComponent jComponent, SettingButtonGroupItem[] settingButtonGroupItemArray, Function<String, String> function, String string) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        ActionDispatcher actionDispatcher = ActionDispatcher.getInstance();
        for (SettingButtonGroupItem settingButtonGroupItem : settingButtonGroupItemArray) {
            String string2 = function.apply(AppResource.appText(settingButtonGroupItem.getButtonName()));
            GroupMenuItemWith<SettingButtonGroupItem> groupMenuItemWith = new GroupMenuItemWith<SettingButtonGroupItem>(string2, settingButtonGroupItem);
            groupMenuItemWith.setActionCommand(string);
            groupMenuItemWith.addActionListener(actionDispatcher);
            jComponent.add(groupMenuItemWith);
            arrayList.add(groupMenuItemWith);
        }
        return arrayList;
    }

    public static List<JToggleButton> createGroupJToggleButton(JComponent jComponent, SettingButtonGroupIconItem[] settingButtonGroupIconItemArray, SettingButtonGroupIconItem settingButtonGroupIconItem) {
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>();
        ActionDispatcher actionDispatcher = ActionDispatcher.getInstance();
        String string = "change_action";
        ButtonGroup buttonGroup = new ButtonGroup();
        for (SettingButtonGroupIconItem settingButtonGroupIconItem2 : settingButtonGroupIconItemArray) {
            String string2 = settingButtonGroupIconItem2.getButtonName();
            ImageIcon imageIcon = settingButtonGroupIconItem2.getIcon();
            ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
            GroupToggleButtonWith<SettingButtonGroupIconItem> groupToggleButtonWith = new GroupToggleButtonWith<SettingButtonGroupIconItem>(string2, (Icon)imageIcon2, settingButtonGroupIconItem2);
            groupToggleButtonWith.setActionCommand(string);
            groupToggleButtonWith.addActionListener(actionDispatcher);
            groupToggleButtonWith.setSelected(settingButtonGroupIconItem2 == settingButtonGroupIconItem);
            groupToggleButtonWith.setToolTipText(string2);
            jComponent.add(groupToggleButtonWith);
            arrayList.add(groupToggleButtonWith);
            buttonGroup.add(groupToggleButtonWith);
        }
        return arrayList;
    }

    public static JToolBar createToolBar() {
        return new MToolBar();
    }

    public static JToolBar createToolBar(int n) {
        return new MToolBar(n);
    }

    public static void dialogCloseAction(JDialog jDialog) {
        UIUtils.dialogCloseAction(jDialog, () -> {});
    }

    public static void dialogCloseAction(final JDialog jDialog, final Runnable runnable) {
        InputMap inputMap = jDialog.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close-it");
        jDialog.getRootPane().getActionMap().put("close-it", new AbstractAction(){
            private static final long serialVersionUID = 9185214975506783931L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
                jDialog.setVisible(false);
            }
        });
    }

    public static JPanel createTitledPanel(String string) {
        return UIUtils.createTitledPanel(string, null, 0);
    }

    public static JPanel createTitledPanel(String string, LayoutManager layoutManager) {
        return UIUtils.createTitledPanel(string, layoutManager, 0);
    }

    public static JPanel createTitledPanel(String string, int n) {
        return UIUtils.createTitledPanel(string, null, n);
    }

    public static JPanel createTitledPanel(String string, LayoutManager layoutManager, int n) {
        JPanel jPanel = new JPanel(layoutManager);
        AbstractBorder abstractBorder = new TitledBorder(new LineBorder(Color.GRAY, 1, true), AppResource.appText(string), 4, 2, null, null);
        if (n > 0) {
            Insets insets = new Insets(n, n, n, n);
            abstractBorder = new CompoundBorder(new EmptyBorder(insets), new CompoundBorder(abstractBorder, new EmptyBorder(insets)));
        }
        jPanel.setBorder(abstractBorder);
        return jPanel;
    }

    public static void viewportSetPositionWorkaround(JViewport jViewport, Point point) {
        jViewport.setViewPosition(point);
        int n = 0;
        while (jViewport.getViewPosition().x != point.x || jViewport.getViewPosition().y != point.y) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            jViewport.setViewPosition(point);
            if (++n <= 100) continue;
            break;
        }
    }

    public static JTable createTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        JTable jTable = new JTable(new DefaultTableModel((Vector)vector, (Vector)vector2){
            private static final long serialVersionUID = 746461323527083725L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setRequestFocusEnabled(false);
        jTable.setFocusable(false);
        jTable.setRowSelectionAllowed(false);
        jTable.setSelectionMode(0);
        return jTable;
    }

    public static void setRenderingHint(Graphics2D graphics2D) {
        Object object3 = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (object3 instanceof Map) {
            Map map = (Map)object3;
            map.forEach((object, object2) -> {
                if (object instanceof RenderingHints.Key) {
                    RenderingHints.Key key = (RenderingHints.Key)object;
                    graphics2D.setRenderingHint(key, object2);
                }
            });
        }
    }

    public static JCheckBox createCheckBox(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(AppResource.appText(string));
        if (bl) {
            jCheckBox.setToolTipText(AppResource.appText(string + ".detail"));
        }
        return jCheckBox;
    }

    private static final class ScrollChainListener
    implements ChangeListener {
        private final JViewport target;

        private ScrollChainListener(JViewport jViewport) {
            this.target = jViewport;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof JViewport) {
                JViewport jViewport = (JViewport)object;
                object = jViewport.getViewPosition();
                Point point = this.target.getViewPosition();
                point.x = ((Point)object).x;
                this.target.setViewPosition(point);
            }
        }
    }

    private static class GroupRadioMenuItemWith<T>
    extends JRadioButtonMenuItem
    implements Supplier<T> {
        private static final long serialVersionUID = -7786833458520626015L;
        private final T obj;

        private GroupRadioMenuItemWith(String string, T t) {
            super(string);
            this.obj = t;
        }

        @Override
        public T get() {
            return this.obj;
        }
    }

    private static class GroupMenuItemWith<T>
    extends JMenuItem
    implements Supplier<T> {
        private static final long serialVersionUID = -3983687243046433624L;
        private final T obj;

        private GroupMenuItemWith(String string, T t) {
            super(string);
            this.obj = t;
        }

        @Override
        public T get() {
            return this.obj;
        }
    }

    private static class GroupToggleButtonWith<T>
    extends JToggleButton
    implements Supplier<T> {
        private static final long serialVersionUID = 6235718102529165950L;
        private final T obj;

        private GroupToggleButtonWith(String string, Icon icon, T t) {
            super(icon);
            this.obj = t;
        }

        @Override
        public T get() {
            return this.obj;
        }
    }

    private static final class MToolBar
    extends JToolBar {
        private static final long serialVersionUID = 3018958172538601500L;

        public MToolBar() {
            this.setFloatable(false);
        }

        public MToolBar(int n) {
            super(n);
            this.setFloatable(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setFloatable(false);
        }
    }
}

