/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.fourthline.mabiicco.ui.color.ColorManager;

final class ColorPalette {
    private static final Color[] trackBaseColor = new Color[]{new Color(200, 0, 0), new Color(0, 200, 0), new Color(0, 0, 200), Color.decode("#FF4400"), Color.decode("#00AAFF"), Color.decode("#FF00D0"), Color.decode("#009933"), Color.decode("#FF5564"), Color.decode("#8100FF"), Color.decode("#891D1D"), Color.decode("#A78100"), Color.decode("#00600B")};
    private static ArrayList<ColorPalette> instanceList = null;
    private Color baseColor;
    private final ArrayList<Color> rectColorTable = new ArrayList();
    private final ArrayList<Color> fillColorTable = new ArrayList();

    public static void createInstance() {
        instanceList = new ArrayList();
        for (Color color : trackBaseColor) {
            instanceList.add(new ColorPalette(color));
        }
    }

    public static int getInstanceSize() {
        return trackBaseColor.length;
    }

    public static ColorPalette getInstance(int n) {
        if (instanceList == null) {
            ColorPalette.createInstance();
        }
        int n2 = n % instanceList.size();
        return instanceList.get(n2);
    }

    public ColorPalette(Color color) {
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.rectColorTable.clear();
        this.fillColorTable.clear();
        this.baseColor = color;
        for (ColorPattern colorPattern : ColorPattern.values()) {
            this.rectColorTable.add(colorPattern.getRectColor(color));
            this.fillColorTable.add(colorPattern.getFillColor(color));
        }
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    private Color getColor(List<Color> list, ColorPattern colorPattern) {
        int n;
        ColorPattern[] colorPatternArray = ColorPattern.values();
        for (n = 0; n < colorPatternArray.length && colorPatternArray[n] != colorPattern; ++n) {
        }
        return list.get(n % list.size());
    }

    public Color getActiveRectColor() {
        return this.getColor(this.rectColorTable, ColorPattern.ACTIVE);
    }

    public Color getActiveFillColor() {
        return this.getColor(this.fillColorTable, ColorPattern.ACTIVE);
    }

    public Color getPartRectColor(int n) {
        return this.getColor(this.rectColorTable, this.getColorType(n));
    }

    public Color getPartFillColor(int n) {
        return this.getColor(this.fillColorTable, this.getColorType(n));
    }

    public Color getUnusedFillColor() {
        return this.getColor(this.fillColorTable, ColorPattern.UNUSED);
    }

    public ColorPattern getColorType(int n) {
        switch (n) {
            case 0: {
                return ColorPattern.MELODY;
            }
            case 1: {
                return ColorPattern.CHORD1;
            }
            case 2: {
                return ColorPattern.CHORD2;
            }
            case 3: {
                return ColorPattern.SONGEX;
            }
        }
        return ColorPattern.UNUSED;
    }

    public static String toText(Color color) {
        return String.format("%08x", color.getRGB());
    }

    public static Color toColor(String string) {
        return new Color(Integer.parseUnsignedInt(string, 16), true);
    }

    public static void main(String[] stringArray) {
        ColorManager colorManager = ColorManager.defaultColor();
        int n = 12;
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            System.out.println("rectA=" + ColorPalette.toText(colorManager.getActiveRectColor(i)));
            System.out.println("fillA=" + ColorPalette.toText(colorManager.getActiveFillColor(i)));
            for (int j = 0; j < n2; ++j) {
                System.out.println("rect" + j + "=" + ColorPalette.toText(colorManager.getPartRectColor(i, j)));
                System.out.println("fill" + j + "=" + ColorPalette.toText(colorManager.getPartFillColor(i, j)));
            }
        }
        System.out.println("unused=" + ColorPalette.toText(colorManager.getUnusedFillColor()));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ColorPattern {
        ACTIVE(250, 200, 0),
        MELODY(0, 200, 0),
        CHORD1(0, 200, 40),
        CHORD2(0, 200, 80),
        SONGEX(0, 200, 120),
        UNUSED(0, 80, 0){

            @Override
            public Color getFillColor(Color color) {
                return Color.GRAY;
            }
        };

        private final int rectAlpha;
        private final int fillAlpha;
        private final int beta;

        protected Color filter(Color color) {
            return new Color(ColorPattern.limit(color.getRed() + this.beta), ColorPattern.limit(color.getGreen() + this.beta), ColorPattern.limit(color.getBlue() + this.beta), color.getAlpha());
        }

        private static int limit(int n) {
            if (n > 255) {
                return 255;
            }
            if (n < 0) {
                return 0;
            }
            return n;
        }

        private ColorPattern(int n2, int n3, int n4) {
            this.rectAlpha = n2;
            this.fillAlpha = n3;
            this.beta = n4;
        }

        public Color getRectColor(Color color) {
            return this.filter(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.rectAlpha));
        }

        public Color getFillColor(Color color) {
            return this.filter(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        }
    }
}

