/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.color;

import java.awt.Color;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;
import jp.fourthline.mabiicco.ui.color.ColorSet;

public enum ScaleColor implements SettingButtonGroupItem
{
    C_MAJOR("scale_color.c_major", 0),
    G_MAJOR("scale_color.g_major", 7),
    D_MAJOR("scale_color.d_major", 2),
    A_MAJOR("scale_color.a_major", 9),
    E_MAJOR("scale_color.e_major", 4),
    B_MAJOR("scale_color.b_major", 11),
    Gb_MAJOR("scale_color.gb_major", 6),
    Db_MAJOR("scale_color.db_major", 1),
    Ab_MAJOR("scale_color.ab_major", 8),
    Eb_MAJOR("scale_color.eb_major", 3),
    Bb_MAJOR("scale_color.bb_major", 10),
    F_MAJOR("scale_color.f_major", 5);

    private final String name;
    private final int offset;
    public static final Color BORDER_COLOR;

    private ScaleColor(String string2, int n2) {
        this.name = string2;
        this.offset = n2;
    }

    @Override
    public String getButtonName() {
        return this.name;
    }

    public Color getColor(int n) {
        return ColorConstants.keyMajorColors[(n + this.offset) % 12].get();
    }

    static {
        BORDER_COLOR = new Color(0.6f, 0.6f, 0.6f);
    }

    private static interface ColorConstants {
        public static final ColorSet wKeyColor = ColorSet.create(new Color(0.9f, 0.9f, 0.9f), Color.decode("#AAAAAA"));
        public static final ColorSet bKeyColor = ColorSet.create(new Color(0.8f, 0.8f, 0.8f), Color.decode("#666666"));
        public static final ColorSet[] keyMajorColors = new ColorSet[]{wKeyColor, bKeyColor, wKeyColor, bKeyColor, wKeyColor, bKeyColor, wKeyColor, wKeyColor, bKeyColor, wKeyColor, bKeyColor, wKeyColor};
    }
}

