/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.editor.AbstractColumnEditor;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mmlTools.MMLEvent;

public abstract class AbstractMarkerEditor<T extends MMLEvent>
extends AbstractColumnEditor {
    private final JMenuItem insertMenu;
    private final JMenuItem editMenu;
    private final JMenuItem deleteMenu;
    protected final String suffix;
    protected final String insertCommand;
    protected final String editCommand;
    protected final String deleteCommand;
    private final IEditAlign editAlign;
    protected final IMMLManager mmlManager;
    private final IViewTargetMarker viewTargetMarker;
    protected T targetEvent;
    protected int targetTick;

    public AbstractMarkerEditor(String string, IMMLManager iMMLManager, IEditAlign iEditAlign, IViewTargetMarker iViewTargetMarker) {
        this.suffix = string;
        this.insertCommand = "insert_" + string;
        this.editCommand = "edit_" + string;
        this.deleteCommand = "delete_" + string;
        this.mmlManager = iMMLManager;
        this.editAlign = iEditAlign;
        this.viewTargetMarker = iViewTargetMarker;
        this.insertMenu = this.newMenuItem(AppResource.appText("edit." + this.insertCommand), this.insertCommand);
        this.editMenu = this.newMenuItem(AppResource.appText("edit." + this.editCommand), this.editCommand);
        this.deleteMenu = this.newMenuItem(AppResource.appText("edit." + this.deleteCommand), this.deleteCommand);
    }

    @Override
    public List<JMenuItem> getMenuItems() {
        return Arrays.asList(this.insertMenu, this.editMenu, this.deleteMenu);
    }

    @Override
    protected void viewTargetMarker(JMenuItem jMenuItem, boolean bl) {
        if (!bl || !jMenuItem.isEnabled()) {
            this.viewTargetMarker.PaintOff();
        } else if (this.targetEvent != null) {
            this.viewTargetMarker.PaintOnTarget(((MMLEvent)this.targetEvent).getTickOffset());
        } else {
            this.viewTargetMarker.PaintOnTarget(this.targetTick);
        }
    }

    protected int targetTickAlign(int n) {
        return n - n % this.editAlign.getEditAlign();
    }

    @Override
    public void activateEditMenuItem(int n, int n2) {
        this.targetTick = this.targetTickAlign(n);
        this.targetEvent = this.getTempoEventOnTick(this.targetTick, n2);
        boolean bl = this.targetEvent != null;
        this.insertMenu.setEnabled(!bl);
        this.editMenu.setEnabled(bl);
        this.deleteMenu.setEnabled(bl);
    }

    private T getTempoEventOnTick(int n, int n2) {
        for (MMLEvent mMLEvent : this.getEventList()) {
            int n3 = mMLEvent.getTickOffset();
            if (n3 <= n - n2 || n3 >= n + n2) continue;
            return (T)mMLEvent;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        if (string.equals(this.insertCommand)) {
            bl = this.insertAction();
        } else if (string.equals(this.editCommand)) {
            bl = this.editAction();
        } else if (string.equals(this.deleteCommand)) {
            bl = this.deleteAction();
        }
        if (bl) {
            this.mmlManager.updateActivePart(true);
        }
    }

    protected abstract List<T> getEventList();

    protected abstract boolean insertAction();

    protected abstract boolean editAction();

    protected abstract boolean deleteAction();
}

