/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.SettingButtonGroupIconItem;
import jp.fourthline.mabiicco.ui.editor.EditMode;

public enum EditTool implements SettingButtonGroupIconItem
{
    NORMAL(EditMode.SELECT, 65, Cursor.getPredefinedCursor(0)),
    SPLIT(EditMode.SPLIT, 83, "Split Cursor", false),
    GLUE(EditMode.GLUE, 68, "Glue Cursor", true);

    private final EditMode mode;
    private final int keyCode;
    private final String viewName;
    private final ImageIcon icon;
    private final Cursor cursor;

    private EditTool(EditMode editMode, int n2, Cursor cursor) {
        this.mode = editMode;
        this.keyCode = n2;
        String string2 = "edit_tool." + this.name().toLowerCase();
        this.viewName = AppResource.appText(string2);
        this.icon = AppResource.getImageIcon(AppResource.appText(string2 + ".icon"));
        this.cursor = cursor;
    }

    private EditTool(EditMode editMode, int n2, String string2, boolean bl) {
        this.mode = editMode;
        this.keyCode = n2;
        String string3 = "edit_tool." + this.name().toLowerCase();
        this.viewName = AppResource.appText(string3);
        this.icon = AppResource.getImageIcon(AppResource.appText(string3 + ".icon"));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(this.icon.getIconWidth(), this.icon.getIconHeight());
        Point point = !bl ? new Point(0, 0) : new Point(0, dimension.height - 1);
        this.cursor = toolkit.createCustomCursor(this.icon.getImage(), point, string2);
    }

    public EditMode getEditMode() {
        return this.mode;
    }

    @Override
    public String getButtonName() {
        return this.viewName;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    public Cursor getCursor() {
        return this.cursor;
    }
}

