/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Point;
import java.util.List;
import java.util.function.LongFunction;
import jp.fourthline.mabiicco.midi.IPlayNote;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.editor.MMLEditor;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.core.MMLTicks;

public final class EditorAction {
    private final MMLEditor mmlEditor;
    private final IMMLManager mmlManager;
    private final PianoRollView pianoRollView;
    private final IPlayNote notePlayer;
    private final LongFunction<Long> tickAlignFunc;
    private int note;
    private long tickOffset;
    private long alignedTickOffset;
    private MMLEventList editEventList;

    public EditorAction(MMLEditor mMLEditor, IMMLManager iMMLManager, PianoRollView pianoRollView, IPlayNote iPlayNote, LongFunction<Long> longFunction) {
        this.mmlEditor = mMLEditor;
        this.mmlManager = iMMLManager;
        this.pianoRollView = pianoRollView;
        this.notePlayer = iPlayNote;
        this.tickAlignFunc = longFunction;
    }

    private boolean prepare(Point point) {
        this.note = this.pianoRollView.convertY2Note(point.y);
        this.tickOffset = this.pianoRollView.convertXtoTick(point.x);
        this.alignedTickOffset = this.tickAlignFunc.apply(this.tickOffset);
        this.editEventList = this.mmlManager.getActiveMMLPart();
        return this.editEventList != null;
    }

    public void newNoteAction(Point point) {
        if (this.prepare(point)) {
            MMLNoteEvent mMLNoteEvent = this.editEventList.searchPrevNoteOnTickOffset(this.tickOffset);
            MMLNoteEvent mMLNoteEvent2 = new MMLNoteEvent(this.note, this.mmlEditor.getEditAlign(), (int)this.alignedTickOffset);
            if (mMLNoteEvent != null) {
                mMLNoteEvent2.setVelocity(mMLNoteEvent.getVelocity());
            }
            this.mmlEditor.selectNote(mMLNoteEvent2);
            this.notePlayer.playNote(this.note, mMLNoteEvent2.getVelocity());
        }
    }

    public void splitAction(Point point) {
        MMLNoteEvent mMLNoteEvent;
        point.x += this.pianoRollView.convertTicktoX(this.mmlEditor.getEditAlign()) >> 1;
        if (this.prepare(point) && (mMLNoteEvent = this.editEventList.searchOnTickOffset(this.tickOffset)) != null && mMLNoteEvent.getNote() == this.note) {
            int n = mMLNoteEvent.getEndTick() - (int)this.alignedTickOffset;
            MMLNoteEvent mMLNoteEvent2 = new MMLNoteEvent(this.note, n, (int)this.alignedTickOffset);
            mMLNoteEvent2.setVelocity(mMLNoteEvent.getVelocity());
            this.mmlEditor.selectNote(mMLNoteEvent2);
            this.notePlayer.playNote(this.note, mMLNoteEvent2.getVelocity());
        }
    }

    public void glueAction(Point point) {
        if (this.prepare(point)) {
            MMLNoteEvent mMLNoteEvent = this.editEventList.searchOnTickOffset(this.tickOffset);
            MMLNoteEvent mMLNoteEvent2 = this.editEventList.searchOnTickOffsetNextNote(this.tickOffset);
            if (mMLNoteEvent != null && mMLNoteEvent2 != null && mMLNoteEvent.getNote() == mMLNoteEvent2.getNote() && this.note == mMLNoteEvent2.getNote()) {
                int n = mMLNoteEvent2.getEndTick() - mMLNoteEvent.getTickOffset();
                MMLNoteEvent mMLNoteEvent3 = new MMLNoteEvent(this.note, n, mMLNoteEvent.getTickOffset());
                mMLNoteEvent3.setVelocity(mMLNoteEvent.getVelocity());
                this.mmlEditor.selectNote(mMLNoteEvent3);
                this.notePlayer.playNote(this.note, mMLNoteEvent3.getVelocity());
            }
        }
    }

    public void editLengthAction(Point point, Point point2, boolean bl, List<MMLNoteEvent> list, List<MMLNoteEvent> list2) {
        if (this.prepare(point2)) {
            this.pianoRollView.onViewScrollPoint(point2);
            long l = this.pianoRollView.convertXtoTick(point.x);
            long l2 = this.tickOffset - l;
            for (int i = 0; i < list.size(); ++i) {
                MMLNoteEvent mMLNoteEvent = list2.get(i);
                MMLNoteEvent mMLNoteEvent2 = list.get(i);
                long l3 = (long)mMLNoteEvent.getEndTick() + l2;
                if (bl) {
                    l3 = this.tickAlignFunc.apply(l3);
                }
                int n = (int)l3 - mMLNoteEvent.getTickOffset();
                n = Math.max(n, MMLTicks.minimumTick());
                MMLNoteEvent mMLNoteEvent3 = this.editEventList.searchOnTickOffsetNextNote(mMLNoteEvent.getTickOffset());
                if (mMLNoteEvent3 != null) {
                    n = Math.min(n, mMLNoteEvent3.getTickOffset() - mMLNoteEvent.getTickOffset());
                }
                mMLNoteEvent2.setTick(n);
                if ((long)mMLNoteEvent.getTickOffset() > l || (long)mMLNoteEvent.getEndTick() <= l) continue;
                this.pianoRollView.setPaintNoteInfo(!bl ? mMLNoteEvent2 : null);
                this.notePlayer.playNote(mMLNoteEvent.getNote(), mMLNoteEvent.getVelocity());
            }
        }
    }
}

