/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.AbstractMarkerEditor;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mabiicco.ui.editor.NumberSpinner;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoConverter;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLVerifyException;

public final class MMLTempoEditor
extends AbstractMarkerEditor<MMLTempoEvent> {
    private final Frame parentFrame;

    public MMLTempoEditor(Frame frame, IMMLManager iMMLManager, IEditAlign iEditAlign, IViewTargetMarker iViewTargetMarker) {
        super("tempo", iMMLManager, iEditAlign, iViewTargetMarker);
        this.parentFrame = frame;
    }

    @Override
    protected List<MMLTempoEvent> getEventList() {
        return this.mmlManager.getMMLScore().getTempoEventList();
    }

    @Override
    protected boolean insertAction() {
        ArrayList<MMLTempoEvent> arrayList;
        boolean bl = true;
        int n = this.mmlManager.getMMLScore().getTempoOnTick(this.targetTick);
        TempoInputDialog tempoInputDialog = new TempoInputDialog(this.parentFrame, n, true);
        do {
            if ((n = tempoInputDialog.showTempoInputDialog(AppResource.appText("edit." + this.insertCommand), AppResource.appText("edit.label_" + this.suffix))) < 0) {
                return false;
            }
            arrayList = new ArrayList<MMLTempoEvent>(this.getEventList());
            new MMLTempoEvent(n, this.targetTick).appendToListElement(arrayList);
        } while (!(bl = this.updateTempoList(arrayList, this.targetTick, true, tempoInputDialog.isConvert(), tempoInputDialog.isDeleteSubseq())));
        return true;
    }

    @Override
    protected boolean editAction() {
        ArrayList<MMLTempoEvent> arrayList;
        boolean bl = true;
        int n = ((MMLTempoEvent)this.targetEvent).getTempo();
        TempoInputDialog tempoInputDialog = new TempoInputDialog(this.parentFrame, n, true);
        do {
            if ((n = tempoInputDialog.showTempoInputDialog(AppResource.appText("edit." + this.editCommand), AppResource.appText("edit.label_" + this.suffix))) < 0) {
                return false;
            }
            arrayList = new ArrayList<MMLTempoEvent>(this.getEventList());
            new MMLTempoEvent(n, ((MMLTempoEvent)this.targetEvent).getTickOffset()).appendToListElement(arrayList);
        } while (!(bl = this.updateTempoList(arrayList, ((MMLTempoEvent)this.targetEvent).getTickOffset(), true, tempoInputDialog.isConvert(), tempoInputDialog.isDeleteSubseq())));
        return true;
    }

    @Override
    protected boolean deleteAction() {
        if (!((Boolean)MabiIccoProperties.getInstance().enableTempoDeleteWithConvert.get()).booleanValue()) {
            this.getEventList().remove(this.targetEvent);
        } else {
            ArrayList<MMLTempoEvent> arrayList;
            boolean bl = true;
            int n = ((MMLTempoEvent)this.targetEvent).getTempo();
            TempoInputDialog tempoInputDialog = new TempoInputDialog(this.parentFrame, n, false);
            do {
                if ((n = tempoInputDialog.showTempoInputDialog(AppResource.appText("edit." + this.deleteCommand), AppResource.appText("edit.label_" + this.suffix))) < 0) {
                    return false;
                }
                arrayList = new ArrayList<MMLTempoEvent>(this.getEventList());
                arrayList.remove(this.targetEvent);
            } while (!(bl = this.updateTempoList(arrayList, ((MMLTempoEvent)this.targetEvent).getTickOffset(), true, tempoInputDialog.isConvert(), tempoInputDialog.isDeleteSubseq())));
        }
        return true;
    }

    boolean updateTempoList(List<MMLTempoEvent> list, int n, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<MMLTempoEvent> arrayList = new ArrayList<MMLTempoEvent>(list);
        if (bl3) {
            arrayList.removeIf(mMLTempoEvent -> mMLTempoEvent.getTickOffset() > n);
        }
        if (!bl2) {
            List<MMLTempoEvent> list2 = this.mmlManager.getMMLScore().getTempoEventList();
            list2.clear();
            list2.addAll(arrayList);
            return true;
        }
        int n2 = 0;
        if (bl) {
            MMLScore mMLScore = this.mmlManager.getMMLScore().clone();
            MMLTempoConverter mMLTempoConverter = MMLTempoConverter.convert(mMLScore, arrayList);
            try {
                mMLScore.generateAll();
            }
            catch (MMLExceptionList | MMLVerifyException exception) {
                JOptionPane.showMessageDialog(this.parentFrame, exception.getMessage(), AppResource.getAppTitle(), 2);
                return false;
            }
            String string = AppResource.appText("edit.tempoConvert.result");
            String string2 = AppResource.appText("edit.tempoConvert.result_label") + " = " + mMLTempoConverter.getConversionDiff();
            n2 = JOptionPane.showConfirmDialog(this.parentFrame, string2, string, 2);
        }
        if (n2 == 0) {
            MMLTempoConverter.convert(this.mmlManager.getMMLScore(), arrayList);
            return true;
        }
        return false;
    }

    private static class TempoInputDialog {
        private final Frame parentFrame;
        private final JCheckBox convertBox = UIUtils.createCheckBox("edit.tempoConvert", true);
        private final JCheckBox deleteSubseqBox = new JCheckBox(AppResource.appText("edit.delete_subseq_tempo"));
        private final JSpinner spinner;

        private TempoInputDialog(Frame frame, int n, boolean bl) {
            this.parentFrame = frame;
            this.spinner = NumberSpinner.createSpinner(n, 32, 255, 1);
            this.spinner.setFocusable(false);
            this.spinner.setEnabled(bl);
            UIUtils.setDefaultFocus(this.spinner);
            this.convertBox.setSelected(false);
            this.deleteSubseqBox.setSelected(false);
        }

        private int showTempoInputDialog(String string, String string2) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(string2));
            jPanel.add(this.spinner);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(this.convertBox);
            jPanel2.add(this.deleteSubseqBox);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
            int n = JOptionPane.showConfirmDialog(this.parentFrame, jPanel3, string, 2);
            if (n == 0) {
                return (Integer)this.spinner.getValue();
            }
            return -1;
        }

        private boolean isConvert() {
            return this.convertBox.isSelected();
        }

        private boolean isDeleteSubseq() {
            return this.deleteSubseqBox.isSelected();
        }
    }
}

