/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.editor.AbstractColumnEditor;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;

public final class StartOffsetEditor
extends AbstractColumnEditor {
    private static final String START_OFFSET = "startOffset";
    private static final String START_DELTA = "startDelta";
    private static final String START_SONG_DELTA = "startSongDelta";
    private final JMenuItem startOffsetMenu = this.newMenuItem(AppResource.appText("edit.label_startOffset"), "startOffset");
    private final JMenuItem startDeltaMenu = this.newMenuItem(AppResource.appText("edit.label_startDelta"), "startDelta");
    private final JMenuItem startSongDeltaMenu = this.newMenuItem(AppResource.appText("edit.label_startSongDelta"), "startSongDelta");
    private final Frame parentFrame;
    private final IMMLManager mmlManager;
    private final IEditAlign editAlign;
    private final IViewTargetMarker viewTargetMarker;
    private int targetTick;

    public StartOffsetEditor(Frame frame, IMMLManager iMMLManager, IEditAlign iEditAlign, IViewTargetMarker iViewTargetMarker) {
        this.parentFrame = frame;
        this.mmlManager = iMMLManager;
        this.editAlign = iEditAlign;
        this.viewTargetMarker = iViewTargetMarker;
    }

    @Override
    protected void viewTargetMarker(JMenuItem jMenuItem, boolean bl) {
        if (!bl || !jMenuItem.isEnabled()) {
            this.viewTargetMarker.PaintOff();
        } else {
            this.viewTargetMarker.PaintOnTarget(this.targetTick);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        System.out.println("Action: " + string + ", " + this.targetTick);
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        MMLTrack mMLTrack = this.mmlManager.getActiveTrack();
        try {
            switch (string) {
                case "startOffset": {
                    if (!mMLScore.setStartOffsetAll(this.targetTick)) {
                        throw new IllegalArgumentException();
                    }
                    break;
                }
                case "startDelta": {
                    mMLTrack.setStartDelta(this.targetTick - mMLTrack.getCommonStartOffset());
                    break;
                }
                case "startSongDelta": {
                    mMLTrack.setStartSongDelta(this.targetTick - mMLTrack.getCommonStartOffset());
                    break;
                }
                default: {
                    System.err.println("unknown action " + string);
                    return;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this.parentFrame, AppResource.appText("error.startOffset"), AppResource.getAppTitle(), 2);
        }
        this.mmlManager.updateActivePart(true);
    }

    @Override
    public List<JMenuItem> getMenuItems() {
        return List.of(this.startOffsetMenu, this.startDeltaMenu, this.startSongDeltaMenu);
    }

    @Override
    public void activateEditMenuItem(int n, int n2) {
        this.targetTick = n - n % this.editAlign.getEditAlign();
    }
}

