/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PianoRollScaler;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.RightIcon;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.color.ColorManager;
import jp.fourthline.mabiicco.ui.color.ColorSet;
import jp.fourthline.mabiicco.ui.editor.IEditContext;
import jp.fourthline.mabiicco.ui.editor.RangeMode;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.Measure;

public final class VelocityEditor
extends JPanel
implements MouseInputListener,
ActionListener,
PianoRollScaler.ChangeScaleListener,
Supplier<RangeMode> {
    private static final long serialVersionUID = -4676324927393791707L;
    public static int HEIGHT = 120;
    private final IMMLManager mmlManager;
    private final PianoRollView pianoRollView;
    private final IEditContext editContext;
    private boolean isEdit = false;
    private EditMode mode = EditMode.PENCIL_MODE;
    private RangeMode rangeMode = RangeMode.SELECTED_PART;
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 10.0f}, 0.0f);
    private static final BasicStroke velocityDashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);

    public VelocityEditor(IMMLManager iMMLManager, PianoRollView pianoRollView, IEditContext iEditContext) {
        this.mmlManager = iMMLManager;
        this.pianoRollView = pianoRollView;
        this.editContext = iEditContext;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), HEIGHT);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getWidth() {
        this.revalidate();
        return this.pianoRollView.getNewWidth();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        UIUtils.setRenderingHint(graphics2D);
        this.paintMeasure(graphics2D);
        this.paintVelocityLine(graphics2D);
        this.paintVelocityNote(graphics2D);
        this.mode.paintEditMode(this, graphics2D);
        this.paintViewBorder(graphics2D);
        graphics2D.dispose();
    }

    private static int velocityToY(int n) {
        return HEIGHT - VelocityEditor.velocityToH(n) - 3;
    }

    private static int velocityToH(int n) {
        return n * 7;
    }

    private static int yToVelocity(int n) {
        int n2 = (HEIGHT - n) / 7;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 15) {
            n2 = 15;
        }
        return n2;
    }

    private int tickToX(int n) {
        return this.pianoRollView.convertTicktoX(n);
    }

    private int velocityWidth() {
        return ((VelocityWidth)MabiIccoProperties.getInstance().velocityWidth.get()).w;
    }

    private void paintViewBorder(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = HEIGHT;
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(n, n2, 2, n4);
        graphics2D.fillRect(n + n3 - 2, n2, 2, n4);
        graphics2D.setColor(this.getForeground());
        graphics2D.drawRect(n + 2, n2 + 1, n3 - 5, n4 - 2);
    }

    private void paintMeasure(Graphics2D graphics2D) {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        graphics2D.setColor(this.getForeground());
        int n = 2;
        int n2 = n + HEIGHT - 4;
        int n3 = 0;
        while (this.tickToX(n3) < this.getWidth()) {
            int n4 = this.tickToX(n3);
            if (n4 > 0) {
                graphics2D.drawLine(n4, n, n4, n2);
            }
            n3 = Measure.nextMeasure(mMLScore, n3, true);
        }
    }

    private void paintVelocityLine(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashStroke);
        graphics2D.setColor(this.getForeground());
        List.of(Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(15)).forEach(n -> {
            int n2 = VelocityEditor.velocityToY(n);
            graphics2D.drawLine(0, n2, this.getWidth(), n2);
        });
        graphics2D.setStroke(stroke);
    }

    private MMLEventList getPart(int n, int n2) {
        return this.mmlManager.getMMLScore().getTrack(n).getMMLEventAtIndex(n2);
    }

    private void paintVelocityNote(Graphics2D graphics2D) {
        this.rangeMode.action(this.mmlManager, (int n, int n2) -> this.paintVelocityNote(graphics2D, n, n2));
    }

    private void paintVelocityNote(Graphics2D graphics2D, int n, int n2) {
        MMLEventList mMLEventList = this.getPart(n, n2);
        if (mMLEventList == null) {
            return;
        }
        Color color = ColorManager.defaultColor().getActiveRectColor(n);
        Color color2 = ColorManager.defaultColor().getActiveFillColor(n);
        for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
            int n3 = this.pianoRollView.isValidDrawNote(mMLNoteEvent);
            if (n3 < 0) continue;
            if (n3 > 0) break;
            int n4 = this.tickToX(mMLNoteEvent.getTickOffset());
            int n5 = mMLNoteEvent.getVelocity();
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > 15) {
                n5 = 15;
            }
            int n6 = Math.max(2, this.pianoRollView.convertTicktoX(mMLNoteEvent.getTick()));
            if (n4 + this.velocityWidth() < n4 + n6) {
                int n7 = n4 + n6 - 1;
                int n8 = VelocityEditor.velocityToY(n5);
                int n9 = VelocityEditor.velocityToY(0);
                graphics2D.setColor(this.getBackground());
                graphics2D.drawLine(n4, n8, n7, n8);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setColor(color);
                graphics2D.setStroke(velocityDashStroke);
                graphics2D.drawLine(n4 + this.velocityWidth(), n8, n7, n8);
                graphics2D.drawLine(n7, n8, n7, n9);
                graphics2D.setStroke(stroke);
            }
            UIUtils.drawRect(graphics2D, color, color2, n4, VelocityEditor.velocityToY(n5), this.velocityWidth(), VelocityEditor.velocityToH(n5) + 1);
        }
    }

    boolean isEdit() {
        return this.isEdit;
    }

    EditMode getEditMode() {
        return this.mode;
    }

    void setMode(EditMode editMode) {
        this.mode = editMode;
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.set(0, 0, HEIGHT, 0);
        return insets;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.mode.start(this, mouseEvent.getX(), mouseEvent.getY());
            this.isEdit = true;
            this.repaint();
        } else {
            this.isEdit = false;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEdit) {
            this.mode.update(this, mouseEvent.getX(), mouseEvent.getY());
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEdit && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.mode.applyEnd(this);
            this.isEdit = false;
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEdit && this.mode.move(this, -1, -1)) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEdit && this.mode.move(this, mouseEvent.getX(), mouseEvent.getY())) {
            this.repaint();
        }
    }

    @Override
    public void changeScale(int n) {
        Point point = this.mode.getCurrentPoint();
        if (this.isEdit) {
            this.mode.update(this, n, point.y);
        } else {
            this.mode.move(this, n, point.y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Supplier supplier;
        Object t;
        Object object = actionEvent.getSource();
        if (object instanceof VelocityEditorHeader.ModeButton) {
            VelocityEditorHeader.ModeButton modeButton = (VelocityEditorHeader.ModeButton)object;
            this.mode = modeButton.getMode();
        } else if (object instanceof Supplier && (t = (supplier = (Supplier)object).get()) instanceof RangeMode) {
            RangeMode rangeMode;
            this.rangeMode = rangeMode = (RangeMode)t;
            this.repaint();
        }
    }

    @Override
    public RangeMode get() {
        return this.rangeMode;
    }

    void setRangeMode(RangeMode rangeMode) {
        this.rangeMode = rangeMode;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EditMode {
        public static final EditMode PENCIL_MODE = new PencilMode();
        public static final EditMode LINE_MODE = new LineMode();
        private static final ColorSet editColor = ColorSet.create(new Color(32, 32, 255), new Color(0, 128, 255));
        private static final ColorSet editFillColor = ColorSet.create(new Color(0, 0, 0, 64), new Color(128, 128, 128, 64));
        private final String text;
        protected Map<Integer, Integer> editNoteMap = new TreeMap<Integer, Integer>();

        abstract void start(VelocityEditor var1, int var2, int var3);

        abstract void update(VelocityEditor var1, int var2, int var3);

        boolean move(VelocityEditor velocityEditor, int n, int n2) {
            return false;
        }

        abstract Point getCurrentPoint();

        final void applyEnd(VelocityEditor velocityEditor) {
            velocityEditor.rangeMode.action(velocityEditor.mmlManager, (n, n2) -> this.applyEnd(velocityEditor, n, n2));
            this.editNoteMap.clear();
            velocityEditor.mmlManager.updateActivePart(true);
        }

        final void applyEnd(VelocityEditor velocityEditor, int n, int n2) {
            MMLEventList mMLEventList = velocityEditor.getPart(n, n2);
            for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                Integer n3 = this.editNoteMap.get(mMLNoteEvent.getTickOffset());
                if (n3 == null) continue;
                mMLNoteEvent.setVelocity(n3);
            }
        }

        abstract void paintEditMode(VelocityEditor var1, Graphics2D var2);

        private EditMode(String string) {
            this.text = AppResource.appText("velocity_editor.mode." + string);
        }

        Map<Integer, Integer> getEditNoteMap() {
            return this.editNoteMap;
        }

        protected final void paintEditNoteMap(VelocityEditor velocityEditor, Graphics2D graphics2D) {
            int n = velocityEditor.velocityWidth();
            this.editNoteMap.forEach((n2, n3) -> {
                int n4 = velocityEditor.tickToX((int)n2);
                graphics2D.setColor(editFillColor.get());
                graphics2D.fillRect(n4, VelocityEditor.velocityToY(n3), n, VelocityEditor.velocityToH(n3));
                graphics2D.setColor(editColor.get());
                graphics2D.drawRect(n4, VelocityEditor.velocityToY(n3), n, VelocityEditor.velocityToH(n3));
                graphics2D.drawRect(n4 + 1, VelocityEditor.velocityToY(n3) + 1, n - 2, VelocityEditor.velocityToH(n3) - 2);
            });
        }

        protected final void paintVelocityString(Graphics2D graphics2D, Point point, boolean bl) {
            graphics2D.setColor(editColor.get());
            int n = VelocityEditor.yToVelocity(point.y);
            int n2 = point.x + (bl ? -24 : 12);
            int n3 = point.y + (n > 8 ? 12 : -4);
            graphics2D.drawString("v" + n, n2, n3);
        }

        private final String getText() {
            return this.text;
        }

        private static int xtoVelocity(Point point, Point point2, int n) {
            if (point.x != point2.x) {
                if (point2.x == n) {
                    return VelocityEditor.yToVelocity(point2.y);
                }
                if (point.x == n) {
                    return VelocityEditor.yToVelocity(point.y);
                }
                double d = ((double)n - (double)point.x) / (double)(point2.x - point.x);
                double d2 = (double)(point2.y - point.y) * d + (double)point.y;
                return VelocityEditor.yToVelocity((int)d2);
            }
            return VelocityEditor.yToVelocity(point2.y);
        }

        private static final class PencilMode
        extends EditMode {
            private Point currentPoint = new Point();
            private int currentTickOffset = -1;
            private int currentVelocity = -1;

            private PencilMode() {
                super("pencil");
            }

            @Override
            void start(VelocityEditor velocityEditor, int n, int n2) {
                this.editNoteMap.clear();
                this.currentPoint.x = n;
                this.currentPoint.y = n2;
                this.currentVelocity = -1;
                this.currentTickOffset = -1;
                this.update(velocityEditor, n, n2);
            }

            @Override
            void update(VelocityEditor velocityEditor, int n, int n2) {
                int n3 = velocityEditor.velocityWidth() / 2;
                Point point = new Point(n, n2);
                if (this.currentPoint.x <= n) {
                    for (int i = this.currentPoint.x; i < n - n3; i += n3) {
                        this.updateNoteVelocity(velocityEditor, point, i);
                    }
                } else {
                    for (int i = this.currentPoint.x; i > n + n3; i -= n3) {
                        this.updateNoteVelocity(velocityEditor, point, i);
                    }
                }
                this.updateNoteVelocity(velocityEditor, point, n);
                this.move(velocityEditor, n, n2);
            }

            private void updateNoteVelocity(VelocityEditor velocityEditor, Point point, int n) {
                velocityEditor.rangeMode.action(velocityEditor.mmlManager, (n2, n3) -> this.updateNoteVelocity(velocityEditor, point, n, n2, n3));
            }

            private void updateNoteVelocity(VelocityEditor velocityEditor, Point point, int n, int n2, int n3) {
                MMLEventList mMLEventList = velocityEditor.getPart(n2, n3);
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    int n4 = velocityEditor.tickToX(mMLNoteEvent.getTickOffset());
                    if (n4 > n || n4 + velocityEditor.velocityWidth() <= n || velocityEditor.editContext.hasSelectedNote() && !velocityEditor.editContext.isSelectedNote(mMLNoteEvent)) continue;
                    this.currentTickOffset = mMLNoteEvent.getTickOffset();
                    this.currentVelocity = EditMode.xtoVelocity(this.currentPoint, point, n);
                    this.editNoteMap.put(this.currentTickOffset, this.currentVelocity);
                }
            }

            @Override
            boolean move(VelocityEditor velocityEditor, int n, int n2) {
                this.currentPoint.x = n;
                this.currentPoint.y = n2;
                return true;
            }

            @Override
            Point getCurrentPoint() {
                return this.currentPoint;
            }

            @Override
            public void paintEditMode(VelocityEditor velocityEditor, Graphics2D graphics2D) {
                if (velocityEditor.isEdit) {
                    if (this.currentTickOffset >= 0) {
                        int n = velocityEditor.tickToX(this.currentTickOffset) + velocityEditor.velocityWidth();
                        int n2 = VelocityEditor.velocityToY(this.currentVelocity);
                        this.paintVelocityString(graphics2D, new Point(n, n2), false);
                    }
                    this.paintEditNoteMap(velocityEditor, graphics2D);
                }
                if (this.currentPoint.x >= 0 && this.currentPoint.y >= 0) {
                    this.paintActiveLine(velocityEditor, graphics2D);
                }
            }

            private void paintActiveLine(VelocityEditor velocityEditor, Graphics2D graphics2D) {
                velocityEditor.rangeMode.action(velocityEditor.mmlManager, (n, n2) -> this.paintActiveLine(velocityEditor, graphics2D, n, n2));
            }

            private void paintActiveLine(VelocityEditor velocityEditor, Graphics2D graphics2D, int n, int n2) {
                MMLEventList mMLEventList = velocityEditor.getPart(n, n2);
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    int n3 = velocityEditor.tickToX(mMLNoteEvent.getTickOffset());
                    if (n3 > this.currentPoint.x || n3 + velocityEditor.velocityWidth() <= this.currentPoint.x || velocityEditor.editContext.hasSelectedNote() && !velocityEditor.editContext.isSelectedNote(mMLNoteEvent)) continue;
                    int n4 = 8;
                    int n5 = n4 / 2;
                    int[] nArray = new int[]{n3 + 1, n3 + n5, n3 + n4};
                    int[] nArray2 = new int[]{2, 10, 2};
                    Color color = ColorManager.defaultColor().getActiveRectColor(n);
                    graphics2D.setColor(color);
                    graphics2D.fillPolygon(nArray, nArray2, nArray.length);
                    graphics2D.setColor(velocityEditor.getForeground());
                    graphics2D.drawPolygon(nArray, nArray2, nArray.length);
                    break;
                }
            }
        }

        private static final class LineMode
        extends EditMode {
            private Point startPoint = new Point();
            private Point endPoint = new Point();

            private LineMode() {
                super("line");
            }

            private Point leftPoint() {
                return this.startPoint.x < this.endPoint.x ? this.startPoint : this.endPoint;
            }

            private Point rightPoint() {
                return this.startPoint.x < this.endPoint.x ? this.endPoint : this.startPoint;
            }

            @Override
            void start(VelocityEditor velocityEditor, int n, int n2) {
                this.startPoint.x = this.endPoint.x = n;
                this.startPoint.y = this.endPoint.y = n2;
                this.editNoteMap.clear();
            }

            @Override
            void update(VelocityEditor velocityEditor, int n, int n2) {
                this.endPoint.x = n;
                this.endPoint.y = n2;
                this.updateEditNote(velocityEditor);
            }

            private void updateEditNote(VelocityEditor velocityEditor) {
                this.editNoteMap.clear();
                velocityEditor.rangeMode.action(velocityEditor.mmlManager, (n, n2) -> this.updateEditNote(velocityEditor, n, n2));
            }

            private void updateEditNote(VelocityEditor velocityEditor, int n, int n2) {
                MMLEventList mMLEventList = velocityEditor.getPart(n, n2);
                if (mMLEventList == null) {
                    return;
                }
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    int n3 = mMLNoteEvent.getTickOffset();
                    int n4 = velocityEditor.tickToX(n3) + velocityEditor.velocityWidth() / 2 - 1;
                    int n5 = EditMode.xtoVelocity(this.startPoint, this.endPoint, n4);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 > 15) {
                        n5 = 15;
                    }
                    if (this.leftPoint().x > n4) continue;
                    if (this.rightPoint().x <= n4) break;
                    if (velocityEditor.editContext.hasSelectedNote() && !velocityEditor.editContext.isSelectedNote(mMLNoteEvent)) continue;
                    this.editNoteMap.put(n3, n5);
                    System.out.println(this.editNoteMap);
                }
            }

            @Override
            Point getCurrentPoint() {
                return this.endPoint;
            }

            @Override
            public void paintEditMode(VelocityEditor velocityEditor, Graphics2D graphics2D) {
                if (velocityEditor.isEdit) {
                    Point point = this.leftPoint();
                    Point point2 = this.rightPoint();
                    graphics2D.setColor(editColor.get());
                    graphics2D.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
                    this.paintVelocityString(graphics2D, point, true);
                    this.paintVelocityString(graphics2D, point2, false);
                    this.paintEditNoteMap(velocityEditor, graphics2D);
                }
            }
        }
    }

    public static enum VelocityWidth implements SettingButtonGroupItem
    {
        W2(2),
        W4(4),
        W6(6),
        W8(8),
        W10(10);

        private final int w;

        private VelocityWidth(int n2) {
            this.w = n2;
        }

        @Override
        public String getButtonName() {
            return this.w + "px";
        }

        public String toString() {
            return this.getButtonName();
        }
    }

    public static final class VelocityEditorHeader
    extends JPanel {
        private static final long serialVersionUID = 317664857011489248L;
        private final Dimension size = new Dimension(60, 2);

        public VelocityEditorHeader(ActionListener actionListener, Supplier<RangeMode> supplier) {
            this.setLayout(new BoxLayout(this, 1));
            ButtonGroup buttonGroup = new ButtonGroup();
            ModeButton modeButton = new ModeButton("P", EditMode.PENCIL_MODE, actionListener, buttonGroup, true);
            ModeButton modeButton2 = new ModeButton("L", EditMode.LINE_MODE, actionListener, buttonGroup);
            JButton jButton = new JButton(new RightIcon(10));
            jButton.addActionListener(actionEvent -> {
                JPopupMenu jPopupMenu = new JPopupMenu();
                UIUtils.createGroupMenu(jPopupMenu, AppResource.appText("velocity_editor.width"), MabiIccoProperties.getInstance().velocityWidth);
                jPopupMenu.show(this, jButton.getBounds().x + jButton.getBounds().width, jButton.getBounds().y);
            });
            jButton.setFocusable(false);
            JButton jButton2 = new JButton("R");
            jButton2.setToolTipText(AppResource.appText("velocity_editor.range_button"));
            jButton2.addActionListener(actionEvent -> {
                JPopupMenu jPopupMenu = new JPopupMenu();
                UIUtils.createGroupMenu(jPopupMenu, RangeMode.values(), actionListener, (SettingButtonGroupItem)supplier.get());
                jPopupMenu.show(this, jButton.getBounds().x + jButton.getBounds().width, jButton.getBounds().y);
            });
            jButton2.setFocusable(false);
            JToolBar jToolBar = UIUtils.createToolBar(1);
            jToolBar.add(jButton);
            jToolBar.add(jButton2);
            jToolBar.addSeparator();
            jToolBar.add(modeButton);
            jToolBar.add(modeButton2);
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            jPanel.setOpaque(false);
            jPanel.add(jToolBar);
            this.add(jPanel);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            UIUtils.setRenderingHint(graphics2D);
            this.paintVelocityHeaderString(graphics2D, 0);
            this.paintVelocityHeaderString(graphics2D, 8);
            this.paintVelocityHeaderString(graphics2D, 15);
            graphics2D.dispose();
        }

        private void paintVelocityHeaderString(Graphics2D graphics2D, int n) {
            graphics2D.setColor(this.getForeground());
            int n2 = 38;
            int n3 = VelocityEditor.velocityToY(n);
            graphics2D.drawString("v" + n, n2, n3);
        }

        private static class ModeButton
        extends JToggleButton {
            private static final long serialVersionUID = 2077168652765502025L;
            private final EditMode mode;

            private ModeButton(String string, EditMode editMode, ActionListener actionListener, ButtonGroup buttonGroup) {
                this(string, editMode, actionListener, buttonGroup, false);
            }

            private ModeButton(String string, EditMode editMode, ActionListener actionListener, ButtonGroup buttonGroup, boolean bl) {
                super(string, bl);
                this.mode = editMode;
                this.addActionListener(actionListener);
                buttonGroup.add(this);
                this.setToolTipText(editMode.getText());
                this.setFocusable(false);
            }

            public EditMode getMode() {
                return this.mode;
            }
        }
    }
}

