/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.mml.MMLInputPanel;
import jp.fourthline.mmlTools.core.MMLText;

public final class MMLXImportPanel
extends JPanel {
    private static final long serialVersionUID = -4785719857155935699L;
    private static final int MAX_N = 10;
    private final JTable table;
    private final DefaultTableModel tableModel;
    private final List<MMLText> textList;
    private final JLabel rankText = new JLabel();
    private final JDialog dialog;
    private final Frame parentFrame;
    private final String trackName;
    IMMLManager mmlManager;
    private final JButton pasteButton = new JButton(AppResource.appText("mml_x_import.paste"));
    private final JButton deleteButton = new JButton(AppResource.appText("mml_x_import.delete"));
    private final JButton convertButton = new JButton(AppResource.appText("mml_x_import.merge"));
    private final JButton cancelButton = new JButton(AppResource.appText("mml_x_import.cancel"));
    private final JCheckBox excludeSongCheckBox = new JCheckBox(AppResource.appText("instrument.excludeSongPart"));

    public MMLXImportPanel(Frame frame, String string, IMMLManager iMMLManager) {
        this.dialog = new JDialog(frame, AppResource.appText("menu.mml_x_import"), true);
        UIUtils.dialogCloseAction(this.dialog);
        this.parentFrame = frame;
        this.trackName = string;
        this.mmlManager = iMMLManager;
        this.textList = new ArrayList<MMLText>();
        IntStream.range(0, 10).forEach(n -> this.textList.add(new MMLText()));
        Object[] objectArray = new String[]{"#", AppResource.appText("mml.output.rank")};
        this.tableModel = new DefaultTableModel(objectArray, 10);
        this.table = new JTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(240);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setRequestFocusEnabled(false);
        this.table.setFocusable(false);
        this.table.setSelectionMode(0);
        this.table.setRowSelectionInterval(0, 0);
        this.initializePanel();
        this.updateData();
    }

    private void initializePanel() {
        this.setLayout(new BorderLayout());
        this.pasteButton.addActionListener(actionEvent -> {
            String string = MMLInputPanel.getClipboardString();
            MMLText mMLText = new MMLText().setMMLText(string);
            if (!mMLText.isEmpty()) {
                int n = this.table.getSelectedRow();
                this.textList.get(n).setMMLText(string);
                this.updateData();
                this.nextSelect();
            }
        });
        this.deleteButton.addActionListener(actionEvent -> {
            this.textList.set(this.table.getSelectedRow(), new MMLText());
            this.updateData();
        });
        this.convertButton.addActionListener(actionEvent -> {
            this.dialog.setVisible(false);
            MMLInputPanel mMLInputPanel = new MMLInputPanel(this.parentFrame, this.trackName, this.mmlManager, this.excludeSongCheckBox.isSelected());
            mMLInputPanel.showDialog(this.textJoin().getMML());
        });
        this.cancelButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        this.excludeSongCheckBox.addActionListener(actionEvent -> this.updateData());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(this.table.getPreferredSize().width, this.table.getPreferredSize().height + 60));
        jScrollPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.add(this.pasteButton);
        jPanel.add(this.deleteButton);
        jPanel2.add(this.convertButton);
        jPanel2.add(this.cancelButton);
        JPanel jPanel3 = UIUtils.createTitledPanel("mml_x_import.split", new BorderLayout());
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new EmptyBorder(0, 10, 0, 10));
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.rankText);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.excludeSongCheckBox);
        jPanel5.add((Component)jPanel6, "North");
        jPanel5.add((Component)jPanel7, "Center");
        jPanel5.add((Component)jPanel2, "South");
        this.add((Component)jPanel4, "Center");
        this.add((Component)jPanel5, "South");
    }

    MMLText textJoin() {
        MMLText mMLText = new MMLText();
        for (MMLText mMLText2 : this.textList) {
            mMLText.join(mMLText2);
        }
        return mMLText;
    }

    private void updateData() {
        boolean bl = this.excludeSongCheckBox.isSelected();
        for (int i = 0; i < this.textList.size(); ++i) {
            this.tableModel.setValueAt(i + 1, i, 0);
            MMLText mMLText = this.textList.get(i);
            mMLText.setExcludeSongPart(bl);
            String string = mMLText.isEmpty() ? "-" : mMLText.mmlRankFormat();
            this.tableModel.setValueAt(string, i, 1);
        }
        MMLText mMLText = this.textJoin();
        mMLText.setExcludeSongPart(bl);
        this.rankText.setText(mMLText.mmlRankFormat());
        this.convertButton.setEnabled(!mMLText.isEmpty());
    }

    private void nextSelect() {
        int n = this.table.getSelectedRow();
        if (n + 1 < this.table.getRowCount()) {
            this.table.setRowSelectionInterval(++n, n);
        }
    }

    List<MMLText> getTextList() {
        return this.textList;
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }
}

