/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.MMLText;

public final class PartListTable
extends JTable {
    private static final long serialVersionUID = -331949379948206213L;
    public static final String ERR = "error";
    private final InCheckTableModel checkTableModel;

    public PartListTable(List<MMLTrack> list, boolean bl, int n) {
        this.checkTableModel = new InCheckTableModel(list, bl, n);
        this.initialize(bl);
    }

    private void initialize(boolean bl) {
        this.setModel(this.checkTableModel);
        if (bl) {
            this.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
            this.getColumnModel().getColumn(0).setPreferredWidth(0);
            this.getColumnModel().getColumn(1).setPreferredWidth(20);
            this.getColumnModel().getColumn(1).setMaxWidth(20);
            this.getColumnModel().getColumn(5).setMaxWidth(180);
            this.setRowSelectionAllowed(false);
        } else {
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(0).setMaxWidth(20);
            this.getColumnModel().getColumn(4).setMaxWidth(180);
            this.setSelectionMode(0);
            this.setRowSelectionInterval(0, 0);
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.setFocusable(false);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = this.getValueAt(n, 1);
            if (object != null && !object.toString().isBlank()) {
                MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, this.gridColor);
                jComponent.setBorder(BorderFactory.createCompoundBorder(matteBorder, jComponent.getBorder()));
            }
        }
        return component;
    }

    public List<MMLEventList> getCheckedEventList() {
        ArrayList<MMLEventList> arrayList = new ArrayList<MMLEventList>();
        for (int i = 0; i < this.checkTableModel.checkValue.length; ++i) {
            if (!this.checkTableModel.checkValue[i]) continue;
            arrayList.add(this.checkTableModel.eventList.get(i));
        }
        return arrayList;
    }

    private static final class InCheckTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8842111776415664364L;
        private final String[] columnNames = new String[]{"", "#", AppResource.appText("mml.output.trackName"), AppResource.appText("mml.output.instrument"), AppResource.appText("mml.output.partname"), AppResource.appText("mml.output.textCount")};
        private final boolean checkBox;
        private final boolean[] checkValue;
        private final List<Object[]> dataList = new ArrayList<Object[]>();
        private final List<MMLEventList> eventList = new ArrayList<MMLEventList>();
        private final int maxCount;
        private static final List<String> partNameList = List.of("melody", "chord1", "chord2", "song");

        private InCheckTableModel(List<MMLTrack> list, boolean bl, int n) {
            this.checkBox = bl;
            this.maxCount = n;
            int n2 = 0;
            for (MMLTrack mMLTrack : list) {
                InstClass instClass = MabiDLS.getInstance().getInstByProgram(mMLTrack.getProgram());
                InstClass instClass2 = MabiDLS.getInstance().getInstByProgram(mMLTrack.getSongProgram());
                boolean[] blArray = InstClass.getEnablePartByProgram(mMLTrack.getProgram());
                boolean[] blArray2 = InstClass.getEnablePartByProgram(mMLTrack.getSongProgram());
                int n3 = n2 + 1;
                String string = mMLTrack.getTrackName();
                MMLText mMLText = new MMLText().setMMLText(mMLTrack.getMabiMML());
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i] && !blArray2[i]) continue;
                    String string2 = blArray[i] ? instClass.toString() : instClass2.toString();
                    String string3 = AppResource.appText(partNameList.get(i));
                    this.dataList.add(new Object[]{n3 > 0 ? Integer.valueOf(n3) : "", n3 > 0 ? string : "", n3 > 0 || i == 3 ? string2 : "", string3, mMLText.getText(i).length()});
                    this.eventList.add(mMLTrack.getMMLEventAtIndex(i));
                    n3 = 0;
                }
                ++n2;
            }
            this.checkValue = new boolean[this.eventList.size()];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public int getColumnCount() {
            int n = this.columnNames.length;
            if (!this.checkBox) {
                --n;
            }
            return n;
        }

        @Override
        public int getRowCount() {
            return this.dataList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (!this.checkBox) {
                ++n2;
            }
            if (n2 == 0) {
                return this.checkValue[n];
            }
            return this.dataList.get(n)[n2 - 1];
        }

        @Override
        public String getColumnName(int n) {
            if (!this.checkBox) {
                ++n;
            }
            return this.columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!this.checkBox) {
                ++n2;
            }
            if (n2 == 0) {
                if (this.getCheckCount() < this.maxCount) {
                    return true;
                }
                return this.checkValue[n];
            }
            return false;
        }

        public int getCheckCount() {
            int n = 0;
            for (boolean bl : this.checkValue) {
                if (!bl) continue;
                ++n;
            }
            return n;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!this.checkBox) {
                ++n2;
            }
            if (n2 != 0) {
                return;
            }
            this.checkValue[n] = object.equals(Boolean.TRUE);
        }
    }

    private static class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final long serialVersionUID = 530480365007196131L;
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        private CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            if (jTable instanceof PartListTable) {
                PartListTable partListTable = (PartListTable)jTable;
                boolean bl3 = partListTable.checkTableModel.getCheckCount() < partListTable.checkTableModel.maxCount || this.isSelected();
                this.setEnabled(bl3);
            }
            return this;
        }
    }
}

